/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.ai;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class SpiderWebShootGoal
extends Goal {
    private final Spider spider;
    private final Level level;
    private final double shootRange;
    private final int chargeTime;
    private final int webDuration;
    private static final Map<UUID, Map<UUID, Boolean>> spiderWebUsage = new HashMap<UUID, Map<UUID, Boolean>>();
    private int chargingTicks = 0;
    private boolean isCharging = false;
    private BlockPos webPosition = null;
    private long webSpawnTime = 0L;

    public SpiderWebShootGoal(Spider spider) {
        this.spider = spider;
        this.level = spider.level();
        this.shootRange = 12.0;
        this.chargeTime = 40;
        this.webDuration = 100;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        Map<UUID, Boolean> targetMap;
        Player player;
        LivingEntity target = this.spider.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (target.getType().toString().equals("minecraft:player") && ((player = (Player)target).isSpectator() || player.getAbilities().instabuild)) {
            return false;
        }
        double distance = this.spider.distanceToSqr((Entity)target);
        if (distance > this.shootRange * this.shootRange) {
            return false;
        }
        UUID spiderId = this.spider.getUUID();
        UUID targetId = target.getUUID();
        if (!spiderWebUsage.containsKey(spiderId)) {
            spiderWebUsage.put(spiderId, new HashMap());
        }
        return !(targetMap = spiderWebUsage.get(spiderId)).containsKey(targetId) || targetMap.get(targetId) == false;
    }

    public boolean canContinueToUse() {
        LivingEntity target = this.spider.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (this.webPosition != null) {
            if (this.webSpawnTime > 0L && this.level.getGameTime() - this.webSpawnTime > (long)this.webDuration) {
                if (this.level.getBlockState(this.webPosition).getBlock() == Blocks.COBWEB) {
                    this.level.removeBlock(this.webPosition, false);
                }
                this.webPosition = null;
                this.webSpawnTime = 0L;
                return false;
            }
            return false;
        }
        if (this.isCharging) {
            double distance = this.spider.distanceToSqr((Entity)target);
            if (distance > this.shootRange * this.shootRange) {
                this.isCharging = false;
                this.chargingTicks = 0;
                return false;
            }
            return true;
        }
        return false;
    }

    public void start() {
        LivingEntity target = this.spider.getTarget();
        if (target == null) {
            return;
        }
        this.spider.getNavigation().stop();
        this.isCharging = true;
        this.chargingTicks = 0;
        this.webPosition = null;
        this.webSpawnTime = 0L;
    }

    public void stop() {
        LivingEntity target;
        this.isCharging = false;
        this.chargingTicks = 0;
        if (this.webPosition != null && this.webSpawnTime > 0L && (target = this.spider.getTarget()) != null) {
            UUID spiderId = this.spider.getUUID();
            UUID targetId = target.getUUID();
            if (spiderWebUsage.containsKey(spiderId)) {
                spiderWebUsage.get(spiderId).put(targetId, true);
            }
        }
    }

    public void tick() {
        LivingEntity target = this.spider.getTarget();
        if (target == null) {
            return;
        }
        this.spider.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        if (this.isCharging) {
            ++this.chargingTicks;
            if (this.chargingTicks % 2 == 0) {
                Vec3 spiderPos = this.spider.position();
                Vec3 lookDirection = this.spider.getLookAngle();
                double eyeX = spiderPos.x + lookDirection.x * 1.0;
                double eyeY = spiderPos.y + (double)this.spider.getEyeHeight() + lookDirection.y * 1.0;
                double eyeZ = spiderPos.z + lookDirection.z * 1.0;
                if (this.level.isClientSide()) {
                    for (int i = 0; i < 3; ++i) {
                        double offsetX = (this.level.random.nextDouble() - 0.5) * 0.2;
                        double offsetZ = (this.level.random.nextDouble() - 0.5) * 0.2;
                        this.level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.COBWEB.defaultBlockState()), eyeX + offsetX, eyeY, eyeZ + offsetZ, 0.0, -0.2, 0.0);
                    }
                } else {
                    ((ServerLevel)this.level).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.COBWEB.defaultBlockState()), eyeX, eyeY, eyeZ, 5, 0.2, -0.1, 0.2, 0.0);
                }
            }
            if (this.chargingTicks >= this.chargeTime) {
                this.generateWebAtTarget(target);
                UUID spiderId = this.spider.getUUID();
                UUID targetId = target.getUUID();
                if (spiderWebUsage.containsKey(spiderId)) {
                    spiderWebUsage.get(spiderId).put(targetId, true);
                }
                this.isCharging = false;
                this.chargingTicks = 0;
            }
        }
    }

    private void generateWebAtTarget(LivingEntity target) {
        BlockPos webBlockPos = BlockPos.containing((double)target.getX(), (double)target.getY(), (double)target.getZ());
        if (this.level.getBlockState(webBlockPos).isAir() || this.level.getBlockState(webBlockPos).getBlock() == Blocks.COBWEB || this.level.getBlockState(webBlockPos).canBeReplaced()) {
            int i;
            this.level.setBlock(webBlockPos, Blocks.COBWEB.defaultBlockState(), 3);
            this.webPosition = webBlockPos;
            this.webSpawnTime = this.level.getGameTime();
            Vec3 spiderPos = this.spider.position();
            Vec3 targetPos = Vec3.atCenterOf((Vec3i)webBlockPos);
            for (i = 0; i < 30; ++i) {
                double progress = (double)i / 30.0;
                double x = spiderPos.x + (targetPos.x - spiderPos.x) * progress;
                double y = spiderPos.y + (double)this.spider.getEyeHeight() + (targetPos.y - spiderPos.y - (double)this.spider.getEyeHeight()) * progress;
                double z = spiderPos.z + (targetPos.z - spiderPos.z) * progress;
                if (this.level.isClientSide()) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 0.0, 0.1, 0.0);
                    continue;
                }
                ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 1, 0.0, 0.1, 0.0, 0.0);
            }
            for (i = 0; i < 20; ++i) {
                double offsetX = (this.level.random.nextDouble() - 0.5) * 1.0;
                double offsetY = (this.level.random.nextDouble() - 0.5) * 1.0;
                double offsetZ = (this.level.random.nextDouble() - 0.5) * 1.0;
                if (this.level.isClientSide()) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.CLOUD, targetPos.x + offsetX, targetPos.y + offsetY, targetPos.z + offsetZ, 0.0, 0.1, 0.0);
                    continue;
                }
                ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.CLOUD, targetPos.x + offsetX, targetPos.y + offsetY, targetPos.z + offsetZ, 1, 0.0, 0.1, 0.0, 0.0);
            }
            this.spider.playSound(SoundEvents.SPIDER_STEP, 1.0f, 1.0f);
        }
    }

    public static void onSpiderDeath(UUID spiderId) {
        spiderWebUsage.remove(spiderId);
    }

    public static void onTargetDeath(UUID targetId) {
        for (Map<UUID, Boolean> targetMap : spiderWebUsage.values()) {
            targetMap.remove(targetId);
        }
    }
}

