/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.ai;

import com.example.examplemod.command.ProtectCommand;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class WitchSummonZombiesGoal
extends Goal {
    private static final Map<UUID, Integer> COOLDOWN_MAP = new HashMap<UUID, Integer>();
    private static final Map<UUID, Witch> WITCH_MAP = new HashMap<UUID, Witch>();
    private static final Map<UUID, List<UUID>> WITCH_GUARDS_MAP = new HashMap<UUID, List<UUID>>();
    private final Witch witch;
    private final Level level;
    private final double moveSpeedAmp;
    private final int cooldownTime;
    private final int chargeTime;
    private final int summonDistance;
    private int chargeTicks;
    private boolean isCharging;
    private boolean isMovingAway;
    private LivingEntity target;
    private BlockPos targetPosition;
    private Path currentPath;
    private int pathRecalculateTimer;

    public static void globalTick() {
        try {
            if (WITCH_MAP.size() > 0) {
                Witch firstWitch = WITCH_MAP.values().iterator().next();
                if (firstWitch != null && firstWitch.isAlive() && firstWitch.tickCount % 100 == 0) {
                    for (Map.Entry<UUID, Integer> entry : COOLDOWN_MAP.entrySet()) {
                        Witch witch = WITCH_MAP.get(entry.getKey());
                        if (witch == null || !witch.isAlive()) continue;
                        System.out.println("Witch " + entry.getKey().toString().substring(0, 8) + ": cooldown=" + String.valueOf(entry.getValue()));
                    }
                }
                for (Map.Entry<UUID, Integer> entry : COOLDOWN_MAP.entrySet()) {
                    Witch witch;
                    if (entry.getValue() <= 0) continue;
                    int newCooldown = entry.getValue() - 1;
                    COOLDOWN_MAP.put(entry.getKey(), newCooldown);
                    if (newCooldown != 0 || (witch = WITCH_MAP.get(entry.getKey())) == null || !witch.isAlive()) continue;
                    System.out.println("Witch " + entry.getKey().toString().substring(0, 8) + ": Cooldown finished, can summon again");
                }
            }
            for (Map.Entry entry : WITCH_MAP.entrySet()) {
                UUID witchId = (UUID)entry.getKey();
                Witch witch = (Witch)entry.getValue();
                if (witch == null || !witch.isAlive() || witch.level() == null || witch.level().isClientSide()) continue;
                LivingEntity witchTarget = witch.getTarget();
                List<UUID> guardIds = WITCH_GUARDS_MAP.get(witchId);
                if (guardIds == null) continue;
                ArrayList<UUID> guardIdsCopy = new ArrayList<UUID>(guardIds);
                for (UUID guardId2 : guardIdsCopy) {
                    try {
                        Zombie zombie;
                        Entity entity = witch.level().getEntity(guardId2);
                        if (!(entity instanceof Zombie) || !(zombie = (Zombie)entity).isAlive() || witchTarget == null || !witchTarget.isAlive()) continue;
                        zombie.setTarget(witchTarget);
                    }
                    catch (Exception e) {
                        System.err.println("Error updating guard zombie: " + e.getMessage());
                    }
                }
                guardIds.removeIf(guardId -> {
                    try {
                        Entity entity = witch.level().getEntity(guardId);
                        return !(entity instanceof Zombie) || !entity.isAlive();
                    }
                    catch (Exception e) {
                        return true;
                    }
                });
                if (!guardIds.isEmpty()) continue;
                WITCH_GUARDS_MAP.remove(witchId);
            }
        }
        catch (Exception e) {
            System.err.println("Error in WitchSummonZombiesGoal.globalTick: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void removeGuard(UUID witchId, UUID guardId) {
        List<UUID> guardIds = WITCH_GUARDS_MAP.get(witchId);
        if (guardIds != null) {
            guardIds.remove(guardId);
            if (guardIds.isEmpty()) {
                WITCH_GUARDS_MAP.remove(witchId);
            }
        }
    }

    public WitchSummonZombiesGoal(Witch witch) {
        if (witch == null) {
            throw new IllegalArgumentException("Witch entity cannot be null");
        }
        this.witch = witch;
        this.level = witch.level();
        this.moveSpeedAmp = 1.7;
        this.cooldownTime = 2400;
        this.chargeTime = 40;
        this.summonDistance = 12;
        this.chargeTicks = 0;
        this.isCharging = false;
        this.isMovingAway = false;
        this.targetPosition = null;
        this.currentPath = null;
        this.pathRecalculateTimer = 0;
        COOLDOWN_MAP.putIfAbsent(witch.getUUID(), 0);
        WITCH_MAP.put(witch.getUUID(), witch);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private int getCooldownTicks() {
        return COOLDOWN_MAP.getOrDefault(this.witch.getUUID(), 0);
    }

    private void setCooldownTicks(int ticks) {
        COOLDOWN_MAP.put(this.witch.getUUID(), ticks);
    }

    private BlockPos findOptimalFleePosition(LivingEntity target) {
        if (this.witch == null || !this.witch.isAlive() || target == null || this.level == null) {
            return null;
        }
        PathNavigation navigation = this.witch.getNavigation();
        if (navigation == null) {
            return null;
        }
        for (int i = 0; i < 8; ++i) {
            double angle = Math.PI * 2 * (double)i / 8.0;
            double distance = 12.0 + this.level.random.nextDouble() * 4.0;
            double x = this.witch.getX() + Math.cos(angle) * distance;
            double y = this.witch.getY();
            double z = this.witch.getZ() + Math.sin(angle) * distance;
            BlockPos targetPos = new BlockPos((Vec3i)BlockPos.containing((double)x, (double)y, (double)z));
            try {
                Path path;
                if (!this.level.getBlockState(targetPos).isAir() && !this.level.getBlockState(targetPos).blocksMotion() || (path = navigation.createPath(targetPos, 1)) == null || !path.canReach()) continue;
                return targetPos;
            }
            catch (Exception e) {
                System.err.println("Error checking path stability: " + e.getMessage());
            }
        }
        try {
            Vec3 direction = this.witch.position().subtract(target.position()).normalize();
            double distance = 15.0;
            BlockPos fallbackPos = new BlockPos((int)(this.witch.getX() + direction.x * distance), (int)this.witch.getY(), (int)(this.witch.getZ() + direction.z * distance));
            if (this.level.getBlockState(fallbackPos).isAir() || this.level.getBlockState(fallbackPos).canBeReplaced()) {
                return fallbackPos;
            }
        }
        catch (Exception e) {
            System.err.println("Error finding simple flee position: " + e.getMessage());
        }
        return null;
    }

    public boolean canUse() {
        boolean canUse;
        if (this.witch == null || !this.witch.isAlive()) {
            return false;
        }
        LivingEntity target = this.witch.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        int cooldownTicks = this.getCooldownTicks();
        if (cooldownTicks > 0) {
            return false;
        }
        UUID witchId = this.witch.getUUID();
        List<UUID> guardIds = WITCH_GUARDS_MAP.get(witchId);
        if (guardIds != null && guardIds.size() > 6) {
            return false;
        }
        double distance = this.witch.distanceToSqr((Entity)target);
        boolean bl = canUse = distance < (double)(this.summonDistance * this.summonDistance * 4);
        if (canUse) {
            System.out.println("WitchSummonZombiesGoal: Witch can start summoning zombies, distance: " + Math.sqrt(distance) + ", current guards: " + (guardIds != null ? guardIds.size() : 0));
        }
        return canUse;
    }

    public boolean canContinueToUse() {
        if (this.witch == null || !this.witch.isAlive()) {
            return false;
        }
        return (this.isCharging || this.isMovingAway) && this.getCooldownTicks() == 0;
    }

    public void start() {
        if (this.witch == null || !this.witch.isAlive()) {
            return;
        }
        this.target = this.witch.getTarget();
        if (this.target == null) {
            return;
        }
        System.out.println("WitchSummonZombiesGoal: Starting summon zombie AI");
        this.isMovingAway = true;
        this.isCharging = false;
        this.chargeTicks = 0;
        this.targetPosition = this.findOptimalFleePosition(this.target);
        this.pathRecalculateTimer = 0;
        if (this.targetPosition != null) {
            try {
                PathNavigation navigation = this.witch.getNavigation();
                if (navigation != null) {
                    this.currentPath = navigation.createPath(this.targetPosition, 1);
                    if (this.currentPath != null && this.currentPath.canReach()) {
                        navigation.moveTo(this.currentPath, this.moveSpeedAmp);
                        System.out.println("WitchSummonZombiesGoal: Found optimal flee position at " + String.valueOf(this.targetPosition));
                    } else {
                        System.out.println("WitchSummonZombiesGoal: Could not find path to optimal position, using simple flee");
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error setting up navigation: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        if (this.witch == null) {
            return;
        }
        try {
            if (this.witch.getNavigation() != null) {
                this.witch.getNavigation().stop();
            }
        }
        catch (Exception e) {
            System.err.println("Error stopping navigation: " + e.getMessage());
        }
        this.isMovingAway = false;
        this.isCharging = false;
        this.chargeTicks = 0;
        this.target = null;
        this.targetPosition = null;
        this.currentPath = null;
        this.pathRecalculateTimer = 0;
        this.setCooldownTicks(this.cooldownTime);
        System.out.println("WitchSummonZombiesGoal: Starting cooldown for " + this.cooldownTime / 20 + " seconds");
    }

    public void tick() {
        int cooldownTicks;
        if (this.witch == null || !this.witch.isAlive()) {
            return;
        }
        if (this.witch.tickCount % 100 == 0) {
            System.out.println("WitchSummonZombiesGoal status: cooldown=" + this.getCooldownTicks() + ", charging=" + this.chargeTicks + ", movingAway=" + this.isMovingAway + ", isCharging=" + this.isCharging);
        }
        if ((cooldownTicks = this.getCooldownTicks()) > 0) {
            return;
        }
        if (this.target == null || !this.target.isAlive()) {
            this.stop();
            return;
        }
        double distance = this.witch.distanceToSqr((Entity)this.target);
        if (this.isMovingAway) {
            PathNavigation navigation;
            ++this.pathRecalculateTimer;
            if (this.pathRecalculateTimer > 40) {
                this.pathRecalculateTimer = 0;
                this.targetPosition = this.findOptimalFleePosition(this.target);
                if (this.targetPosition != null) {
                    try {
                        navigation = this.witch.getNavigation();
                        if (navigation != null) {
                            this.currentPath = navigation.createPath(this.targetPosition, 1);
                            if (this.currentPath != null && this.currentPath.canReach()) {
                                navigation.moveTo(this.currentPath, this.moveSpeedAmp);
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error in pathfinding: " + e.getMessage());
                    }
                }
            }
            if (distance < (double)(this.summonDistance * this.summonDistance)) {
                if (this.currentPath == null || this.currentPath.isDone() || !this.witch.getNavigation().isInProgress()) {
                    this.targetPosition = this.findOptimalFleePosition(this.target);
                    if (this.targetPosition != null) {
                        try {
                            navigation = this.witch.getNavigation();
                            if (navigation != null) {
                                this.currentPath = navigation.createPath(this.targetPosition, 1);
                                if (this.currentPath != null && this.currentPath.canReach()) {
                                    navigation.moveTo(this.currentPath, this.moveSpeedAmp);
                                } else {
                                    Vec3 direction = this.witch.position().subtract(this.target.position()).normalize();
                                    Vec3 moveVector = direction.scale(this.moveSpeedAmp * 0.5);
                                    this.witch.getMoveControl().setWantedPosition(this.witch.getX() + moveVector.x, this.witch.getY(), this.witch.getZ() + moveVector.z, this.moveSpeedAmp);
                                }
                            }
                        }
                        catch (Exception e) {
                            System.err.println("Error in pathfinding: " + e.getMessage());
                        }
                    }
                }
                if (this.witch.tickCount % 20 == 0) {
                    this.level.playSound(null, this.witch.getX(), this.witch.getY(), this.witch.getZ(), SoundEvents.WITCH_AMBIENT, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
            } else {
                this.isMovingAway = false;
                this.isCharging = true;
                this.chargeTicks = 0;
                try {
                    if (this.witch.getNavigation() != null) {
                        this.witch.getNavigation().stop();
                    }
                }
                catch (Exception e) {
                    System.err.println("Error stopping navigation: " + e.getMessage());
                }
                System.out.println("WitchSummonZombiesGoal: Starting to charge, distance=" + Math.sqrt(distance));
                this.level.playSound(null, this.witch.getX(), this.witch.getY(), this.witch.getZ(), SoundEvents.WITCH_CELEBRATE, SoundSource.HOSTILE, 1.0f, 0.8f);
            }
        }
        if (this.isCharging) {
            ++this.chargeTicks;
            if (this.level instanceof ServerLevel) {
                double offsetZ;
                double offsetY;
                int i;
                ServerLevel serverLevel = (ServerLevel)this.level;
                for (i = 0; i < 5; ++i) {
                    double offsetX = (this.level.random.nextDouble() - 0.5) * 1.0;
                    offsetY = this.level.random.nextDouble() * 1.0;
                    offsetZ = (this.level.random.nextDouble() - 0.5) * 1.0;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, this.witch.getX() + offsetX, this.witch.getY() + 1.5 + offsetY, this.witch.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.witch.getX() + offsetX, this.witch.getY() + 1.0 + offsetY, this.witch.getZ() + offsetZ, 1, 0.0, 0.1, 0.0, 0.0);
                }
                if ((double)this.chargeTicks > (double)this.chargeTime * 0.7) {
                    for (i = 0; i < 3; ++i) {
                        double offsetX = (this.level.random.nextDouble() - 0.5) * 2.0;
                        offsetY = this.level.random.nextDouble() * 2.0;
                        offsetZ = (this.level.random.nextDouble() - 0.5) * 2.0;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.WITCH, this.witch.getX() + offsetX, this.witch.getY() + offsetY, this.witch.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.chargeTicks % 20 == 0) {
                this.level.playSound(null, this.witch.getX(), this.witch.getY(), this.witch.getZ(), SoundEvents.WITCH_CELEBRATE, SoundSource.HOSTILE, 1.0f, 1.0f + (float)this.chargeTicks / (float)this.chargeTime * 0.5f);
            }
            if (this.chargeTicks >= this.chargeTime) {
                this.summonZombies();
                this.stop();
            }
        }
    }

    private void summonZombies() {
        int i;
        if (this.witch == null || !this.witch.isAlive() || this.level == null) {
            return;
        }
        if (!(this.level instanceof ServerLevel)) {
            return;
        }
        System.out.println("WitchSummonZombiesGoal: Starting to summon zombies");
        ServerLevel serverLevel = (ServerLevel)this.level;
        this.level.playSound(null, this.witch.getX(), this.witch.getY(), this.witch.getZ(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.HOSTILE, 1.0f, 1.0f);
        UUID witchId = this.witch.getUUID();
        List guardIds = WITCH_GUARDS_MAP.computeIfAbsent(witchId, k -> new ArrayList());
        for (i = 0; i < 3; ++i) {
            try {
                int j;
                Zombie zombie;
                double angle = Math.PI * 2 * (double)i / 3.0 + this.level.random.nextDouble() * 0.5;
                double distance = 2.0 + this.level.random.nextDouble() * 2.0;
                double x = this.witch.getX() + Math.cos(angle) * distance;
                double y = this.witch.getY();
                double z = this.witch.getZ() + Math.sin(angle) * distance;
                BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
                if (!this.level.getBlockState(pos).blocksMotion()) {
                    while (pos.getY() > -64 && !this.level.getBlockState(pos).blocksMotion()) {
                        pos = pos.below();
                    }
                    pos = pos.above();
                }
                if ((zombie = (Zombie)EntityType.ZOMBIE.create(this.level, EntitySpawnReason.SPAWNER)) == null) continue;
                zombie.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                zombie.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.IRON_HELMET));
                zombie.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.IRON_CHESTPLATE));
                zombie.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.IRON_LEGGINGS));
                zombie.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.IRON_BOOTS));
                Item[] weapons = new Item[]{Items.IRON_SWORD, Items.BOW, Items.CROSSBOW, Items.IRON_AXE};
                Item selectedWeapon = weapons[this.level.random.nextInt(weapons.length)];
                zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)selectedWeapon));
                if (this.target != null && this.target.isAlive()) {
                    zombie.setTarget(this.target);
                }
                zombie.setPersistenceRequired();
                zombie.getPersistentData().putBoolean("witch_guard", true);
                zombie.getPersistentData().putLong("witch_owner_most", this.witch.getUUID().getMostSignificantBits());
                zombie.getPersistentData().putLong("witch_owner_least", this.witch.getUUID().getLeastSignificantBits());
                guardIds.add(zombie.getUUID());
                if (zombie instanceof PathfinderMob) {
                    ProtectCommand.setupProtection((PathfinderMob)zombie, (LivingEntity)this.witch, true);
                }
                for (j = 0; j < 20; ++j) {
                    double offsetX = (this.level.random.nextDouble() - 0.5) * 2.0;
                    double offsetY = this.level.random.nextDouble() * 2.0;
                    double offsetZ = (this.level.random.nextDouble() - 0.5) * 2.0;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, zombie.getX() + offsetX, zombie.getY() + offsetY, zombie.getZ() + offsetZ, 1, 0.1, 0.1, 0.1, 0.05);
                    if (j % 3 == 0) {
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, zombie.getX() + offsetX * 0.5, zombie.getY() + offsetY * 0.5, zombie.getZ() + offsetZ * 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    if (j % 4 != 0) continue;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL, zombie.getX() + offsetX, zombie.getY() + 1.0 + offsetY, zombie.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.level.playSound(null, zombie.getX(), zombie.getY(), zombie.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.HOSTILE, 0.5f, 0.8f);
                for (j = 0; j < 10; ++j) {
                    double circleAngle = Math.PI * 2 * (double)j / 10.0;
                    double radius = 1.5;
                    double circleX = zombie.getX() + Math.cos(circleAngle) * radius;
                    double circleZ = zombie.getZ() + Math.sin(circleAngle) * radius;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, circleX, zombie.getY() + 0.1, circleZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.level.addFreshEntity((Entity)zombie);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error summoning zombie: " + e.getMessage());
                e.printStackTrace();
            }
        }
        try {
            double offsetX;
            for (i = 0; i < 50; ++i) {
                offsetX = (this.level.random.nextDouble() - 0.5) * 8.0;
                double offsetY = this.level.random.nextDouble() * 8.0;
                double offsetZ = (this.level.random.nextDouble() - 0.5) * 8.0;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, this.witch.getX() + offsetX, this.witch.getY() + 1.0 + offsetY, this.witch.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                if (i % 3 == 0) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.WITCH, this.witch.getX() + offsetX, this.witch.getY() + offsetY, this.witch.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (i % 2 != 0) continue;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.witch.getX() + offsetX, this.witch.getY() + 0.5 + offsetY, this.witch.getZ() + offsetZ, 5, 1.0, 0.1, 1.0, 0.111);
            }
            for (i = 0; i < 20; ++i) {
                offsetX = (this.level.random.nextDouble() - 0.5) * 1.0;
                double offsetZ = (this.level.random.nextDouble() - 0.5) * 1.0;
                for (int j = 0; j < 10; ++j) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.witch.getX() + offsetX, this.witch.getY() + (double)j * 0.3, this.witch.getZ() + offsetZ, 2, 1.0, 1.0, 0.0, 0.0);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error generating particle effects: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

