/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.ai;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.phys.Vec3;

public class ZombieAvoidTNTGoal
extends Goal {
    private final Zombie zombie;
    private final double avoidSpeed = 1.7;
    private final double detectionRadius = 10.0;

    public ZombieAvoidTNTGoal(Zombie zombie) {
        this.zombie = zombie;
    }

    public boolean canUse() {
        if (this.zombie.getPassengers().stream().anyMatch(passenger -> passenger instanceof PrimedTnt)) {
            return false;
        }
        return this.findNearestTNT() != null;
    }

    public boolean canContinueToUse() {
        if (this.zombie.getPassengers().stream().anyMatch(passenger -> passenger instanceof PrimedTnt)) {
            return false;
        }
        return this.findNearestTNT() != null;
    }

    public void tick() {
        PrimedTnt nearestTNT = this.findNearestTNT();
        if (nearestTNT == null) {
            return;
        }
        this.zombie.setTarget(null);
        Vec3 awayDirection = new Vec3(this.zombie.getX() - nearestTNT.getX(), 0.0, this.zombie.getZ() - nearestTNT.getZ()).normalize();
        PathNavigation navigation = this.zombie.getNavigation();
        navigation.moveTo(this.zombie.getX() + awayDirection.x * 10.0, this.zombie.getY(), this.zombie.getZ() + awayDirection.z * 10.0, 1.7);
        if (navigation.isDone()) {
            this.zombie.setDeltaMovement(awayDirection.x * 1.7 * 0.1, 0.0, awayDirection.z * 1.7 * 0.1);
        }
    }

    private PrimedTnt findNearestTNT() {
        PrimedTnt nearestTNT = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Entity entity : this.zombie.level().getEntities((Entity)this.zombie, this.zombie.getBoundingBox().inflate(10.0, 10.0, 10.0))) {
            double distance;
            if (!(entity instanceof PrimedTnt) || !((distance = this.zombie.distanceToSqr(entity)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestTNT = (PrimedTnt)entity;
        }
        return nearestTNT;
    }
}

