/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.ai;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ZombieBowAttackGoal
extends Goal {
    private final Zombie zombie;
    private final Level level;
    private final double speedModifier;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private int attackTime = -1;
    private int seeTime;
    private int strafeTime = -1;
    private boolean strafingClockwise = false;

    public ZombieBowAttackGoal(Zombie zombie, double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius) {
        this.zombie = zombie;
        this.level = zombie.level();
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadius = attackRadius;
    }

    public boolean canUse() {
        Player player;
        ItemStack mainHandItem = this.zombie.getMainHandItem();
        if (mainHandItem.getItem() != Items.BOW) {
            return false;
        }
        LivingEntity target = this.zombie.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        return !target.getType().toString().equals("minecraft:player") || !(player = (Player)target).isSpectator() && !player.getAbilities().instabuild;
    }

    public boolean canContinueToUse() {
        Player player;
        if (this.zombie.getMainHandItem().getItem() != Items.BOW) {
            return false;
        }
        LivingEntity target = this.zombie.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (target.getType().toString().equals("minecraft:player") && ((player = (Player)target).isSpectator() || player.getAbilities().instabuild)) {
            return false;
        }
        return !(this.zombie.distanceToSqr((Entity)target) > 256.0) && this.isHoldingBow();
    }

    public void start() {
        super.start();
        this.attackTime = -1;
        this.seeTime = 0;
        this.strafeTime = -1;
    }

    public void stop() {
        super.stop();
        this.seeTime = 0;
        this.zombie.stopUsingItem();
    }

    public void tick() {
        LivingEntity target = this.zombie.getTarget();
        if (target == null) {
            return;
        }
        double distance = this.zombie.distanceToSqr((Entity)target);
        boolean canSee = this.zombie.getSensing().hasLineOfSight((Entity)target);
        double distanceSqrt = Math.sqrt(distance);
        this.seeTime = canSee ? ++this.seeTime : 0;
        int attackInterval = this.zombie.getRandom().nextInt(this.attackIntervalMax - this.attackIntervalMin + 1) + this.attackIntervalMin;
        int drawStartTime = attackInterval / 3;
        if (distanceSqrt < 5.0) {
            this.zombie.getNavigation().stop();
            ++this.attackTime;
            Vec3 targetPos = target.position();
            Vec3 zombiePos = this.zombie.position();
            double dx = zombiePos.x - targetPos.x;
            double dz = zombiePos.z - targetPos.z;
            double length = Math.sqrt(dx * dx + dz * dz);
            if (length > 0.0) {
                dx /= length;
                dz /= length;
            }
            double retreatDistance = 8.0 + this.zombie.getRandom().nextDouble() * 4.0;
            double targetX = zombiePos.x + dx * retreatDistance;
            double targetZ = zombiePos.z + dz * retreatDistance;
            this.zombie.getNavigation().moveTo(targetX, zombiePos.y, targetZ, this.speedModifier * 1.2);
            this.zombie.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        } else if (!(distance > 256.0) && this.seeTime >= 5) {
            this.zombie.getNavigation().stop();
            ++this.attackTime;
            this.zombie.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            this.strafeAroundTarget(target);
        } else {
            this.zombie.getNavigation().moveTo((Entity)target, this.speedModifier);
            this.attackTime = -1;
        }
        if (this.attackTime >= attackInterval) {
            ItemStack projectile = this.zombie.getProjectile(this.zombie.getMainHandItem());
            if (!projectile.isEmpty()) {
                this.performRangedAttack(target, 1.0f);
                this.attackTime = -attackInterval;
            }
        } else if (this.attackTime >= drawStartTime) {
            this.zombie.startUsingItem(InteractionHand.MAIN_HAND);
        } else {
            this.zombie.stopUsingItem();
        }
    }

    private boolean isHoldingBow() {
        return this.zombie.getMainHandItem().getItem() == Items.BOW;
    }

    private void strafeAroundTarget(LivingEntity target) {
        double length;
        if (this.strafeTime <= 0) {
            this.strafeTime = 20 + this.zombie.getRandom().nextInt(20);
            this.strafingClockwise = this.zombie.getRandom().nextBoolean();
        } else {
            --this.strafeTime;
        }
        Vec3 targetPos = target.position();
        Vec3 zombiePos = this.zombie.position();
        double dx = targetPos.x - zombiePos.x;
        double dz = targetPos.z - zombiePos.z;
        double strafeX = -dz;
        double strafeZ = dx;
        if (!this.strafingClockwise) {
            strafeX = -strafeX;
            strafeZ = -strafeZ;
        }
        if ((length = Math.sqrt(strafeX * strafeX + strafeZ * strafeZ)) > 0.0) {
            strafeX /= length;
            strafeZ /= length;
        }
        double strafeDistance = 7.0 + this.zombie.getRandom().nextDouble() * 7.0;
        double targetX = zombiePos.x + strafeX * strafeDistance;
        double targetZ = zombiePos.z + strafeZ * strafeDistance;
        double distanceToTarget = Math.sqrt(Math.pow(targetX - targetPos.x, 2.0) + Math.pow(targetZ - targetPos.z, 2.0));
        double minDistance = 5.0;
        double maxDistance = this.attackRadius * 1.0f;
        if (distanceToTarget < minDistance) {
            adjustX = (zombiePos.x - targetPos.x) / distanceToTarget * (minDistance - distanceToTarget);
            double adjustZ = (zombiePos.z - targetPos.z) / distanceToTarget * (minDistance - distanceToTarget);
            targetX += adjustX;
            targetZ += adjustZ;
        } else if (distanceToTarget > maxDistance) {
            adjustX = (targetPos.x - zombiePos.x) / distanceToTarget * (distanceToTarget - maxDistance);
            double adjustZ = (targetPos.z - zombiePos.z) / distanceToTarget * (distanceToTarget - maxDistance);
            targetX += adjustX;
            targetZ += adjustZ;
        }
        BlockPos targetBlockPos = new BlockPos((int)targetX, (int)this.zombie.getY(), (int)targetZ);
        if (this.level.getBlockState(targetBlockPos.below()).isSolid() && !this.level.getBlockState(targetBlockPos).getFluidState().isSource()) {
            this.zombie.getNavigation().moveTo(targetX, this.zombie.getY(), targetZ, this.speedModifier * 0.8);
        }
    }

    private void performRangedAttack(LivingEntity target, float distanceFactor) {
        Arrow arrow = (Arrow)EntityType.ARROW.create(this.level, EntitySpawnReason.COMMAND);
        if (arrow == null) {
            return;
        }
        arrow.setPos(this.zombie.getX(), this.zombie.getEyeY(), this.zombie.getZ());
        arrow.setOwner((Entity)this.zombie);
        double dx = target.getX() - this.zombie.getX();
        double dy = target.getY(0.3333333333333333) - arrow.getY();
        double dz = target.getZ() - this.zombie.getZ();
        double distance = Math.sqrt(dx * dx + dz * dz);
        float velocity = 2.2f * distanceFactor;
        arrow.shoot(dx, dy + distance * 0.1500000014901161, dz, velocity, (float)(14 - this.level.getDifficulty().getId() * 4));
        arrow.setBaseDamage(2.0 * (double)distanceFactor);
        arrow.setCritArrow(true);
        arrow.addTag("critical_arrow");
        this.level.addFreshEntity((Entity)arrow);
        this.zombie.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.zombie.getRandom().nextFloat() * 0.4f + 0.8f));
    }
}

