/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.ai;

import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ZombieCrossbowAttackGoal
extends Goal {
    private final Zombie zombie;
    private final Level level;
    private final double speedModifier;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private int attackTime = -1;
    private int seeTime;
    private boolean isCharging = false;
    private int chargeTime = 0;
    private boolean isCharged = false;

    public ZombieCrossbowAttackGoal(Zombie zombie, double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius) {
        this.zombie = zombie;
        this.level = zombie.level();
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadius = attackRadius;
    }

    public boolean canUse() {
        Player player;
        ItemStack mainHandItem = this.zombie.getMainHandItem();
        if (mainHandItem.getItem() != Items.CROSSBOW) {
            return false;
        }
        LivingEntity target = this.zombie.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        return !target.getType().toString().equals("minecraft:player") || !(player = (Player)target).isSpectator() && !player.getAbilities().instabuild;
    }

    public boolean canContinueToUse() {
        Player player;
        if (this.zombie.getMainHandItem().getItem() != Items.CROSSBOW) {
            return false;
        }
        LivingEntity target = this.zombie.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (target.getType().toString().equals("minecraft:player") && ((player = (Player)target).isSpectator() || player.getAbilities().instabuild)) {
            return false;
        }
        return !(this.zombie.distanceToSqr((Entity)target) > 1600.0) && this.isHoldingCrossbow();
    }

    public void start() {
        super.start();
        this.attackTime = -1;
        this.seeTime = 0;
        this.isCharging = false;
        this.chargeTime = 0;
        this.isCharged = false;
        this.zombie.startUsingItem(InteractionHand.MAIN_HAND);
        this.isCharging = true;
    }

    public void stop() {
        super.stop();
        this.seeTime = 0;
        this.zombie.stopUsingItem();
        this.isCharging = false;
        this.chargeTime = 0;
        this.isCharged = false;
    }

    public void tick() {
        LivingEntity target = this.zombie.getTarget();
        if (target == null) {
            return;
        }
        this.handleCrossbowCharging();
        double distance = this.zombie.distanceToSqr((Entity)target);
        boolean canSee = this.zombie.getSensing().hasLineOfSight((Entity)target);
        double distanceSqrt = Math.sqrt(distance);
        this.seeTime = canSee ? ++this.seeTime : 0;
        int attackInterval = this.zombie.getRandom().nextInt(this.attackIntervalMax - this.attackIntervalMin + 1) + this.attackIntervalMin;
        if (distanceSqrt < 5.0) {
            this.zombie.getNavigation().stop();
            ++this.attackTime;
            Vec3 targetPos = target.position();
            Vec3 zombiePos = this.zombie.position();
            double dx = zombiePos.x - targetPos.x;
            double dz = zombiePos.z - targetPos.z;
            double length = Math.sqrt(dx * dx + dz * dz);
            if (length > 0.0) {
                dx /= length;
                dz /= length;
            }
            double retreatDistance = 8.0 + this.zombie.getRandom().nextDouble() * 4.0;
            double targetX = zombiePos.x + dx * retreatDistance;
            double targetZ = zombiePos.z + dz * retreatDistance;
            this.zombie.getNavigation().moveTo(targetX, zombiePos.y, targetZ, this.speedModifier * 1.3);
            this.zombie.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        } else if (!(distance > 1600.0) && this.seeTime >= 5) {
            this.zombie.getNavigation().stop();
            ++this.attackTime;
            this.zombie.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        } else {
            this.zombie.getNavigation().moveTo((Entity)target, this.speedModifier);
            this.attackTime = -1;
        }
        if (this.attackTime >= attackInterval && this.isCrossbowCharged(this.zombie.getMainHandItem())) {
            this.performRangedAttack(target, 1.0f);
            this.attackTime = -attackInterval;
        }
    }

    private boolean isHoldingCrossbow() {
        return this.zombie.getMainHandItem().getItem() == Items.CROSSBOW;
    }

    private boolean isCrossbowCharged(ItemStack crossbow) {
        if (crossbow.getItem() != Items.CROSSBOW) {
            return false;
        }
        return this.isCharged;
    }

    private void setCrossbowCharged(ItemStack crossbow, boolean charged) {
        this.isCharged = charged;
    }

    private void handleCrossbowCharging() {
        if (!this.isCharging && !this.isCharged) {
            this.zombie.startUsingItem(InteractionHand.MAIN_HAND);
            this.isCharging = true;
            this.chargeTime = 0;
        } else if (this.isCharging) {
            ++this.chargeTime;
            if (this.chargeTime >= 35) {
                this.zombie.stopUsingItem();
                this.setCrossbowCharged(this.zombie.getMainHandItem(), true);
                this.isCharging = false;
                this.chargeTime = 0;
            }
        }
    }

    private void performRangedAttack(LivingEntity target, float distanceFactor) {
        AbstractArrow arrow = (AbstractArrow)EntityType.ARROW.create(this.zombie.level(), EntitySpawnReason.COMMAND);
        if (arrow == null) {
            return;
        }
        arrow.setPos(this.zombie.getX(), this.zombie.getEyeY(), this.zombie.getZ());
        arrow.setOwner((Entity)this.zombie);
        double dx = target.getX() - this.zombie.getX();
        double dy = target.getY(0.3333333333333333) - arrow.getY();
        double dz = target.getZ() - this.zombie.getZ();
        double distance = Math.sqrt(dx * dx + dz * dz);
        float velocity = 3.0f * distanceFactor;
        arrow.shoot(dx, dy + distance * (double)0.1f, dz, velocity, (float)(14 - this.zombie.level().getDifficulty().getId() * 4));
        arrow.setBaseDamage(2.0 * (double)distanceFactor);
        arrow.setCritArrow(true);
        arrow.addTag("critical_arrow");
        this.zombie.level().addFreshEntity((Entity)arrow);
        this.zombie.playSound(SoundEvents.CROSSBOW_SHOOT, 1.0f, 1.0f / (this.zombie.getRandom().nextFloat() * 0.4f + 0.8f));
        this.setCrossbowCharged(this.zombie.getMainHandItem(), false);
        ItemStack crossbow = this.zombie.getMainHandItem();
        if (crossbow.getItem() == Items.CROSSBOW) {
            crossbow.remove(DataComponents.CHARGED_PROJECTILES);
        }
        if (!this.zombie.getTags().contains("crossbow_shot")) {
            this.zombie.addTag("crossbow_shot");
        }
    }
}

