/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.ai;

import java.lang.reflect.Method;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ZombieElytraGoal
extends Goal {
    private final Zombie zombie;
    private final Level level;
    private LivingEntity target;
    private int checkDelay = 0;
    private boolean isGliding = false;
    private boolean isDirectGliding = false;
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.forNonCombat().range(100.0);

    public ZombieElytraGoal(Zombie zombie) {
        this.zombie = zombie;
        this.level = zombie.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        Player player;
        ItemStack chestArmor = this.zombie.getItemBySlot(EquipmentSlot.CHEST);
        if (chestArmor.getItem() != Items.ELYTRA) {
            return false;
        }
        if (chestArmor.getDamageValue() >= chestArmor.getMaxDamage() - 1) {
            return false;
        }
        this.target = this.zombie.getTarget();
        if (this.target == null || !this.target.isAlive()) {
            return this.shouldStartGliding();
        }
        if (this.target.getType() == EntityType.PLAYER && ((player = (Player)this.target).isSpectator() || player.getAbilities().instabuild)) {
            return false;
        }
        if (this.shouldJumpAndGlide()) {
            return true;
        }
        return this.shouldStartGliding();
    }

    public boolean canContinueToUse() {
        ItemStack chestArmor = this.zombie.getItemBySlot(EquipmentSlot.CHEST);
        if (chestArmor.getItem() != Items.ELYTRA || chestArmor.getDamageValue() >= chestArmor.getMaxDamage() - 1) {
            return false;
        }
        if (this.target == null || !this.target.isAlive()) {
            return this.isGliding && !this.zombie.onGround();
        }
        return this.isGliding && !this.zombie.onGround();
    }

    public void start() {
        if (this.shouldJumpAndGlide()) {
            this.jumpAndStartGliding();
            this.isDirectGliding = true;
            return;
        }
        if (this.shouldStartGliding()) {
            this.startGliding();
            this.isDirectGliding = false;
        }
    }

    public void stop() {
        this.isGliding = false;
        this.isDirectGliding = false;
        if (!this.zombie.onGround()) {
            try {
                Method setSharedFlag = Entity.class.getDeclaredMethod("setSharedFlag", Integer.TYPE, Boolean.TYPE);
                setSharedFlag.setAccessible(true);
                setSharedFlag.invoke((Object)this.zombie, 7, false);
                this.zombie.setPose(Pose.STANDING);
            }
            catch (Exception e) {
                System.err.println("Failed to clear gliding flag: " + e.getMessage());
            }
        } else {
            this.zombie.setPose(Pose.STANDING);
        }
    }

    public void tick() {
        if (this.checkDelay > 0) {
            --this.checkDelay;
        }
        if (!this.isGliding && this.shouldStartGliding()) {
            this.startGliding();
            this.isDirectGliding = false;
        }
        if (this.isGliding && this.isDirectGliding) {
            this.updateDirectGliding();
        }
        if (this.isGliding && !this.isDirectGliding) {
            this.adjustGlideDirection();
        }
        if (this.isGliding && this.zombie.getRandom().nextInt(5) == 0) {
            this.createTrailParticles();
        }
    }

    private boolean shouldStartGliding() {
        if (this.isGliding) {
            return true;
        }
        if (this.zombie.onGround()) {
            return false;
        }
        return this.zombie.fallDistance > 3.0;
    }

    private void startGliding() {
        this.isGliding = true;
        try {
            Method setSharedFlag = Entity.class.getDeclaredMethod("setSharedFlag", Integer.TYPE, Boolean.TYPE);
            setSharedFlag.setAccessible(true);
            setSharedFlag.invoke((Object)this.zombie, 7, true);
            this.zombie.setPose(Pose.FALL_FLYING);
        }
        catch (Exception e) {
            System.err.println("Failed to set gliding flag: " + e.getMessage());
        }
    }

    private void adjustGlideDirection() {
        if (this.target != null && this.target.isAlive()) {
            Vec3 targetDirection = new Vec3(this.target.getX() - this.zombie.getX(), this.target.getY() - this.zombie.getY(), this.target.getZ() - this.zombie.getZ()).normalize();
            double verticalDistance = this.zombie.getY() - this.target.getY();
            double horizontalDistance = this.getHorizontalDistanceToTarget();
            if (verticalDistance > 20.0) {
                Vec3 diveDirection = new Vec3(targetDirection.x * 0.8, -0.9, targetDirection.z * 0.8).normalize();
                this.zombie.setYRot((float)Math.toDegrees(Math.atan2(diveDirection.z, diveDirection.x)) - 90.0f);
                this.zombie.setXRot((float)(-Math.toDegrees(Math.asin(diveDirection.y))));
                Vec3 currentMovement = this.zombie.getDeltaMovement();
                Vec3 newMovement = new Vec3(currentMovement.x * 0.7 + diveDirection.x * 0.6, currentMovement.y * 0.5 + diveDirection.y * 0.8, currentMovement.z * 0.7 + diveDirection.z * 0.6);
                this.zombie.setDeltaMovement(newMovement);
            } else {
                float spiralRadius = 5.0f;
                float spiralSpeed = 0.1f;
                float time = (float)this.zombie.tickCount * spiralSpeed;
                double spiralOffsetX = Math.cos(time) * (double)spiralRadius;
                double spiralOffsetZ = Math.sin(time) * (double)spiralRadius;
                Vec3 spiralDirection = new Vec3(targetDirection.x + spiralOffsetX * 0.1, targetDirection.y * 0.5, targetDirection.z + spiralOffsetZ * 0.1).normalize();
                this.zombie.setYRot((float)Math.toDegrees(Math.atan2(spiralDirection.z, spiralDirection.x)) - 90.0f);
                this.zombie.setXRot((float)(-Math.toDegrees(Math.asin(spiralDirection.y))));
                Vec3 currentMovement = this.zombie.getDeltaMovement();
                Vec3 newMovement = new Vec3(currentMovement.x * 0.95 + spiralDirection.x * 0.2, currentMovement.y * 0.98 - 0.05, currentMovement.z * 0.95 + spiralDirection.z * 0.2);
                if (newMovement.y > -0.2) {
                    newMovement = new Vec3(newMovement.x, -0.2, newMovement.z);
                }
                this.zombie.setDeltaMovement(newMovement);
            }
        } else {
            float spiralRadius = 3.0f;
            float spiralSpeed = 0.05f;
            float time = (float)this.zombie.tickCount * spiralSpeed;
            double spiralOffsetX = Math.cos(time) * (double)spiralRadius;
            double spiralOffsetZ = Math.sin(time) * (double)spiralRadius;
            this.zombie.setYRot((float)Math.toDegrees(Math.atan2(spiralOffsetZ, spiralOffsetX)) - 90.0f);
            this.zombie.setXRot(10.0f);
            Vec3 currentMovement = this.zombie.getDeltaMovement();
            Vec3 newMovement = new Vec3(spiralOffsetX * 0.05, -0.15, spiralOffsetZ * 0.05);
            this.zombie.setDeltaMovement(newMovement);
        }
    }

    private void createTrailParticles() {
        for (int i = 0; i < 10; ++i) {
            double offsetX = (this.zombie.getRandom().nextDouble() - 0.5) * 0.5;
            double offsetY = (this.zombie.getRandom().nextDouble() - 0.5) * 0.5;
            double offsetZ = (this.zombie.getRandom().nextDouble() - 0.5) * 0.5;
            SimpleParticleType particleType = this.zombie.getRandom().nextBoolean() ? ParticleTypes.FIREWORK : ParticleTypes.SMALL_FLAME;
            this.zombie.level().addParticle((ParticleOptions)particleType, this.zombie.getX() + offsetX, this.zombie.getY() + offsetY, this.zombie.getZ() + offsetZ, -this.zombie.getDeltaMovement().x * 0.1, -this.zombie.getDeltaMovement().y * 0.1, -this.zombie.getDeltaMovement().z * 0.1);
        }
    }

    private double getHorizontalDistanceToTarget() {
        if (this.target == null) {
            return Double.MAX_VALUE;
        }
        double dx = this.target.getX() - this.zombie.getX();
        double dz = this.target.getZ() - this.zombie.getZ();
        return Math.sqrt(dx * dx + dz * dz);
    }

    private boolean shouldJumpAndGlide() {
        if (this.isGliding) {
            return false;
        }
        if (this.target == null || !this.target.isAlive()) {
            return false;
        }
        if (!this.zombie.onGround()) {
            return false;
        }
        if (this.zombie.getY() <= this.target.getY()) {
            return false;
        }
        double horizontalDistance = this.getHorizontalDistanceToTarget();
        if (horizontalDistance < 10.0 || horizontalDistance > 50.0) {
            return false;
        }
        if (!this.hasUnpathableGap()) {
            return false;
        }
        return !this.hasBlockObstruction();
    }

    private boolean hasUnpathableGap() {
        if (this.zombie.getNavigation().isDone()) {
            this.zombie.getNavigation().moveTo((Entity)this.target, 1.0);
            for (int i = 0; i < 5; ++i) {
                this.zombie.getNavigation().tick();
                if (!this.zombie.getNavigation().isDone()) break;
            }
            return this.zombie.getNavigation().isDone();
        }
        return false;
    }

    private boolean hasBlockObstruction() {
        Vec3 from = new Vec3(this.zombie.getX(), this.zombie.getEyeY(), this.zombie.getZ());
        Vec3 to = new Vec3(this.target.getX(), this.target.getEyeY(), this.target.getZ());
        ClipContext context = new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.zombie);
        BlockHitResult result = this.zombie.level().clip(context);
        return result.getType() == HitResult.Type.BLOCK;
    }

    private void jumpAndStartGliding() {
        Vec3 direction = new Vec3(this.target.getX() - this.zombie.getX(), 0.0, this.target.getZ() - this.zombie.getZ()).normalize();
        this.zombie.setYRot((float)Math.toDegrees(Math.atan2(direction.z, direction.x)) - 90.0f);
        Vec3 jumpVelocity = new Vec3(direction.x * 0.5, 0.3, direction.z * 0.5);
        this.zombie.setDeltaMovement(jumpVelocity);
        this.startGliding();
        this.setDirectGlideMode();
    }

    private void setDirectGlideMode() {
        Vec3 direction = new Vec3(this.target.getX() - this.zombie.getX(), this.target.getY() - this.zombie.getY(), this.target.getZ() - this.zombie.getZ()).normalize();
        this.zombie.setYRot((float)Math.toDegrees(Math.atan2(direction.z, direction.x)) - 90.0f);
        this.zombie.setXRot((float)(-Math.toDegrees(Math.asin(direction.y))));
        Vec3 glideVelocity = new Vec3(direction.x * 1.5, direction.y * 0.8, direction.z * 1.5);
        this.zombie.setDeltaMovement(glideVelocity);
    }

    private void updateDirectGliding() {
        if (this.target == null || !this.target.isAlive()) {
            this.isDirectGliding = false;
            return;
        }
        if (this.zombie.onGround()) {
            this.isDirectGliding = false;
            return;
        }
        this.setDirectGlideMode();
    }
}

