/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.ai;

import com.example.examplemod.ai.ZombieShieldDefenseGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ZombieMaceAttackGoal
extends Goal {
    private final Zombie zombie;
    private final Level level;
    private LivingEntity target;
    private int jumpCooldown = 0;
    private boolean isJumping = false;
    private int jumpTimer = 0;
    private LivingEntity lastTarget;

    public ZombieMaceAttackGoal(Zombie zombie) {
        this.zombie = zombie;
        this.level = zombie.level();
    }

    private boolean isZombieShieldUp() {
        for (WrappedGoal wrappedGoal : this.zombie.goalSelector.getAvailableGoals()) {
            if (!(wrappedGoal.getGoal() instanceof ZombieShieldDefenseGoal)) continue;
            ZombieShieldDefenseGoal shieldAI = (ZombieShieldDefenseGoal)wrappedGoal.getGoal();
            return shieldAI.isShieldUp();
        }
        return false;
    }

    public boolean canUse() {
        Player player;
        ItemStack mainHandItem = this.zombie.getMainHandItem();
        if (mainHandItem.getItem() != Items.MACE) {
            return false;
        }
        this.target = this.zombie.getTarget();
        if (this.target == null || !this.target.isAlive()) {
            return false;
        }
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).isSpectator() || player.getAbilities().instabuild)) {
            return false;
        }
        this.lastTarget = this.target;
        double distance = this.zombie.distanceToSqr((Entity)this.target);
        return distance <= 256.0;
    }

    public boolean canContinueToUse() {
        Player player;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).isSpectator() || player.getAbilities().instabuild)) {
            if (this.isJumping) {
                this.isJumping = false;
                this.jumpTimer = 0;
            }
            this.zombie.setTarget(null);
            return false;
        }
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if (this.isJumping) {
            ++this.jumpTimer;
            if (this.jumpTimer >= 40) {
                this.isJumping = false;
                this.jumpTimer = 0;
            }
            return true;
        }
        if (this.target == null || !this.target.isAlive()) {
            return false;
        }
        if (this.isZombieShieldUp()) {
            return true;
        }
        return this.target != null && this.target.isAlive() && this.zombie.getMainHandItem().getItem() == Items.MACE;
    }

    public void start() {
        this.jumpCooldown = 0;
        this.isJumping = false;
        this.jumpTimer = 0;
    }

    public void stop() {
        this.target = null;
        this.lastTarget = null;
        this.isJumping = false;
        this.jumpTimer = 0;
    }

    public void tick() {
        Player player;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).isSpectator() || player.getAbilities().instabuild)) {
            this.isJumping = false;
            this.jumpTimer = 0;
            this.zombie.getNavigation().stop();
            this.zombie.setTarget(null);
            this.target = null;
            this.lastTarget = null;
            return;
        }
        if (this.isJumping) {
            ++this.jumpTimer;
            this.zombie.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
            if (this.zombie.onGround() || this.zombie.getDeltaMovement().y < 0.0 && this.isNearGround()) {
                this.dealFallDamage();
                this.isJumping = false;
                this.jumpTimer = 0;
            }
            return;
        }
        if (this.isZombieShieldUp()) {
            this.zombie.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
            return;
        }
        if (this.target == null || !this.target.isAlive()) {
            if (this.isJumping) {
                this.isJumping = false;
                this.jumpTimer = 0;
            }
            this.zombie.getNavigation().stop();
            this.lastTarget = null;
            return;
        }
        LivingEntity currentTarget = this.zombie.getTarget();
        if (currentTarget != this.target) {
            Player player2;
            if (this.isJumping) {
                this.isJumping = false;
                this.jumpTimer = 0;
            }
            this.zombie.getNavigation().stop();
            this.target = currentTarget;
            this.lastTarget = currentTarget;
            LivingEntity livingEntity2 = this.target;
            if (livingEntity2 instanceof Player && ((player2 = (Player)livingEntity2).isSpectator() || player2.getAbilities().instabuild)) {
                this.zombie.setTarget(null);
                this.target = null;
                this.lastTarget = null;
                return;
            }
        }
        double distance = this.zombie.distanceTo((Entity)this.target);
        if (this.isJumping) {
            if (this.zombie.onGround() || this.zombie.getDeltaMovement().y < 0.0 && this.isNearGround()) {
                this.dealFallDamage();
                this.isJumping = false;
                this.jumpTimer = 0;
            }
            return;
        }
        if (distance <= 3.0 && !this.isJumping && this.jumpCooldown <= 0) {
            this.performJumpAttack();
        }
    }

    private void performJumpAttack() {
        Player player;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).isSpectator() || player.getAbilities().instabuild)) {
            this.zombie.setTarget(null);
            this.target = null;
            this.isJumping = false;
            this.jumpTimer = 0;
            return;
        }
        if (this.isZombieShieldUp()) {
            return;
        }
        this.isJumping = true;
        this.jumpTimer = 0;
        this.jumpCooldown = 40;
        livingEntity = this.level;
        if (livingEntity instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)livingEntity;
            Vec3 zombiePos = this.zombie.position();
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.GUST, zombiePos.x, zombiePos.y + 1.0, zombiePos.z, 5, 0.5, 0.5, 0.5, 0.1);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, zombiePos.x, zombiePos.y + 1.0, zombiePos.z, 4, 0.4, 0.4, 0.4, 0.08);
            serverLevel.playSound(null, zombiePos.x, zombiePos.y, zombiePos.z, (Holder)SoundEvents.WIND_CHARGE_BURST, SoundSource.HOSTILE, 10.0f, 1.0f);
        }
        Vec3 zombiePos = this.zombie.position();
        Vec3 targetPos = this.target.position();
        double horizontalX = targetPos.x - zombiePos.x;
        double horizontalZ = targetPos.z - zombiePos.z;
        double horizontalDistance = Math.sqrt(horizontalX * horizontalX + horizontalZ * horizontalZ);
        if (horizontalDistance > 0.0) {
            horizontalX /= horizontalDistance;
            horizontalZ /= horizontalDistance;
        }
        Vec3 jumpVector = new Vec3(horizontalX * 0.15, 1.2, horizontalZ * 0.15);
        this.zombie.setDeltaMovement(jumpVector);
    }

    private boolean isNearGround() {
        for (int i = 0; i <= 1; ++i) {
            BlockPos below = this.zombie.blockPosition().below(i);
            if (this.level.isEmptyBlock(below)) continue;
            return true;
        }
        return false;
    }

    private void dealFallDamage() {
        Player player;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).isSpectator() || player.getAbilities().instabuild)) {
            this.zombie.setTarget(null);
            this.target = null;
            return;
        }
        if (this.target != null && this.zombie.distanceToSqr((Entity)this.target) <= 16.0) {
            this.zombie.doHurtTarget((ServerLevel)this.level, (Entity)this.target);
            this.zombie.fallDistance = 0.0;
        }
    }
}

