/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.ai;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ZombiePickaxeAttackGoal
extends Goal {
    private final Zombie zombie;
    private final Level level;
    private final double speedModifier;
    private final float attackRadius;
    private int breakTime = 0;
    private BlockPos targetBlock = null;
    private int attackAnimationTimer = 0;

    public ZombiePickaxeAttackGoal(Zombie zombie, double speedModifier, int attackInterval, float attackRadius) {
        this.zombie = zombie;
        this.level = zombie.level();
        this.speedModifier = speedModifier;
        this.attackRadius = attackRadius;
    }

    public boolean canUse() {
        Player player;
        ItemStack mainHandItem = this.zombie.getMainHandItem();
        if (mainHandItem.getItem() != Items.WOODEN_PICKAXE && mainHandItem.getItem() != Items.STONE_PICKAXE && mainHandItem.getItem() != Items.IRON_PICKAXE && mainHandItem.getItem() != Items.GOLDEN_PICKAXE && mainHandItem.getItem() != Items.DIAMOND_PICKAXE && mainHandItem.getItem() != Items.NETHERITE_PICKAXE && mainHandItem.getItem() != Items.COPPER_PICKAXE) {
            return false;
        }
        LivingEntity currentTarget = this.zombie.getTarget();
        if (currentTarget == null) {
            LivingEntity newTarget = this.findNearestTarget(25.0);
            if (newTarget != null) {
                this.zombie.setTarget(newTarget);
                return true;
            }
            return false;
        }
        if (currentTarget instanceof Player && ((player = (Player)currentTarget).isSpectator() || player.getAbilities().instabuild)) {
            this.zombie.setTarget(null);
            return false;
        }
        return true;
    }

    public boolean canContinueToUse() {
        Player player;
        LivingEntity currentTarget = this.zombie.getTarget();
        ItemStack mainHandItem = this.zombie.getMainHandItem();
        if (mainHandItem.getItem() != Items.WOODEN_PICKAXE && mainHandItem.getItem() != Items.STONE_PICKAXE && mainHandItem.getItem() != Items.IRON_PICKAXE && mainHandItem.getItem() != Items.GOLDEN_PICKAXE && mainHandItem.getItem() != Items.DIAMOND_PICKAXE && mainHandItem.getItem() != Items.NETHERITE_PICKAXE && mainHandItem.getItem() != Items.COPPER_PICKAXE) {
            return false;
        }
        if (currentTarget == null || !currentTarget.isAlive()) {
            return false;
        }
        if (currentTarget instanceof Player && ((player = (Player)currentTarget).isSpectator() || player.getAbilities().instabuild)) {
            this.zombie.setTarget(null);
            return false;
        }
        return this.zombie.distanceToSqr((Entity)currentTarget) <= 625.0;
    }

    public void start() {
        super.start();
        this.breakTime = 0;
        this.targetBlock = null;
        this.attackAnimationTimer = 0;
    }

    public void stop() {
        super.stop();
        if (this.targetBlock != null) {
            this.level.destroyBlockProgress(this.zombie.getId(), this.targetBlock, -1);
        }
        this.targetBlock = null;
    }

    public void tick() {
        Player player;
        LivingEntity currentTarget = this.zombie.getTarget();
        if (currentTarget == null) {
            return;
        }
        if (currentTarget instanceof Player && ((player = (Player)currentTarget).isSpectator() || player.getAbilities().instabuild)) {
            this.zombie.getNavigation().stop();
            this.zombie.setTarget(null);
            this.targetBlock = null;
            this.breakTime = 0;
            this.attackAnimationTimer = 0;
            return;
        }
        double distance = this.zombie.distanceToSqr((Entity)currentTarget);
        boolean canSee = this.zombie.getSensing().hasLineOfSight((Entity)currentTarget);
        if (this.targetBlock != null) {
            if (this.level.getBlockState(this.targetBlock).isAir()) {
                this.level.destroyBlockProgress(this.zombie.getId(), this.targetBlock, -1);
                this.targetBlock = null;
                this.breakTime = 0;
                this.attackAnimationTimer = 0;
            } else {
                ++this.breakTime;
                ++this.attackAnimationTimer;
                int breakProgress = (int)((float)this.breakTime / (float)this.getBreakTime() * 9.0f);
                this.level.destroyBlockProgress(this.zombie.getId(), this.targetBlock, breakProgress);
                if (this.breakTime % 5 == 0) {
                    this.level.levelEvent(2001, this.targetBlock, Block.getId((BlockState)this.level.getBlockState(this.targetBlock)));
                    this.zombie.swing(this.zombie.getUsedItemHand());
                }
                if (this.breakTime >= this.getBreakTime()) {
                    BlockState blockState = this.level.getBlockState(this.targetBlock);
                    Block.dropResources((BlockState)blockState, (Level)this.level, (BlockPos)this.targetBlock, null, (Entity)this.zombie, (ItemStack)this.zombie.getMainHandItem());
                    this.level.destroyBlock(this.targetBlock, false);
                    this.zombie.getNavigation().moveTo((double)this.targetBlock.getX(), (double)this.targetBlock.getY(), (double)this.targetBlock.getZ(), this.speedModifier);
                    this.breakTime = 0;
                    this.targetBlock = null;
                    this.attackAnimationTimer = 0;
                }
            }
            return;
        }
        if (canSee) {
            boolean isMoving = this.zombie.getNavigation().isInProgress();
            if (!isMoving) {
                double dist;
                BlockPos blockPos;
                Vec3 zombiePos = this.zombie.position();
                Vec3 targetPos = currentTarget.position();
                double dx = targetPos.x - zombiePos.x;
                double dy = targetPos.y - zombiePos.y;
                double dz = targetPos.z - zombiePos.z;
                if ((blockPos = this.findBlockWithRaycast(zombiePos, dx /= (dist = Math.sqrt(dx * dx + dy * dy + dz * dz)), dy /= dist, dz /= dist, 0.1)) != null) {
                    this.targetBlock = blockPos;
                    this.zombie.getNavigation().stop();
                    ++this.breakTime;
                    ++this.attackAnimationTimer;
                    int breakProgress = (int)((float)this.breakTime / (float)this.getBreakTime() * 9.0f);
                    this.level.destroyBlockProgress(this.zombie.getId(), this.targetBlock, breakProgress);
                    if (this.breakTime % 5 == 0) {
                        this.level.levelEvent(2001, this.targetBlock, Block.getId((BlockState)this.level.getBlockState(this.targetBlock)));
                        this.zombie.swing(this.zombie.getUsedItemHand());
                    }
                    if (this.breakTime >= this.getBreakTime()) {
                        BlockState blockState = this.level.getBlockState(this.targetBlock);
                        Block.dropResources((BlockState)blockState, (Level)this.level, (BlockPos)this.targetBlock, null, (Entity)this.zombie, (ItemStack)this.zombie.getMainHandItem());
                        this.level.destroyBlock(this.targetBlock, false);
                        this.zombie.getNavigation().moveTo((double)this.targetBlock.getX(), (double)this.targetBlock.getY(), (double)this.targetBlock.getZ(), this.speedModifier);
                        this.breakTime = 0;
                        this.targetBlock = null;
                        this.attackAnimationTimer = 0;
                    }
                } else {
                    this.zombie.getNavigation().moveTo((Entity)currentTarget, this.speedModifier);
                    if (this.targetBlock != null) {
                        this.level.destroyBlockProgress(this.zombie.getId(), this.targetBlock, -1);
                    }
                    this.targetBlock = null;
                    this.breakTime = 0;
                    this.attackAnimationTimer = 0;
                }
            } else {
                this.zombie.getNavigation().moveTo((Entity)currentTarget, this.speedModifier);
                if (this.targetBlock != null) {
                    this.level.destroyBlockProgress(this.zombie.getId(), this.targetBlock, -1);
                }
                this.targetBlock = null;
                this.breakTime = 0;
                this.attackAnimationTimer = 0;
            }
        } else if (distance <= 625.0) {
            BlockPos blockPos = this.findBlockingBlock(currentTarget);
            if (blockPos != null) {
                this.targetBlock = blockPos;
                this.zombie.getNavigation().stop();
                this.zombie.getLookControl().setLookAt((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 30.0f, 30.0f);
                ++this.breakTime;
                ++this.attackAnimationTimer;
                int breakProgress = (int)((float)this.breakTime / (float)this.getBreakTime() * 9.0f);
                this.level.destroyBlockProgress(this.zombie.getId(), this.targetBlock, breakProgress);
                if (this.breakTime % 5 == 0) {
                    this.level.levelEvent(2001, this.targetBlock, Block.getId((BlockState)this.level.getBlockState(this.targetBlock)));
                    this.zombie.swing(this.zombie.getUsedItemHand());
                }
                if (this.breakTime >= this.getBreakTime()) {
                    BlockState blockState = this.level.getBlockState(this.targetBlock);
                    Block.dropResources((BlockState)blockState, (Level)this.level, (BlockPos)this.targetBlock, null, (Entity)this.zombie, (ItemStack)this.zombie.getMainHandItem());
                    this.level.destroyBlock(this.targetBlock, false);
                    this.zombie.getNavigation().moveTo((double)this.targetBlock.getX(), (double)this.targetBlock.getY(), (double)this.targetBlock.getZ(), this.speedModifier);
                    this.breakTime = 0;
                    this.targetBlock = null;
                    this.attackAnimationTimer = 0;
                }
            } else {
                this.zombie.getNavigation().moveTo((Entity)currentTarget, this.speedModifier);
                if (this.targetBlock != null) {
                    this.level.destroyBlockProgress(this.zombie.getId(), this.targetBlock, -1);
                }
                this.targetBlock = null;
                this.breakTime = 0;
                this.attackAnimationTimer = 0;
            }
        } else {
            this.zombie.getNavigation().stop();
            if (this.targetBlock != null) {
                this.level.destroyBlockProgress(this.zombie.getId(), this.targetBlock, -1);
            }
            this.targetBlock = null;
            this.breakTime = 0;
            this.attackAnimationTimer = 0;
        }
    }

    private LivingEntity findNearestTarget(double range) {
        List villagers;
        List players;
        List ironGolems = this.level.getEntitiesOfClass(IronGolem.class, this.zombie.getBoundingBox().inflate(range));
        if (!ironGolems.isEmpty()) {
            IronGolem nearestGolem = null;
            double nearestDistance = Double.MAX_VALUE;
            for (IronGolem golem : ironGolems) {
                double distance = this.zombie.distanceToSqr((Entity)golem);
                if (!(distance < nearestDistance)) continue;
                nearestDistance = distance;
                nearestGolem = golem;
            }
            if (nearestGolem != null) {
                return nearestGolem;
            }
        }
        if (!(players = this.level.getEntitiesOfClass(Player.class, this.zombie.getBoundingBox().inflate(range), player -> !player.isSpectator() && !player.getAbilities().instabuild)).isEmpty()) {
            Player nearestPlayer = null;
            double nearestDistance = Double.MAX_VALUE;
            for (Player player2 : players) {
                double distance = this.zombie.distanceToSqr((Entity)player2);
                if (!(distance < nearestDistance)) continue;
                nearestDistance = distance;
                nearestPlayer = player2;
            }
            if (nearestPlayer != null) {
                return nearestPlayer;
            }
        }
        if (!(villagers = this.level.getEntitiesOfClass(Villager.class, this.zombie.getBoundingBox().inflate(range))).isEmpty()) {
            Villager nearestVillager = null;
            double nearestDistance = Double.MAX_VALUE;
            for (Villager villager : villagers) {
                double distance = this.zombie.distanceToSqr((Entity)villager);
                if (!(distance < nearestDistance)) continue;
                nearestDistance = distance;
                nearestVillager = villager;
            }
            return nearestVillager;
        }
        return null;
    }

    private LivingEntity findNearestAttackablePlayer(double range) {
        List players = this.level.getEntitiesOfClass(Player.class, this.zombie.getBoundingBox().inflate(range), player -> !player.isSpectator() && !player.getAbilities().instabuild);
        if (players.isEmpty()) {
            return null;
        }
        Player nearestPlayer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Player player2 : players) {
            double distance = this.zombie.distanceToSqr((Entity)player2);
            if (!(distance < nearestDistance)) continue;
            nearestDistance = distance;
            nearestPlayer = player2;
        }
        return nearestPlayer;
    }

    private BlockPos findBlockingBlock(LivingEntity target) {
        if (target == null) {
            return null;
        }
        Vec3 zombiePos = this.zombie.position();
        Vec3 targetPos = target.position();
        double dx = targetPos.x - zombiePos.x;
        double dy = targetPos.y - zombiePos.y;
        double dz = targetPos.z - zombiePos.z;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        dx /= distance;
        dy /= distance;
        dz /= distance;
        if (!this.hasEnoughSpace(zombiePos)) {
            return this.findSurroundingBlockingBlock(zombiePos);
        }
        BlockPos foundBlock = this.findBlockWithAngleRotation(zombiePos, dx, dy, dz);
        return foundBlock;
    }

    private BlockPos findBlockWithAngleRotation(Vec3 startPos, double dirX, double dirY, double dirZ) {
        double rotatedZ;
        double rotatedX;
        double angle;
        int i;
        BlockPos headBlock = this.findBlockWithRaycast(startPos, dirX, dirY, dirZ, 1.8);
        BlockPos footBlock = this.findBlockWithRaycast(startPos, dirX, dirY, dirZ, 0.1);
        if (headBlock != null) {
            return headBlock;
        }
        if (footBlock != null) {
            return footBlock;
        }
        for (i = 1; i <= 3; ++i) {
            angle = Math.toRadians(25 * i);
            rotatedX = dirX * Math.cos(angle) - dirZ * Math.sin(angle);
            rotatedZ = dirX * Math.sin(angle) + dirZ * Math.cos(angle);
            headBlock = this.findBlockWithRaycast(startPos, rotatedX, dirY, rotatedZ, 1.8);
            footBlock = this.findBlockWithRaycast(startPos, rotatedX, dirY, rotatedZ, 0.1);
            if (headBlock != null) {
                return headBlock;
            }
            if (footBlock == null) continue;
            return footBlock;
        }
        for (i = 1; i <= 3; ++i) {
            angle = Math.toRadians(-25 * i);
            rotatedX = dirX * Math.cos(angle) - dirZ * Math.sin(angle);
            rotatedZ = dirX * Math.sin(angle) + dirZ * Math.cos(angle);
            headBlock = this.findBlockWithRaycast(startPos, rotatedX, dirY, rotatedZ, 1.8);
            footBlock = this.findBlockWithRaycast(startPos, rotatedX, dirY, rotatedZ, 0.1);
            if (headBlock != null) {
                return headBlock;
            }
            if (footBlock == null) continue;
            return footBlock;
        }
        return null;
    }

    private BlockPos findBlockWithRaycast(Vec3 startPos, double dirX, double dirY, double dirZ, double yOffset) {
        BlockPos hitBlock;
        BlockState blockState;
        Vec3 rayStart = new Vec3(startPos.x, startPos.y + yOffset, startPos.z);
        double rayLength = 1.5;
        Vec3 rayEnd = new Vec3(rayStart.x + dirX * rayLength, rayStart.y + dirY * rayLength, rayStart.z + dirZ * rayLength);
        BlockHitResult clipResult = this.level.clip(new ClipContext(rayStart, rayEnd, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.zombie));
        if (clipResult.getType() != HitResult.Type.MISS && this.isPickaxeBreakable(blockState = this.level.getBlockState(hitBlock = clipResult.getBlockPos()))) {
            return hitBlock;
        }
        return null;
    }

    private boolean hasEnoughSpace(Vec3 pos) {
        AABB zombieBounds = this.zombie.getBoundingBox();
        BlockPos minPos = BlockPos.containing((double)zombieBounds.minX, (double)zombieBounds.minY, (double)zombieBounds.minZ);
        BlockPos maxPos = BlockPos.containing((double)zombieBounds.maxX, (double)zombieBounds.maxY, (double)zombieBounds.maxZ);
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockState state = this.level.getBlockState(blockPos);
            if (!state.isSolid() || state.isAir()) continue;
            try {
                AABB blockBounds;
                VoxelShape collisionShape = state.getCollisionShape((BlockGetter)this.level, blockPos);
                if (collisionShape.isEmpty() || !(blockBounds = collisionShape.bounds().move(blockPos)).intersects(zombieBounds)) continue;
                return false;
            }
            catch (UnsupportedOperationException e) {
            }
        }
        return true;
    }

    private boolean canPassAfterBreaking(BlockPos blockPos) {
        AABB zombieBounds = this.zombie.getBoundingBox();
        BlockPos minPos = BlockPos.containing((double)zombieBounds.minX, (double)zombieBounds.minY, (double)zombieBounds.minZ);
        BlockPos maxPos = BlockPos.containing((double)zombieBounds.maxX, (double)zombieBounds.maxY, (double)zombieBounds.maxZ);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockState state;
            if (pos.equals((Object)blockPos) || !(state = this.level.getBlockState(pos)).isSolid() || state.isAir()) continue;
            try {
                AABB blockBounds;
                VoxelShape collisionShape = state.getCollisionShape((BlockGetter)this.level, pos);
                if (collisionShape.isEmpty() || !(blockBounds = collisionShape.bounds().move(pos)).intersects(zombieBounds)) continue;
                return false;
            }
            catch (UnsupportedOperationException e) {
            }
        }
        return true;
    }

    private BlockPos findSurroundingBlockingBlock(Vec3 zombiePos) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockState blockState;
                    BlockPos checkPos = BlockPos.containing((double)(zombiePos.x + (double)x), (double)(zombiePos.y + (double)y), (double)(zombiePos.z + (double)z));
                    if (Math.sqrt(x * x + y * y + z * z) > 2.0 || !(blockState = this.zombie.level().getBlockState(checkPos)).isSolid() || blockState.isAir()) continue;
                    try {
                        AABB zombieBounds;
                        AABB blockBounds;
                        VoxelShape collisionShape = blockState.getCollisionShape((BlockGetter)this.zombie.level(), checkPos);
                        if (collisionShape.isEmpty() || !(blockBounds = collisionShape.bounds().move(checkPos)).intersects(zombieBounds = this.zombie.getBoundingBox())) continue;
                        return checkPos;
                    }
                    catch (UnsupportedOperationException e) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    private boolean isPickaxeBreakable(BlockState blockState) {
        return blockState.is(BlockTags.MINEABLE_WITH_PICKAXE);
    }

    private int getBreakTime() {
        BlockState targetBlock;
        ItemStack pickaxe = this.zombie.getMainHandItem();
        BlockState blockState = targetBlock = this.targetBlock != null ? this.level.getBlockState(this.targetBlock) : null;
        if (targetBlock != null && targetBlock.getBlock() == Blocks.OBSIDIAN) {
            if (pickaxe.getItem() == Items.WOODEN_PICKAXE || pickaxe.getItem() == Items.GOLDEN_PICKAXE || pickaxe.getItem() == Items.STONE_PICKAXE || pickaxe.getItem() == Items.IRON_PICKAXE || pickaxe.getItem() == Items.COPPER_PICKAXE) {
                return 1000;
            }
            if (pickaxe.getItem() == Items.DIAMOND_PICKAXE || pickaxe.getItem() == Items.NETHERITE_PICKAXE) {
                return 200;
            }
        }
        if (pickaxe.getItem() == Items.WOODEN_PICKAXE || pickaxe.getItem() == Items.GOLDEN_PICKAXE) {
            return 40;
        }
        if (pickaxe.getItem() == Items.STONE_PICKAXE) {
            return 30;
        }
        if (pickaxe.getItem() == Items.IRON_PICKAXE) {
            return 20;
        }
        if (pickaxe.getItem() == Items.COPPER_PICKAXE) {
            return 26;
        }
        if (pickaxe.getItem() == Items.DIAMOND_PICKAXE) {
            return 15;
        }
        if (pickaxe.getItem() == Items.NETHERITE_PICKAXE) {
            return 10;
        }
        return 40;
    }
}

