/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ZombiePickupFlintAndSteelGoal
extends Goal {
    private final Zombie zombie;
    private ItemEntity targetItem;
    private int cooldown;

    public ZombiePickupFlintAndSteelGoal(Zombie zombie) {
        this.zombie = zombie;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.cooldown = 0;
    }

    public boolean canUse() {
        if (this.cooldown > 0) {
            return false;
        }
        if (this.zombie.getOffhandItem().getItem() == Items.FLINT_AND_STEEL && !this.zombie.getOffhandItem().isEmpty()) {
            return false;
        }
        List nearbyItems = this.zombie.level().getEntitiesOfClass(ItemEntity.class, this.zombie.getBoundingBox().inflate(8.0, 3.0, 8.0));
        for (ItemEntity item : nearbyItems) {
            ItemStack itemStack = item.getItem();
            if (itemStack.getItem() != Items.FLINT_AND_STEEL) continue;
            this.targetItem = item;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.targetItem != null && this.targetItem.isAlive() && this.zombie.getOffhandItem().getItem() != Items.FLINT_AND_STEEL;
    }

    public void start() {
        if (this.targetItem != null) {
            this.zombie.getNavigation().moveTo((Entity)this.targetItem, 1.0);
        }
    }

    public void stop() {
        this.targetItem = null;
        this.zombie.getNavigation().stop();
        this.cooldown = 40;
    }

    public void tick() {
        if (this.targetItem == null || !this.targetItem.isAlive()) {
            return;
        }
        if (this.zombie.distanceToSqr((Entity)this.targetItem) < 1.8) {
            this.zombie.level().playSound(null, this.zombie.getX(), this.zombie.getY(), this.zombie.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (this.zombie.getRandom().nextFloat() - this.zombie.getRandom().nextFloat()) * 0.2f + 1.0f);
            if (this.zombie.getOffhandItem().isEmpty()) {
                this.zombie.setItemInHand(InteractionHand.OFF_HAND, this.targetItem.getItem().copy());
                this.targetItem.discard();
            } else if (this.zombie.getOffhandItem().getItem() != Items.FLINT_AND_STEEL) {
                ItemStack oldItem = this.zombie.getOffhandItem().copy();
                this.zombie.setItemInHand(InteractionHand.OFF_HAND, this.targetItem.getItem().copy());
                ItemEntity droppedItem = new ItemEntity(this.zombie.level(), this.zombie.getX(), this.zombie.getY(), this.zombie.getZ(), oldItem);
                this.zombie.level().addFreshEntity((Entity)droppedItem);
                this.targetItem.discard();
            }
            this.cooldown = 40;
        } else if (this.zombie.getNavigation().isDone()) {
            this.zombie.getNavigation().moveTo((Entity)this.targetItem, 1.0);
        }
    }
}

