/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.ai;

import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ZombiePotionAttackGoal
extends Goal {
    private final Zombie zombie;
    private final Level level;
    private final double speedModifier;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float meleeRadius;
    private int attackTime = -1;
    private int seeTime;
    private int potionDrinkTime = -1;
    private int drinkingDuration = 0;
    private boolean isDrinkingPotion = false;
    private float lastHealth;
    private long stopDrinkingTime = 0L;
    private long lastBuffPotionTime = 0L;
    private boolean wasChasingTarget = false;

    public ZombiePotionAttackGoal(Zombie zombie, double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius, float meleeRadius) {
        this.zombie = zombie;
        this.level = zombie.level();
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadius = attackRadius;
        this.meleeRadius = meleeRadius;
    }

    public boolean canUse() {
        boolean hasTarget;
        ItemStack mainHandItem = this.zombie.getMainHandItem();
        if (mainHandItem.getItem() != Items.POTION) {
            return false;
        }
        LivingEntity target = this.zombie.getTarget();
        boolean bl = hasTarget = target != null && target.isAlive();
        if (hasTarget && this.zombie.getHealth() <= 7.0f) {
            return true;
        }
        if (!hasTarget && this.zombie.getHealth() < this.zombie.getMaxHealth()) {
            return true;
        }
        LivingEntity lowHealthUndeadTarget = this.findNearestLowHealthUndead(target);
        if (lowHealthUndeadTarget != null) {
            return true;
        }
        if (hasTarget) {
            Player player;
            return !target.getType().toString().equals("minecraft:player") || !(player = (Player)target).isSpectator() && !player.getAbilities().instabuild;
        }
        return hasTarget && this.shouldSelfBuff();
    }

    public boolean canContinueToUse() {
        boolean hasTarget;
        if (this.zombie.getMainHandItem().getItem() != Items.POTION) {
            return false;
        }
        LivingEntity target = this.zombie.getTarget();
        boolean bl = hasTarget = target != null && target.isAlive();
        if (hasTarget && this.zombie.getHealth() <= 7.0f) {
            return true;
        }
        if (!hasTarget && this.zombie.getHealth() < this.zombie.getMaxHealth()) {
            return true;
        }
        LivingEntity lowHealthUndeadTarget = this.findNearestLowHealthUndead(target);
        if (lowHealthUndeadTarget != null) {
            return true;
        }
        if (hasTarget) {
            Player player;
            if (target.getType().toString().equals("minecraft:player") && ((player = (Player)target).isSpectator() || player.getAbilities().instabuild)) {
                return false;
            }
            return !(this.zombie.distanceToSqr((Entity)target) > (double)(this.attackRadius * this.attackRadius)) || this.shouldSelfBuff();
        }
        return hasTarget && this.shouldSelfBuff();
    }

    public void start() {
        super.start();
        this.attackTime = -1;
        this.seeTime = 0;
        this.potionDrinkTime = -1;
        this.drinkingDuration = 0;
        this.isDrinkingPotion = false;
        this.lastHealth = this.zombie.getHealth();
        this.stopDrinkingTime = 0L;
        this.lastBuffPotionTime = 0L;
    }

    public void stop() {
        super.stop();
        this.seeTime = 0;
        this.isDrinkingPotion = false;
        this.drinkingDuration = 0;
    }

    public void tick() {
        int attackInterval;
        LivingEntity targetUndead;
        boolean hasTarget;
        LivingEntity target = this.zombie.getTarget();
        boolean bl = hasTarget = target != null && target.isAlive();
        if (hasTarget && this.shouldSelfBuff()) {
            boolean isInCooldown;
            this.zombie.getNavigation().stop();
            ++this.potionDrinkTime;
            int drinkInterval = 40;
            boolean isHurt = this.zombie.getHealth() < this.lastHealth;
            this.lastHealth = this.zombie.getHealth();
            long currentTime = this.zombie.level().getGameTime();
            boolean bl2 = isInCooldown = currentTime - this.stopDrinkingTime < 1200L;
            if (this.isDrinkingPotion && isHurt) {
                this.isDrinkingPotion = false;
                this.drinkingDuration = 0;
                this.stopDrinkingTime = currentTime;
            } else if (!isInCooldown) {
                if (this.isDrinkingPotion) {
                    ++this.drinkingDuration;
                    if (this.drinkingDuration % 5 == 0) {
                        this.zombie.playSound((SoundEvent)SoundEvents.GENERIC_DRINK.get(), 1.0f, 0.6f);
                    }
                    if (this.drinkingDuration >= 30) {
                        this.isDrinkingPotion = false;
                        this.drinkingDuration = 0;
                    }
                }
                if (this.potionDrinkTime >= drinkInterval) {
                    this.drinkPotionForBuff();
                    this.potionDrinkTime = -drinkInterval;
                    this.isDrinkingPotion = true;
                    this.drinkingDuration = 0;
                }
                return;
            }
        } else {
            this.lastHealth = this.zombie.getHealth();
        }
        boolean shouldCheckBuff = !hasTarget || this.zombie.distanceToSqr((Entity)target) <= (double)(this.attackRadius * this.attackRadius);
        boolean wasChasing = this.wasChasingTarget;
        boolean bl3 = this.wasChasingTarget = hasTarget && this.zombie.distanceToSqr((Entity)target) > (double)(this.attackRadius * this.attackRadius);
        if (wasChasing && !this.wasChasingTarget) {
            this.lastBuffPotionTime = this.zombie.level().getGameTime();
        }
        if (shouldCheckBuff && this.zombie.level().getGameTime() - this.lastBuffPotionTime >= 300L && (targetUndead = this.findNearestUndeadForBuff(this.zombie.getTarget())) != null) {
            if (this.isDrinkingPotion) {
                this.isDrinkingPotion = false;
                this.drinkingDuration = 0;
                this.zombie.stopUsingItem();
            }
            this.throwBuffPotion(targetUndead);
        }
        boolean throwAtSelf = hasTarget && this.zombie.getHealth() <= 7.0f || !hasTarget && this.zombie.getHealth() < this.zombie.getMaxHealth();
        LivingEntity lowHealthUndeadTarget = this.findNearestLowHealthUndead(target);
        if (throwAtSelf) {
            this.zombie.getNavigation().stop();
            ++this.attackTime;
            attackInterval = this.zombie.getRandom().nextInt(this.attackIntervalMax - this.attackIntervalMin + 1) + this.attackIntervalMin;
            if (this.attackTime >= attackInterval) {
                this.performPotionAttack(null);
                this.attackTime = -attackInterval;
            }
            return;
        }
        if (lowHealthUndeadTarget != null) {
            this.zombie.getNavigation().stop();
            ++this.attackTime;
            attackInterval = this.zombie.getRandom().nextInt(this.attackIntervalMax - this.attackIntervalMin + 1) + this.attackIntervalMin;
            if (this.attackTime >= attackInterval) {
                this.performPotionAttack(lowHealthUndeadTarget);
                this.attackTime = -attackInterval;
            }
            return;
        }
        if (!hasTarget) {
            return;
        }
        double distance = this.zombie.distanceToSqr((Entity)target);
        boolean canSee = this.zombie.getSensing().hasLineOfSight((Entity)target);
        double distanceSqrt = Math.sqrt(distance);
        this.seeTime = canSee ? ++this.seeTime : 0;
        int attackInterval2 = this.zombie.getRandom().nextInt(this.attackIntervalMax - this.attackIntervalMin + 1) + this.attackIntervalMin;
        if (!(distance > (double)(this.attackRadius * this.attackRadius)) && this.seeTime >= 5) {
            if (distanceSqrt > 3.0) {
                this.zombie.getNavigation().stop();
            } else {
                this.zombie.getNavigation().moveTo((Entity)target, this.speedModifier);
            }
            ++this.attackTime;
            this.zombie.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            if (this.attackTime >= attackInterval2) {
                this.performPotionAttack(target);
                this.attackTime = -attackInterval2;
            }
        } else {
            this.zombie.getNavigation().moveTo((Entity)target, this.speedModifier);
            this.attackTime = -1;
        }
    }

    private boolean isHoldingPotion() {
        return this.zombie.getMainHandItem().getItem() == Items.POTION;
    }

    private LivingEntity findNearestLowHealthUndead(LivingEntity currentTarget) {
        LivingEntity nearestTarget = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Entity entity : this.level.getEntities((Entity)this.zombie, this.zombie.getBoundingBox().inflate((double)this.attackRadius, 4.0, (double)this.attackRadius))) {
            double distance;
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || entity == currentTarget || !entity.isAlive() || !this.isUndeadMob(livingEntity = (LivingEntity)entity) || !(livingEntity.getHealth() <= 7.0f) || !((distance = this.zombie.distanceToSqr((Entity)livingEntity)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestTarget = livingEntity;
        }
        return nearestTarget;
    }

    private LivingEntity findNearestUndeadForBuff(LivingEntity currentTarget) {
        LivingEntity nearestTarget = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Entity entity : this.level.getEntities((Entity)this.zombie, this.zombie.getBoundingBox().inflate((double)this.attackRadius, 4.0, (double)this.attackRadius))) {
            double distance;
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || entity == currentTarget || !entity.isAlive() || !this.isUndeadMob(livingEntity = (LivingEntity)entity) || !((distance = this.zombie.distanceToSqr((Entity)livingEntity)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestTarget = livingEntity;
        }
        return nearestTarget;
    }

    private boolean isUndeadMob(LivingEntity entity) {
        return entity.getType() == EntityType.ZOMBIE || entity.getType() == EntityType.SKELETON || entity.getType() == EntityType.WITHER || entity.getType() == EntityType.WITHER_SKELETON || entity.getType() == EntityType.STRAY || entity.getType() == EntityType.HUSK || entity.getType() == EntityType.ZOMBIE_VILLAGER || entity.getType() == EntityType.DROWNED || entity.getType() == EntityType.PHANTOM || entity.getType() == EntityType.SKELETON_HORSE || entity.getType() == EntityType.ZOMBIE_HORSE || entity.getType() == EntityType.BOGGED || entity.getType() == EntityType.ZOMBIFIED_PIGLIN || entity.getType() == EntityType.ZOGLIN;
    }

    private void performPotionAttack(LivingEntity target) {
        double dz;
        double dy;
        double dx;
        ThrowableItemProjectile potion = (ThrowableItemProjectile)EntityType.SPLASH_POTION.create(this.level, EntitySpawnReason.COMMAND);
        if (potion == null) {
            return;
        }
        potion.setPos(this.zombie.getX(), this.zombie.getEyeY(), this.zombie.getZ());
        potion.setOwner((Entity)this.zombie);
        boolean throwAtSelf = this.zombie.getHealth() <= 7.0f || target == null;
        boolean isUndead = false;
        if (target != null) {
            isUndead = this.isUndeadMob(target);
        }
        boolean isLowHealthUndead = false;
        if (target != null && target != this.zombie.getTarget()) {
            isLowHealthUndead = this.isUndeadMob(target) && target.getHealth() <= 7.0f;
        }
        ItemStack potionItem = new ItemStack((ItemLike)Items.SPLASH_POTION);
        if (throwAtSelf) {
            potionItem.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.STRONG_HARMING));
        } else if (isLowHealthUndead) {
            potionItem.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.STRONG_HARMING));
        } else if (isUndead) {
            potionItem.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.STRONG_HEALING));
        } else {
            boolean targetAttackedZombie = target.getLastHurtByMob() == this.zombie;
            boolean hasWeakness = target.hasEffect(MobEffects.WEAKNESS);
            boolean hasPoison = target.hasEffect(MobEffects.POISON);
            boolean hasSlowness = target.hasEffect(MobEffects.SLOWNESS);
            if (!hasSlowness && this.zombie.getRandom().nextFloat() < 0.3f) {
                potionItem.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.STRONG_SLOWNESS));
            } else if (targetAttackedZombie && !hasWeakness) {
                potionItem.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WEAKNESS));
            } else if (!isUndead && !hasPoison && this.zombie.getRandom().nextFloat() < 0.4f) {
                potionItem.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.POISON));
            } else {
                potionItem.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.STRONG_HARMING));
            }
        }
        potion.setItem(potionItem);
        if (throwAtSelf) {
            dx = 0.0;
            dy = -2.0;
            dz = 0.0;
        } else {
            double targetX = target.getX();
            double targetY = target.getY(0.3333333333333333);
            double targetZ = target.getZ();
            double targetMotionX = target.getDeltaMovement().x;
            double targetMotionY = target.getDeltaMovement().y;
            double targetMotionZ = target.getDeltaMovement().z;
            dx = targetX - this.zombie.getX();
            dy = targetY - potion.getY();
            dz = targetZ - this.zombie.getZ();
            double distance = Math.sqrt(dx * dx + dz * dz);
            double flightTime = distance / 8.0;
            double predictedX = targetX + targetMotionX * flightTime;
            double predictedY = targetY + targetMotionY * flightTime;
            double predictedZ = targetZ + targetMotionZ * flightTime;
            dx = predictedX - this.zombie.getX();
            dy = predictedY - potion.getY();
            dz = predictedZ - this.zombie.getZ();
        }
        double distance = Math.sqrt(dx * dx + dz * dz);
        float velocity = throwAtSelf ? 0.5f : (float)Math.min((double)0.6f + distance * (double)0.05f, (double)1.2f);
        potion.shoot(dx, dy + distance * (double)0.4f, dz, velocity, 1.0f);
        this.level.addFreshEntity((Entity)potion);
        this.zombie.playSound(SoundEvents.SPLASH_POTION_THROW, 1.0f, 0.1f / (this.zombie.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    private boolean shouldSelfBuff() {
        LivingEntity target = this.zombie.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        boolean hasStrength = this.zombie.hasEffect(MobEffects.STRENGTH);
        boolean hasSpeed = this.zombie.hasEffect(MobEffects.SPEED);
        boolean hasJumpBoost = this.zombie.hasEffect(MobEffects.JUMP_BOOST);
        return !hasStrength || !hasSpeed || !hasJumpBoost;
    }

    private void throwBuffPotion(LivingEntity target) {
        ThrowableItemProjectile potion = (ThrowableItemProjectile)EntityType.SPLASH_POTION.create(this.level, EntitySpawnReason.COMMAND);
        if (potion == null) {
            return;
        }
        potion.setPos(this.zombie.getX(), this.zombie.getEyeY(), this.zombie.getZ());
        potion.setOwner((Entity)this.zombie);
        ItemStack potionItem = new ItemStack((ItemLike)Items.SPLASH_POTION);
        potionItem.set(DataComponents.POTION_CONTENTS, (Object)this.getRandomBuffPotion());
        potion.setItem(potionItem);
        double targetX = target.getX();
        double targetY = target.getY(0.3333333333333333);
        double targetZ = target.getZ();
        double targetMotionX = target.getDeltaMovement().x;
        double targetMotionY = target.getDeltaMovement().y;
        double targetMotionZ = target.getDeltaMovement().z;
        double dx = targetX - this.zombie.getX();
        double dy = targetY - potion.getY();
        double dz = targetZ - this.zombie.getZ();
        double distance = Math.sqrt(dx * dx + dz * dz);
        double flightTime = distance / 8.0;
        double predictedX = targetX + targetMotionX * flightTime;
        double predictedY = targetY + targetMotionY * flightTime;
        double predictedZ = targetZ + targetMotionZ * flightTime;
        dx = predictedX - this.zombie.getX();
        dy = predictedY - potion.getY();
        dz = predictedZ - this.zombie.getZ();
        float velocity = (float)Math.min((double)0.6f + distance * (double)0.05f, (double)1.2f);
        potion.shoot(dx, dy + distance * (double)0.4f, dz, velocity, 1.0f);
        this.level.addFreshEntity((Entity)potion);
        this.zombie.playSound(SoundEvents.SPLASH_POTION_THROW, 1.0f, 0.1f / (this.zombie.getRandom().nextFloat() * 0.4f + 0.8f));
        this.lastBuffPotionTime = this.zombie.level().getGameTime();
    }

    private PotionContents getRandomBuffPotion() {
        int potionType = this.zombie.getRandom().nextInt(3);
        switch (potionType) {
            case 0: {
                return new PotionContents(Potions.STRONG_STRENGTH);
            }
            case 1: {
                return new PotionContents(Potions.STRONG_SWIFTNESS);
            }
            case 2: {
                return new PotionContents(Potions.LEAPING);
            }
        }
        return new PotionContents(Potions.STRONG_STRENGTH);
    }

    private void drinkPotionForBuff() {
        boolean hasStrength = this.zombie.hasEffect(MobEffects.STRENGTH);
        boolean hasSpeed = this.zombie.hasEffect(MobEffects.SPEED);
        boolean hasJumpBoost = this.zombie.hasEffect(MobEffects.JUMP_BOOST);
        if (!hasStrength) {
            this.zombie.addEffect(new MobEffectInstance(MobEffects.STRENGTH, 3600, 1));
            this.zombie.playSound((SoundEvent)SoundEvents.GENERIC_DRINK.get(), 1.0f, 0.6f);
        } else if (!hasSpeed) {
            this.zombie.addEffect(new MobEffectInstance(MobEffects.SPEED, 3600, 1));
            this.zombie.playSound((SoundEvent)SoundEvents.GENERIC_DRINK.get(), 1.0f, 0.6f);
        } else if (!hasJumpBoost) {
            this.zombie.addEffect(new MobEffectInstance(MobEffects.JUMP_BOOST, 3600, 0));
            this.zombie.playSound((SoundEvent)SoundEvents.GENERIC_DRINK.get(), 1.0f, 0.6f);
        }
    }
}

