/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.ai;

import com.example.examplemod.ai.ZombieBowAttackGoal;
import com.example.examplemod.ai.ZombieCrossbowAttackGoal;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;

public class ZombieShieldDefenseGoal
extends Goal {
    private final Zombie zombie;
    private int shieldUpTime = 0;
    private int shieldCooldown = 0;
    private boolean isShieldUp = false;
    private static final int SHIELD_UP_DURATION = 300;
    private static final int SHIELD_COOLDOWN = 150;
    private static final int AXE_BREAK_COOLDOWN = 450;
    private static final double SHIELD_CHANCE = 0.55;
    private static final double SHIELD_MOVEMENT_SLOWDOWN = 0.3;
    private double originalMovementSpeed;
    private double originalKnockbackResistance;
    private boolean hasBowOrCrossbow = false;
    private boolean originalCanUseRangedAttack = true;

    public ZombieShieldDefenseGoal(Zombie zombie) {
        this.zombie = zombie;
        this.originalMovementSpeed = zombie.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue();
        this.originalKnockbackResistance = zombie.getAttribute(Attributes.KNOCKBACK_RESISTANCE).getBaseValue();
    }

    public boolean canUse() {
        ItemStack offHandItem = this.zombie.getOffhandItem();
        if (!(offHandItem.getItem() instanceof ShieldItem)) {
            return false;
        }
        LivingEntity target = this.zombie.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (this.shieldCooldown > 0) {
            return false;
        }
        return this.isShieldUp;
    }

    public boolean canContinueToUse() {
        ItemStack offHandItem = this.zombie.getOffhandItem();
        if (!(offHandItem.getItem() instanceof ShieldItem)) {
            return false;
        }
        if (this.isShieldUp) {
            return this.shieldUpTime < 300;
        }
        return false;
    }

    public void start() {
        if (!this.isShieldUp) {
            this.isShieldUp = true;
            this.shieldUpTime = 0;
            this.zombie.startUsingItem(InteractionHand.OFF_HAND);
            this.zombie.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.originalMovementSpeed * 0.3);
            this.zombie.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(1.0);
            ItemStack mainHandItem = this.zombie.getMainHandItem();
            boolean bl = this.hasBowOrCrossbow = mainHandItem.getItem() instanceof BowItem || mainHandItem.getItem() instanceof CrossbowItem;
            if (this.hasBowOrCrossbow) {
                this.zombie.goalSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof ZombieBowAttackGoal || goal.getGoal() instanceof ZombieCrossbowAttackGoal);
            }
        }
    }

    public void stop() {
        if (this.isShieldUp) {
            this.isShieldUp = false;
            this.zombie.stopUsingItem();
            this.shieldUpTime = 0;
            this.shieldCooldown = 150;
            this.zombie.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.originalMovementSpeed);
            this.zombie.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(this.originalKnockbackResistance);
            if (this.hasBowOrCrossbow) {
                ItemStack mainHandItem = this.zombie.getMainHandItem();
                if (mainHandItem.getItem() instanceof BowItem) {
                    this.zombie.goalSelector.addGoal(2, (Goal)new ZombieBowAttackGoal(this.zombie, 1.0, 20, 40, 15.0f));
                } else if (mainHandItem.getItem() instanceof CrossbowItem) {
                    this.zombie.goalSelector.addGoal(2, (Goal)new ZombieCrossbowAttackGoal(this.zombie, 1.0, 20, 40, 15.0f));
                }
            }
        }
    }

    public void breakShield() {
        if (this.isShieldUp) {
            this.isShieldUp = false;
            this.zombie.stopUsingItem();
            this.shieldUpTime = 0;
            this.shieldCooldown = 450;
            this.zombie.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.originalMovementSpeed);
            this.zombie.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(this.originalKnockbackResistance);
            if (this.hasBowOrCrossbow) {
                ItemStack mainHandItem = this.zombie.getMainHandItem();
                if (mainHandItem.getItem() instanceof BowItem) {
                    this.zombie.goalSelector.addGoal(2, (Goal)new ZombieBowAttackGoal(this.zombie, 1.0, 20, 40, 15.0f));
                } else if (mainHandItem.getItem() instanceof CrossbowItem) {
                    this.zombie.goalSelector.addGoal(2, (Goal)new ZombieCrossbowAttackGoal(this.zombie, 1.0, 20, 40, 15.0f));
                }
            }
            this.zombie.level().playSound(null, this.zombie.getX(), this.zombie.getY(), this.zombie.getZ(), (Holder)SoundEvents.SHIELD_BREAK, SoundSource.HOSTILE, 10.0f, 1.0f);
        }
    }

    public void tick() {
        if (this.isShieldUp) {
            ++this.shieldUpTime;
            if (this.shieldUpTime >= 300) {
                this.stop();
            }
        } else if (this.shieldCooldown > 0) {
            --this.shieldCooldown;
        }
    }

    public boolean tryRaiseShield(LivingEntity attacker) {
        if (this.shieldCooldown > 0) {
            return false;
        }
        if (this.isShieldUp) {
            return false;
        }
        ItemStack offhandItem = this.zombie.getOffhandItem();
        if (offhandItem.getItem() instanceof ShieldItem) {
            boolean isAxeAttack = attacker != null && attacker.getMainHandItem().getItem() instanceof AxeItem;
            boolean isWardenAttack = ZombieShieldDefenseGoal.isAttackerWarden((Entity)attacker);
            if ((isAxeAttack || isWardenAttack) && this.zombie.getRandom().nextDouble() < 1.0) {
                this.zombie.level().playSound(null, this.zombie.getX(), this.zombie.getY(), this.zombie.getZ(), (Holder)SoundEvents.SHIELD_BREAK, SoundSource.HOSTILE, 1.0f, 0.8f + this.zombie.getRandom().nextFloat() * 0.4f);
                this.shieldCooldown = 450;
                this.zombie.invulnerableTime = 20;
                return false;
            }
            if (this.zombie.getRandom().nextDouble() < 0.55) {
                this.isShieldUp = true;
                this.shieldUpTime = 0;
                this.zombie.startUsingItem(InteractionHand.OFF_HAND);
                this.zombie.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.originalMovementSpeed * 0.3);
                this.zombie.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(1.0);
                ItemStack mainHandItem = this.zombie.getMainHandItem();
                boolean bl = this.hasBowOrCrossbow = mainHandItem.getItem() instanceof BowItem || mainHandItem.getItem() instanceof CrossbowItem;
                if (this.hasBowOrCrossbow) {
                    this.zombie.goalSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof ZombieBowAttackGoal || goal.getGoal() instanceof ZombieCrossbowAttackGoal);
                }
                this.zombie.level().playSound(null, this.zombie.getX(), this.zombie.getY(), this.zombie.getZ(), (Holder)SoundEvents.SHIELD_BLOCK, SoundSource.HOSTILE, 0.5f, 0.8f + this.zombie.getRandom().nextFloat() * 0.4f);
                return true;
            }
        }
        return false;
    }

    public boolean isShieldUp() {
        return this.isShieldUp;
    }

    public static boolean isAttackerUsingAxe(Entity attacker) {
        if (attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            return livingAttacker.getMainHandItem().getItem() instanceof AxeItem;
        }
        return false;
    }

    public static boolean isAttackerWarden(Entity attacker) {
        return attacker instanceof Warden;
    }
}

