/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.ai;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class ZombieTNTThrowGoal
extends Goal {
    private final Zombie zombie;
    private final Level level;
    private final double speedModifier;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private int attackTime = -1;

    public ZombieTNTThrowGoal(Zombie zombie, double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius) {
        this.zombie = zombie;
        this.level = zombie.level();
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadius = attackRadius;
    }

    public boolean canUse() {
        Player player;
        ItemStack mainHandItem = this.zombie.getMainHandItem();
        if (mainHandItem.getItem() != Items.TNT) {
            return false;
        }
        ItemStack offHandItem = this.zombie.getOffhandItem();
        if (offHandItem.getItem() != Items.FLINT_AND_STEEL || offHandItem.isEmpty()) {
            return false;
        }
        LivingEntity target = this.zombie.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        return !target.getType().toString().equals("minecraft:player") || !(player = (Player)target).isSpectator() && !player.getAbilities().instabuild;
    }

    public boolean canContinueToUse() {
        Player player;
        if (this.zombie.getMainHandItem().getItem() != Items.TNT) {
            return false;
        }
        if (this.zombie.getOffhandItem().getItem() != Items.FLINT_AND_STEEL || this.zombie.getOffhandItem().isEmpty()) {
            return false;
        }
        LivingEntity target = this.zombie.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (target.getType().toString().equals("minecraft:player") && ((player = (Player)target).isSpectator() || player.getAbilities().instabuild)) {
            return false;
        }
        return !(this.zombie.distanceToSqr((Entity)target) > (double)(this.attackRadius * this.attackRadius));
    }

    public void start() {
        super.start();
        this.attackTime = -1;
    }

    public void stop() {
        super.stop();
    }

    public void tick() {
        LivingEntity target = this.zombie.getTarget();
        if (target == null) {
            return;
        }
        double distance = this.zombie.distanceTo((Entity)target);
        boolean canSee = this.zombie.getSensing().hasLineOfSight((Entity)target);
        int attackInterval = this.zombie.getRandom().nextInt(this.attackIntervalMax - this.attackIntervalMin + 1) + this.attackIntervalMin;
        if (distance <= 24.0 && canSee) {
            this.zombie.getNavigation().stop();
            ++this.attackTime;
            this.zombie.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            if (this.attackTime >= attackInterval) {
                this.performTNTThrow(target);
                this.attackTime = -attackInterval;
            }
        } else if (distance > 24.0 || !canSee) {
            this.zombie.getNavigation().moveTo((Entity)target, this.speedModifier);
            this.attackTime = -1;
        }
    }

    private void performTNTThrow(LivingEntity target) {
        ItemStack mainHandItem = this.zombie.getMainHandItem();
        if (mainHandItem.getItem() != Items.TNT || mainHandItem.isEmpty()) {
            return;
        }
        ItemStack offHandItem = this.zombie.getOffhandItem();
        if (offHandItem.getItem() != Items.FLINT_AND_STEEL || offHandItem.isEmpty()) {
            return;
        }
        PrimedTnt tnt = (PrimedTnt)EntityType.TNT.create(this.level, EntitySpawnReason.COMMAND);
        if (tnt == null) {
            return;
        }
        tnt.setPos(this.zombie.getX(), this.zombie.getEyeY(), this.zombie.getZ());
        double targetX = target.getX();
        double targetY = target.getY();
        double targetZ = target.getZ();
        float targetYaw = target.getYHeadRot();
        double lookX = Math.sin(Math.toRadians(targetYaw)) * 1.0;
        double lookZ = Math.cos(Math.toRadians(targetYaw)) * 1.0;
        double dx = (targetX += lookX * 1.0) - this.zombie.getX();
        double dz = (targetZ += lookZ * 1.0) - this.zombie.getZ();
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        double throwPower = 0.6 + horizontalDistance / 28.0 * 0.3;
        double verticalDistance = targetY - tnt.getY();
        double timeToTarget = horizontalDistance / (throwPower * 0.8);
        double gravity = 0.08;
        double verticalVelocity = (verticalDistance + 0.5 * gravity * timeToTarget * timeToTarget) / timeToTarget;
        verticalVelocity = Math.max(verticalVelocity, 0.05);
        double horizontalVelocityX = dx / horizontalDistance * throwPower * 0.8;
        double horizontalVelocityZ = dz / horizontalDistance * throwPower * 0.8;
        tnt.setDeltaMovement(horizontalVelocityX, verticalVelocity, horizontalVelocityZ);
        int fuseTime = 65;
        tnt.setFuse(fuseTime);
        this.level.addFreshEntity((Entity)tnt);
        mainHandItem.shrink(1);
        if (mainHandItem.isEmpty()) {
            this.zombie.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        offHandItem.hurtAndBreak(1, (LivingEntity)this.zombie, EquipmentSlot.OFFHAND);
        if (offHandItem.isEmpty()) {
            this.zombie.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        }
        this.zombie.playSound(SoundEvents.TNT_PRIMED, 1.0f, 1.0f / (this.zombie.getRandom().nextFloat() * 0.4f + 0.8f));
        for (int i = 0; i < 5; ++i) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, this.zombie.getX() + (this.zombie.getRandom().nextDouble() - 0.5) * 0.5, this.zombie.getEyeY() + (this.zombie.getRandom().nextDouble() - 0.5) * 0.5, this.zombie.getZ() + (this.zombie.getRandom().nextDouble() - 0.5) * 0.5, 0.0, 0.0, 0.0);
        }
    }
}

