/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;

public class AfraidCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"afraid").then(Commands.literal((String)"entity").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(((RequiredArgumentBuilder)Commands.argument((String)"scared", (ArgumentType)EntityArgument.entity()).executes(context -> AfraidCommand.makeAfraid((CommandSourceStack)context.getSource(), EntityArgument.getEntity((CommandContext)context, (String)"target"), EntityArgument.getEntity((CommandContext)context, (String)"scared"), 12))).then(Commands.argument((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)1, (int)255)).executes(context -> AfraidCommand.makeAfraid((CommandSourceStack)context.getSource(), EntityArgument.getEntity((CommandContext)context, (String)"target"), EntityArgument.getEntity((CommandContext)context, (String)"scared"), IntegerArgumentType.getInteger((CommandContext)context, (String)"distance")))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).executes(context -> AfraidCommand.removeAfraid((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"entities")))))).then(Commands.literal((String)"team").then(Commands.argument((String)"team1", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"team2", (ArgumentType)StringArgumentType.string()).executes(context -> AfraidCommand.makeTeamAfraid((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team1"), StringArgumentType.getString((CommandContext)context, (String)"team2"), 12))).then(Commands.argument((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)1, (int)255)).executes(context -> AfraidCommand.makeTeamAfraid((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team1"), StringArgumentType.getString((CommandContext)context, (String)"team2"), IntegerArgumentType.getInteger((CommandContext)context, (String)"distance"))))))));
    }

    private static int makeAfraid(CommandSourceStack source, Entity target, Entity scared, int distance) throws CommandSyntaxException {
        if (!(target instanceof LivingEntity)) {
            source.sendFailure((Component)Component.literal((String)"\u76ee\u6807\u5fc5\u987b\u662f\u751f\u7269\u5b9e\u4f53"));
            return 0;
        }
        final LivingEntity livingTarget = (LivingEntity)target;
        if (!(scared instanceof Mob)) {
            source.sendFailure((Component)Component.literal((String)"\u5bb3\u6015\u7684\u5b9e\u4f53\u5fc5\u987b\u662f\u5177\u6709AI\u7684\u751f\u7269\u5b9e\u4f53"));
            return 0;
        }
        Mob mobScared = (Mob)scared;
        if (!(mobScared instanceof PathfinderMob)) {
            source.sendFailure((Component)Component.literal((String)"\u5bb3\u6015\u7684\u5b9e\u4f53\u5fc5\u987b\u662fPathfinderMob\u7c7b\u578b"));
            return 0;
        }
        PathfinderMob pathfinderMob = (PathfinderMob)mobScared;
        float fleeDistance = distance;
        float slowSpeed = 1.0f;
        float fastSpeed = 1.5f;
        try {
            pathfinderMob.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal(pathfinderMob, LivingEntity.class, fleeDistance, slowSpeed, fastSpeed){

                public boolean canUse() {
                    return super.canUse() && this.toAvoid.equals((Object)livingTarget);
                }
            });
            source.sendSuccess(() -> Component.literal((String)("\u5df2\u4f7f " + pathfinderMob.getName().getString() + " \u5bb3\u6015 " + livingTarget.getName().getString() + " (\u9003\u79bb\u8ddd\u79bb: " + distance + " \u683c)")), true);
        }
        catch (Exception e) {
            pathfinderMob.setTarget(livingTarget);
            source.sendSuccess(() -> Component.literal((String)("\u5df2\u4f7f " + pathfinderMob.getName().getString() + " \u5bb3\u6015 " + livingTarget.getName().getString() + " (\u9003\u79bb\u8ddd\u79bb: " + distance + " \u683c)")), true);
        }
        return 1;
    }

    private static int removeAfraid(CommandSourceStack source, Collection<? extends Entity> entities) throws CommandSyntaxException {
        int successCount = 0;
        ArrayList<String> failedEntities = new ArrayList<String>();
        for (Entity entity : entities) {
            if (!(entity instanceof Mob)) {
                failedEntities.add(entity.getName().getString());
                continue;
            }
            Mob mob = (Mob)entity;
            mob.setTarget(null);
            if (mob instanceof PathfinderMob) {
                PathfinderMob pathfinderMob = (PathfinderMob)mob;
                try {
                    try {
                        Method removeGoalMethod = pathfinderMob.goalSelector.getClass().getDeclaredMethod("removeGoal", Goal.class);
                        removeGoalMethod.setAccessible(true);
                        Field goalsField = pathfinderMob.goalSelector.getClass().getDeclaredField("goals");
                        goalsField.setAccessible(true);
                        Set goals = (Set)goalsField.get(pathfinderMob.goalSelector);
                        ArrayList toRemove = new ArrayList();
                        for (WrappedGoal goal : goals) {
                            if (!(goal.getGoal() instanceof AvoidEntityGoal)) continue;
                            toRemove.add(goal);
                        }
                        Iterator iterator = toRemove.iterator();
                        while (iterator.hasNext()) {
                            WrappedGoal goal;
                            goal = (WrappedGoal)iterator.next();
                            removeGoalMethod.invoke((Object)pathfinderMob.goalSelector, goal.getGoal());
                        }
                    }
                    catch (NoSuchMethodException removeGoalMethod) {
                        // empty catch block
                    }
                    Field goalsField = pathfinderMob.goalSelector.getClass().getDeclaredField("goals");
                    goalsField.setAccessible(true);
                    Set goals = (Set)goalsField.get(pathfinderMob.goalSelector);
                    ArrayList<WrappedGoal> toRemove = new ArrayList<WrappedGoal>();
                    for (WrappedGoal goal : goals) {
                        if (!(goal.getGoal() instanceof AvoidEntityGoal)) continue;
                        toRemove.add(goal);
                    }
                    for (WrappedGoal goal : toRemove) {
                        goals.remove(goal);
                    }
                    try {
                        Field availableGoalsField = pathfinderMob.goalSelector.getClass().getDeclaredField("availableGoals");
                        availableGoalsField.setAccessible(true);
                        Set availableGoals = (Set)availableGoalsField.get(pathfinderMob.goalSelector);
                        ArrayList<WrappedGoal> toRemoveAvailable = new ArrayList<WrappedGoal>();
                        for (WrappedGoal goal : availableGoals) {
                            if (!(goal.getGoal() instanceof AvoidEntityGoal)) continue;
                            toRemoveAvailable.add(goal);
                        }
                        for (WrappedGoal goal : toRemoveAvailable) {
                            availableGoals.remove(goal);
                        }
                    }
                    catch (NoSuchFieldException availableGoalsField) {
                        // empty catch block
                    }
                    try {
                        Field newTasksField = pathfinderMob.goalSelector.getClass().getDeclaredField("newTasks");
                        newTasksField.setAccessible(true);
                        Set newTasks = (Set)newTasksField.get(pathfinderMob.goalSelector);
                        ArrayList<WrappedGoal> toRemoveNew = new ArrayList<WrappedGoal>();
                        for (WrappedGoal goal : newTasks) {
                            if (!(goal.getGoal() instanceof AvoidEntityGoal)) continue;
                            toRemoveNew.add(goal);
                        }
                        for (WrappedGoal goal : toRemoveNew) {
                            newTasks.remove(goal);
                        }
                    }
                    catch (NoSuchFieldException newTasksField) {
                        // empty catch block
                    }
                    try {
                        ArrayList<WrappedGoal> preservedGoals = new ArrayList<WrappedGoal>();
                        for (WrappedGoal goal : goals) {
                            if (goal.getGoal() instanceof AvoidEntityGoal) continue;
                            preservedGoals.add(goal);
                        }
                        goals.clear();
                        for (WrappedGoal goal : preservedGoals) {
                            goals.add(goal);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++successCount;
        }
        int finalSuccessCount = successCount;
        if (finalSuccessCount > 0) {
            source.sendSuccess(() -> Component.literal((String)("\u5df2\u6e05\u9664 " + finalSuccessCount + " \u4e2a\u5b9e\u4f53\u7684\u6240\u6709\u5bb3\u6015\u884c\u4e3a")), true);
        }
        if (!failedEntities.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)("\u4ee5\u4e0b\u5b9e\u4f53\u4e0d\u662f\u5177\u6709AI\u7684\u751f\u7269\u5b9e\u4f53: " + String.join((CharSequence)", ", failedEntities))));
        }
        return successCount;
    }

    private static int makeTeamAfraid(CommandSourceStack source, String team1, String team2, int distance) {
        ServerLevel level = source.getLevel();
        List<PathfinderMob> team1Mobs = AfraidCommand.getTeamMobs(level, team1);
        List<PathfinderMob> team2Mobs = AfraidCommand.getTeamMobs(level, team2);
        if (team1Mobs.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)("\u961f\u4f0d " + team1 + " \u4e2d\u6ca1\u6709\u627e\u5230\u5177\u6709AI\u7684\u751f\u7269\u5b9e\u4f53")));
            return 0;
        }
        if (team2Mobs.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)("\u961f\u4f0d " + team2 + " \u4e2d\u6ca1\u6709\u627e\u5230\u5177\u6709AI\u7684\u751f\u7269\u5b9e\u4f53")));
            return 0;
        }
        Collections.shuffle(team1Mobs);
        Collections.shuffle(team2Mobs);
        int assignments = 0;
        Random random = new Random();
        ArrayList<PathfinderMob> originalTeam1Mobs = new ArrayList<PathfinderMob>(team1Mobs);
        for (PathfinderMob team2Mob : team2Mobs) {
            PathfinderMob finalTarget;
            float fastSpeed;
            float slowSpeed;
            PathfinderMob target;
            if (!team1Mobs.isEmpty()) {
                target = team1Mobs.remove(0);
                try {
                    float fleeDistance = distance;
                    slowSpeed = 1.0f;
                    fastSpeed = 1.5f;
                    finalTarget = target;
                    team2Mob.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal(team2Mob, LivingEntity.class, fleeDistance, slowSpeed, fastSpeed){

                        public boolean canUse() {
                            return super.canUse() && this.toAvoid.equals((Object)finalTarget);
                        }
                    });
                    ++assignments;
                }
                catch (Exception e) {
                    team2Mob.setTarget((LivingEntity)target);
                    ++assignments;
                }
                continue;
            }
            target = (PathfinderMob)originalTeam1Mobs.get(random.nextInt(originalTeam1Mobs.size()));
            try {
                float fleeDistance = distance;
                slowSpeed = 1.0f;
                fastSpeed = 1.5f;
                finalTarget = target;
                team2Mob.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal(team2Mob, LivingEntity.class, fleeDistance, slowSpeed, fastSpeed){

                    public boolean canUse() {
                        return super.canUse() && this.toAvoid.equals((Object)finalTarget);
                    }
                });
                ++assignments;
            }
            catch (Exception e) {
                team2Mob.setTarget((LivingEntity)target);
                ++assignments;
            }
        }
        int finalAssignments = assignments;
        String finalTeam1 = team1;
        String finalTeam2 = team2;
        int finalDistance = distance;
        source.sendSuccess(() -> Component.literal((String)("\u5df2\u4e3a\u961f\u4f0d " + finalTeam2 + " \u4e2d\u7684 " + finalAssignments + " \u4e2a\u5b9e\u4f53\u5206\u914d\u4e86\u961f\u4f0d " + finalTeam1 + " \u4e2d\u7684\u5bb3\u6015\u76ee\u6807 (\u9003\u79bb\u8ddd\u79bb: " + finalDistance + " \u683c)")), true);
        return assignments;
    }

    private static List<PathfinderMob> getTeamMobs(ServerLevel level, String teamName) {
        ArrayList<PathfinderMob> mobs = new ArrayList<PathfinderMob>();
        for (Entity entity : level.getAllEntities()) {
            PathfinderMob mob;
            if (!(entity instanceof PathfinderMob) || !AfraidCommand.isEntityInTeam((Entity)(mob = (PathfinderMob)entity), teamName)) continue;
            mobs.add(mob);
        }
        return mobs;
    }

    private static boolean isEntityInTeam(Entity entity, String teamName) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getTeam() != null && player.getTeam().getName().equals(teamName);
        }
        if (entity.getTeam() != null) {
            return entity.getTeam().getName().equals(teamName);
        }
        return entity.getTags().contains(teamName);
    }
}

