/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;

public class AngryCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"angry").then(Commands.literal((String)"entity").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"attacker", (ArgumentType)EntityArgument.entity()).executes(context -> AngryCommand.makeAngry((CommandSourceStack)context.getSource(), EntityArgument.getEntity((CommandContext)context, (String)"target"), EntityArgument.getEntity((CommandContext)context, (String)"attacker"))))))).then(Commands.literal((String)"stop").executes(context -> AngryCommand.stopAllAngry((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"team").then(Commands.argument((String)"team1", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"team2", (ArgumentType)StringArgumentType.string()).executes(context -> AngryCommand.makeTeamAngry((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team1"), StringArgumentType.getString((CommandContext)context, (String)"team2")))))));
    }

    private static int makeAngry(CommandSourceStack source, Entity target, Entity attacker) throws CommandSyntaxException {
        if (!(target instanceof Mob)) {
            source.sendFailure((Component)Component.literal((String)"\u76ee\u6807\u5fc5\u987b\u662f\u5177\u6709AI\u7684\u751f\u7269\u5b9e\u4f53"));
            return 0;
        }
        Mob mobTarget = (Mob)target;
        if (!(attacker instanceof LivingEntity)) {
            source.sendFailure((Component)Component.literal((String)"\u653b\u51fb\u8005\u5fc5\u987b\u662f\u751f\u7269\u5b9e\u4f53"));
            return 0;
        }
        LivingEntity livingAttacker = (LivingEntity)attacker;
        mobTarget.setTarget(livingAttacker);
        source.sendSuccess(() -> Component.literal((String)("\u5df2\u4f7f " + mobTarget.getName().getString() + " \u4ec7\u6068 " + livingAttacker.getName().getString())), true);
        return 1;
    }

    private static int stopAllAngry(CommandSourceStack source) {
        ServerLevel level = source.getLevel();
        int count = 0;
        for (Entity entity : level.getAllEntities()) {
            Mob mob;
            if (!(entity instanceof Mob) || (mob = (Mob)entity).getTarget() == null) continue;
            mob.setTarget(null);
            ++count;
        }
        int finalCount = count;
        source.sendSuccess(() -> Component.literal((String)("\u5df2\u6e05\u9664 " + finalCount + " \u4e2a\u5b9e\u4f53\u7684\u4ec7\u6068\u76ee\u6807")), true);
        return count;
    }

    private static int makeTeamAngry(CommandSourceStack source, String team1, String team2) {
        ServerLevel level = source.getLevel();
        List<Mob> team1Mobs = AngryCommand.getTeamMobs(level, team1);
        List<Mob> team2Mobs = AngryCommand.getTeamMobs(level, team2);
        if (team1Mobs.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)("\u961f\u4f0d " + team1 + " \u4e2d\u6ca1\u6709\u627e\u5230\u5177\u6709AI\u7684\u751f\u7269\u5b9e\u4f53")));
            return 0;
        }
        if (team2Mobs.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)("\u961f\u4f0d " + team2 + " \u4e2d\u6ca1\u6709\u627e\u5230\u5177\u6709AI\u7684\u751f\u7269\u5b9e\u4f53")));
            return 0;
        }
        Collections.shuffle(team1Mobs);
        Collections.shuffle(team2Mobs);
        int assignments = 0;
        Random random = new Random();
        ArrayList<Mob> originalTeam1Mobs = new ArrayList<Mob>(team1Mobs);
        for (Mob team2Mob : team2Mobs) {
            Mob target;
            if (!team1Mobs.isEmpty()) {
                target = team1Mobs.remove(0);
                team2Mob.setTarget((LivingEntity)target);
                ++assignments;
                continue;
            }
            target = (Mob)originalTeam1Mobs.get(random.nextInt(originalTeam1Mobs.size()));
            team2Mob.setTarget((LivingEntity)target);
            ++assignments;
        }
        int finalAssignments = assignments;
        String finalTeam1 = team1;
        String finalTeam2 = team2;
        source.sendSuccess(() -> Component.literal((String)("\u5df2\u4e3a\u961f\u4f0d " + finalTeam2 + " \u4e2d\u7684 " + finalAssignments + " \u4e2a\u5b9e\u4f53\u5206\u914d\u4e86\u961f\u4f0d " + finalTeam1 + " \u4e2d\u7684\u4ec7\u6068\u76ee\u6807")), true);
        return assignments;
    }

    private static List<Mob> getTeamMobs(ServerLevel level, String teamName) {
        ArrayList<Mob> mobs = new ArrayList<Mob>();
        for (Entity entity : level.getAllEntities()) {
            Mob mob;
            if (!(entity instanceof Mob) || !AngryCommand.isEntityInTeam((Entity)(mob = (Mob)entity), teamName)) continue;
            mobs.add(mob);
        }
        return mobs;
    }

    private static boolean isEntityInTeam(Entity entity, String teamName) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getTeam() != null && player.getTeam().getName().equals(teamName);
        }
        if (entity.getTeam() != null) {
            return entity.getTeam().getName().equals(teamName);
        }
        return entity.getTags().contains(teamName);
    }
}

