/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;

public class ProtectCommand {
    private static final Map<UUID, ProtectRelationship> protectRelationships = new HashMap<UUID, ProtectRelationship>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"protect").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"protector", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"follow", (ArgumentType)BoolArgumentType.bool()).executes(context -> ProtectCommand.setProtect((CommandSourceStack)context.getSource(), EntityArgument.getEntity((CommandContext)context, (String)"target"), EntityArgument.getEntity((CommandContext)context, (String)"protector"), BoolArgumentType.getBool((CommandContext)context, (String)"follow"))))))).then(Commands.literal((String)"remove").executes(context -> ProtectCommand.removeAllProtect((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"reload").executes(context -> ProtectCommand.reloadProtect((CommandSourceStack)context.getSource()))));
    }

    private static int setProtect(CommandSourceStack source, Entity target, Entity protector, boolean follow) throws CommandSyntaxException {
        if (!(target instanceof LivingEntity)) {
            source.sendFailure((Component)Component.literal((String)"\u76ee\u6807\u5fc5\u987b\u662f\u751f\u7269\u5b9e\u4f53"));
            return 0;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        if (!(protector instanceof Mob)) {
            source.sendFailure((Component)Component.literal((String)"\u4fdd\u62a4\u8005\u5fc5\u987b\u662f\u5177\u6709AI\u7684\u751f\u7269\u5b9e\u4f53"));
            return 0;
        }
        Mob mobProtector = (Mob)protector;
        if (!(mobProtector instanceof PathfinderMob)) {
            source.sendFailure((Component)Component.literal((String)"\u4fdd\u62a4\u8005\u5fc5\u987b\u662fPathfinderMob\u7c7b\u578b"));
            return 0;
        }
        PathfinderMob pathfinderProtector = (PathfinderMob)mobProtector;
        ProtectRelationship relationship = new ProtectRelationship(livingTarget.getUUID(), pathfinderProtector.getUUID(), follow);
        protectRelationships.put(pathfinderProtector.getUUID(), relationship);
        ProtectCommand.saveProtectionToNBT(pathfinderProtector, livingTarget.getUUID(), follow);
        ProtectCommand.saveProtectedByToNBT(livingTarget, pathfinderProtector.getUUID());
        ProtectCommand.addProtectAI(pathfinderProtector, livingTarget, follow);
        String followText = follow ? "\u5e76\u8ddf\u968f" : "\u4f46\u4e0d\u8ddf\u968f";
        source.sendSuccess(() -> Component.literal((String)("\u5df2\u8bbe\u7f6e " + pathfinderProtector.getName().getString() + " \u4fdd\u62a4 " + livingTarget.getName().getString() + " " + followText)), true);
        return 1;
    }

    private static int removeAllProtect(CommandSourceStack source) {
        int removedCount = 0;
        HashMap<UUID, ProtectRelationship> relationshipsCopy = new HashMap<UUID, ProtectRelationship>(protectRelationships);
        for (UUID protectorUUID : relationshipsCopy.keySet()) {
            Entity protectedEntity;
            ServerLevel level;
            Entity entity;
            ProtectRelationship relationship = (ProtectRelationship)relationshipsCopy.get(protectorUUID);
            protectRelationships.remove(protectorUUID);
            if (!(source.getLevel() instanceof ServerLevel) || !((entity = (level = source.getLevel()).getEntity(protectorUUID)) instanceof PathfinderMob)) continue;
            PathfinderMob mob = (PathfinderMob)entity;
            ProtectCommand.removeProtectAI(mob);
            CompoundTag nbt = mob.getPersistentData();
            nbt.remove("ProtectData");
            if (relationship != null && (protectedEntity = level.getEntity(relationship.getTargetUUID())) instanceof LivingEntity) {
                CompoundTag protectedNbt = protectedEntity.getPersistentData();
                protectedNbt.remove("ProtectorData");
            }
            ++removedCount;
        }
        int finalRemovedCount = removedCount;
        source.sendSuccess(() -> Component.literal((String)("\u5df2\u6e05\u9664 " + finalRemovedCount + " \u4e2a\u4fdd\u62a4\u5173\u7cfb")), true);
        return removedCount;
    }

    private static int reloadProtect(CommandSourceStack source) {
        protectRelationships.clear();
        int loadedCount = 0;
        for (ServerLevel level : source.getServer().getAllLevels()) {
            for (Entity entity : level.getAllEntities()) {
                if (entity instanceof PathfinderMob) {
                    PathfinderMob mob = (PathfinderMob)entity;
                    ProtectCommand.loadProtectionFromNBT(mob);
                    ++loadedCount;
                    continue;
                }
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                ProtectCommand.loadProtectorsFromNBT(livingEntity);
            }
        }
        int finalLoadedCount = loadedCount;
        source.sendSuccess(() -> Component.literal((String)("\u5df2\u91cd\u8f7d " + finalLoadedCount + " \u4e2a\u5b9e\u4f53\u7684\u4fdd\u62a4\u5173\u7cfb")), true);
        return loadedCount;
    }

    private static void removeProtectAI(PathfinderMob mob) {
        mob.targetSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof ProtectTargetGoal);
        mob.goalSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof ProtectGoal || goal.getGoal() instanceof FollowGoal);
    }

    private static void addProtectAI(PathfinderMob protector, LivingEntity target, boolean follow) {
        protector.targetSelector.addGoal(1, (Goal)new ProtectTargetGoal(protector, target));
        protector.goalSelector.addGoal(2, (Goal)new ProtectGoal(protector, target));
        if (target instanceof Mob) {
            Mob targetMob = (Mob)target;
            targetMob.goalSelector.addGoal(0, (Goal)new PreventAttackProtectorGoal(targetMob));
        }
        if (follow) {
            protector.goalSelector.addGoal(3, (Goal)new FollowGoal(protector, target));
        }
    }

    public static ProtectRelationship getProtectRelationship(UUID protectorUUID) {
        return protectRelationships.get(protectorUUID);
    }

    public static void removeProtect(UUID protectorUUID) {
        ProtectRelationship relationship = protectRelationships.remove(protectorUUID);
        if (relationship != null) {
            // empty if block
        }
    }

    private static void removeProtectorFromNBT(LivingEntity protectedTarget, UUID protectorUUID) {
        CompoundTag nbt = protectedTarget.getPersistentData();
        if (nbt.contains("Protectors")) {
            ListTag protectorsList = nbt.getList("Protectors").orElse(new ListTag());
            ListTag newProtectorsList = new ListTag();
            for (int i = 0; i < protectorsList.size(); ++i) {
                CompoundTag protectorTag = protectorsList.getCompound(i).orElse(new CompoundTag());
                if (protectorTag.getString("UUID").orElse("").equals(protectorUUID.toString())) continue;
                newProtectorsList.add((Object)protectorTag);
            }
            if (newProtectorsList.isEmpty()) {
                nbt.remove("Protectors");
            } else {
                nbt.put("Protectors", (Tag)newProtectorsList);
            }
        }
    }

    public static void removeProtectRelationshipByProtected(UUID protectedUUID) {
        HashMap<UUID, ProtectRelationship> relationshipsCopy = new HashMap<UUID, ProtectRelationship>(protectRelationships);
        for (Map.Entry entry : relationshipsCopy.entrySet()) {
            UUID protectorUUID = (UUID)entry.getKey();
            ProtectRelationship relationship = (ProtectRelationship)entry.getValue();
            if (!relationship.getTargetUUID().equals(protectedUUID)) continue;
            protectRelationships.remove(protectorUUID);
        }
    }

    public static void removeProtectRelationship(UUID protectorUUID) {
        if (protectRelationships.containsKey(protectorUUID)) {
            protectRelationships.remove(protectorUUID);
        }
    }

    private static void saveProtectionToNBT(PathfinderMob protector, UUID protectedUUID) {
        ProtectCommand.saveProtectionToNBT(protector, protectedUUID, true);
    }

    private static void saveProtectionToNBT(PathfinderMob protector, UUID protectedUUID, boolean follow) {
        CompoundTag nbt = protector.getPersistentData();
        CompoundTag protectTag = new CompoundTag();
        protectTag.putString("TargetUUID", protectedUUID.toString());
        protectTag.putBoolean("Follow", follow);
        protectTag.putLong("SetupTime", System.currentTimeMillis());
        nbt.put("ProtectData", (Tag)protectTag);
    }

    private static void saveProtectedByToNBT(LivingEntity protectedTarget, UUID protectorUUID) {
        CompoundTag nbt = protectedTarget.getPersistentData();
        ListTag protectorsList = nbt.contains("Protectors") ? nbt.getList("Protectors").orElse(new ListTag()) : new ListTag();
        boolean exists = false;
        for (int i = 0; i < protectorsList.size(); ++i) {
            CompoundTag protectorTag = protectorsList.getCompound(i).orElse(new CompoundTag());
            if (!protectorTag.getString("UUID").orElse("").equals(protectorUUID.toString())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            CompoundTag protectorTag = new CompoundTag();
            protectorTag.putString("UUID", protectorUUID.toString());
            protectorTag.putLong("SetupTime", System.currentTimeMillis());
            protectorsList.add((Object)protectorTag);
            nbt.put("Protectors", (Tag)protectorsList);
        }
    }

    public static void loadProtectionFromNBT(PathfinderMob protector) {
        CompoundTag nbt = protector.getPersistentData();
        if (nbt.contains("ProtectData")) {
            CompoundTag protectTag = nbt.getCompound("ProtectData").orElse(new CompoundTag());
            String targetUUIDStr = protectTag.getString("TargetUUID").orElse("");
            boolean follow = protectTag.getBoolean("Follow").orElse(false);
            try {
                UUID targetUUID = UUID.fromString(targetUUIDStr);
                if (protector.level().getEntity(targetUUID) instanceof LivingEntity) {
                    LivingEntity protectedTarget = (LivingEntity)protector.level().getEntity(targetUUID);
                    ProtectRelationship relationship = new ProtectRelationship(targetUUID, protector.getUUID(), follow);
                    protectRelationships.put(protector.getUUID(), relationship);
                    ProtectCommand.setupProtection(protector, protectedTarget, follow);
                }
            }
            catch (IllegalArgumentException e) {
                nbt.remove("ProtectData");
            }
        }
    }

    public static void loadProtectorsFromNBT(LivingEntity protectedTarget) {
        CompoundTag nbt = protectedTarget.getPersistentData();
        if (nbt.contains("Protectors")) {
            ListTag protectorsList = nbt.getList("Protectors").orElse(new ListTag());
            for (int i = 0; i < protectorsList.size(); ++i) {
                CompoundTag protectorTag = protectorsList.getCompound(i).orElse(new CompoundTag());
                if (!protectorTag.contains("UUID")) continue;
                String protectorUUIDStr = protectorTag.getString("UUID").orElse("");
                try {
                    UUID protectorUUID = UUID.fromString(protectorUUIDStr);
                    PathfinderMob protector = null;
                    for (ServerLevel level : protectedTarget.level().getServer().getAllLevels()) {
                        for (Entity entity : level.getAllEntities()) {
                            if (!(entity instanceof PathfinderMob) || !entity.getUUID().equals(protectorUUID)) continue;
                            protector = (PathfinderMob)entity;
                            break;
                        }
                        if (protector == null) continue;
                        break;
                    }
                    if (protector == null || protectRelationships.containsKey(protectorUUID)) continue;
                    boolean follow = false;
                    CompoundTag protectorNbt = protector.getPersistentData();
                    if (protectorNbt.contains("ProtectData")) {
                        CompoundTag protectTag = protectorNbt.getCompound("ProtectData").orElse(new CompoundTag());
                        follow = protectTag.getBoolean("Follow").orElse(false);
                    }
                    ProtectRelationship relationship = new ProtectRelationship(protectedTarget.getUUID(), protectorUUID, follow);
                    protectRelationships.put(protectorUUID, relationship);
                    ProtectCommand.addProtectAI(protector, protectedTarget, follow);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
    }

    public static void setupProtection(PathfinderMob protector, LivingEntity target, boolean follow) {
        ProtectRelationship relationship = new ProtectRelationship(target.getUUID(), protector.getUUID(), follow);
        protectRelationships.put(protector.getUUID(), relationship);
        CompoundTag nbt = protector.getPersistentData();
        CompoundTag protectTag = new CompoundTag();
        protectTag.putString("TargetUUID", target.getUUID().toString());
        protectTag.putBoolean("Follow", follow);
        nbt.put("ProtectData", (Tag)protectTag);
        ProtectCommand.saveProtectedByToNBT(target, protector.getUUID());
        ProtectCommand.addProtectAI(protector, target, follow);
    }

    private static List<PathfinderMob> getProtectorsOfEntity(Mob protectedEntity) {
        ArrayList<PathfinderMob> protectors = new ArrayList<PathfinderMob>();
        CompoundTag nbt = protectedEntity.getPersistentData();
        if (nbt.contains("Protectors")) {
            ListTag protectorsList = nbt.getList("Protectors").orElse(new ListTag());
            for (int i = 0; i < protectorsList.size(); ++i) {
                CompoundTag protectorTag = protectorsList.getCompound(i).orElse(new CompoundTag());
                String protectorUUIDStr = protectorTag.getString("UUID").orElse("");
                try {
                    UUID protectorUUID = UUID.fromString(protectorUUIDStr);
                    block3: for (ServerLevel level : protectedEntity.level().getServer().getAllLevels()) {
                        for (Entity entity : level.getAllEntities()) {
                            if (!(entity instanceof PathfinderMob) || !entity.getUUID().equals(protectorUUID)) continue;
                            protectors.add((PathfinderMob)entity);
                            continue block3;
                        }
                    }
                    continue;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        return protectors;
    }

    public static class ProtectRelationship {
        private final UUID targetUUID;
        private final UUID protectorUUID;
        private final boolean follow;

        public ProtectRelationship(UUID targetUUID, UUID protectorUUID, boolean follow) {
            this.targetUUID = targetUUID;
            this.protectorUUID = protectorUUID;
            this.follow = follow;
        }

        public UUID getTargetUUID() {
            return this.targetUUID;
        }

        public UUID getProtectorUUID() {
            return this.protectorUUID;
        }

        public boolean shouldFollow() {
            return this.follow;
        }
    }

    private static class ProtectTargetGoal
    extends TargetGoal {
        private final LivingEntity protectedTarget;
        private final PathfinderMob protector;

        public ProtectTargetGoal(PathfinderMob mob, LivingEntity protectedTarget) {
            super((Mob)mob, false, true);
            this.protectedTarget = protectedTarget;
            this.protector = mob;
        }

        public boolean canUse() {
            Mob protectedMob;
            if (this.mob.getTarget() == this.protectedTarget) {
                this.mob.setTarget(null);
                return false;
            }
            if (this.protectedTarget instanceof Mob && (protectedMob = (Mob)this.protectedTarget).getTarget() == this.protector) {
                protectedMob.setTarget(null);
                return false;
            }
            if (this.mob.getTarget() instanceof PathfinderMob) {
                PathfinderMob targetMob = (PathfinderMob)this.mob.getTarget();
                CompoundTag targetNbt = targetMob.getPersistentData();
                CompoundTag protectorNbt = this.protector.getPersistentData();
                if (targetNbt.contains("ProtectData") && protectorNbt.contains("ProtectData")) {
                    String protectorTargetUUID;
                    CompoundTag targetProtectTag = targetNbt.getCompound("ProtectData").orElse(new CompoundTag());
                    CompoundTag protectorProtectTag = protectorNbt.getCompound("ProtectData").orElse(new CompoundTag());
                    String targetTargetUUID = targetProtectTag.getString("TargetUUID").orElse("");
                    if (targetTargetUUID.equals(protectorTargetUUID = protectorProtectTag.getString("TargetUUID").orElse(""))) {
                        this.mob.setTarget(null);
                        return false;
                    }
                }
            }
            return false;
        }

        public void start() {
        }
    }

    private static class ProtectGoal
    extends Goal {
        private final PathfinderMob protector;
        private final LivingEntity protectedTarget;

        public ProtectGoal(PathfinderMob protector, LivingEntity protectedTarget) {
            this.protector = protector;
            this.protectedTarget = protectedTarget;
        }

        public boolean canUse() {
            Mob protectedMob;
            if (this.protectedTarget.getLastHurtByMob() != null && this.protectedTarget.getLastHurtByMob().isAlive()) {
                return true;
            }
            return this.protectedTarget instanceof Mob && (protectedMob = (Mob)this.protectedTarget).getTarget() != null && protectedMob.getTarget().isAlive() && protectedMob.getTarget() != this.protector;
        }

        public void tick() {
            LivingEntity target;
            Mob protectedMob;
            if (this.protectedTarget.getLastHurtByMob() != null && this.protectedTarget.getLastHurtByMob().isAlive()) {
                this.protector.setTarget(this.protectedTarget.getLastHurtByMob());
            } else if (this.protectedTarget instanceof Mob && (protectedMob = (Mob)this.protectedTarget).getTarget() != null && protectedMob.getTarget().isAlive() && (target = protectedMob.getTarget()) != this.protector) {
                this.protector.setTarget(target);
            }
        }

        public boolean canContinueToUse() {
            ProtectRelationship relationship = ProtectCommand.getProtectRelationship(this.protector.getUUID());
            if (relationship == null) {
                return false;
            }
            return this.protectedTarget.isAlive() && this.protector.isAlive();
        }

        public void stop() {
            if (this.protector.getTarget() != null) {
                Player playerTarget;
                LivingEntity target = this.protector.getTarget();
                if (!target.isAlive()) {
                    this.protector.setTarget(null);
                    return;
                }
                if (target instanceof Player && ((playerTarget = (Player)target).isCreative() || playerTarget.isSpectator())) {
                    this.protector.setTarget(null);
                    return;
                }
                LivingEntity lastAttacker = this.protectedTarget.getLastHurtByMob();
                LivingEntity protectedTargetTarget = null;
                if (this.protectedTarget instanceof Mob) {
                    Mob protectedMob = (Mob)this.protectedTarget;
                    protectedTargetTarget = protectedMob.getTarget();
                }
                if (target != lastAttacker && target != protectedTargetTarget) {
                    this.protector.setTarget(null);
                }
            }
        }
    }

    private static class PreventAttackProtectorGoal
    extends Goal {
        private final Mob protectedMob;

        public PreventAttackProtectorGoal(Mob mob) {
            this.protectedMob = mob;
        }

        public boolean canUse() {
            return true;
        }

        public void start() {
        }

        public void tick() {
            CompoundTag targetProtectTag;
            String targetTargetUUID;
            PathfinderMob targetMob;
            CompoundTag targetNbt;
            List<PathfinderMob> protectors = ProtectCommand.getProtectorsOfEntity(this.protectedMob);
            for (PathfinderMob protector : protectors) {
                if (protector.getTarget() == this.protectedMob) {
                    protector.setTarget(null);
                    protector.setNoActionTime(100);
                }
                if (this.protectedMob.getLastHurtByMob() == protector) {
                    this.protectedMob.setTarget(null);
                    this.protectedMob.setLastHurtByMob(null);
                    this.protectedMob.setNoActionTime(100);
                }
                if (this.protectedMob.getTarget() == protector) {
                    this.protectedMob.setTarget(null);
                    this.protectedMob.setNoActionTime(100);
                }
                this.protectedMob.setTarget(null);
                this.protectedMob.setLastHurtByMob(null);
                this.protectedMob.setNoActionTime(20);
            }
            if (this.protectedMob.getTarget() instanceof PathfinderMob && (targetNbt = (targetMob = (PathfinderMob)this.protectedMob.getTarget()).getPersistentData()).contains("ProtectData") && (targetTargetUUID = (targetProtectTag = targetNbt.getCompound("ProtectData").orElse(new CompoundTag())).getString("TargetUUID").orElse("")).equals(this.protectedMob.getUUID().toString())) {
                this.protectedMob.setTarget(null);
                this.protectedMob.setNoActionTime(100);
            }
        }
    }

    private static class FollowGoal
    extends Goal {
        private final PathfinderMob protector;
        private final LivingEntity protectedTarget;

        public FollowGoal(PathfinderMob protector, LivingEntity protectedTarget) {
            this.protector = protector;
            this.protectedTarget = protectedTarget;
        }

        public boolean canUse() {
            ProtectRelationship relationship = ProtectCommand.getProtectRelationship(this.protector.getUUID());
            return relationship != null;
        }

        public boolean canContinueToUse() {
            ProtectRelationship relationship = ProtectCommand.getProtectRelationship(this.protector.getUUID());
            if (relationship == null) {
                return false;
            }
            return this.protectedTarget.isAlive() && this.protector.isAlive();
        }

        public void tick() {
            double distance = this.protector.distanceToSqr((Entity)this.protectedTarget);
            double distanceSqrt = Math.sqrt(distance);
            if (distanceSqrt > 40.0) {
                boolean teleported = false;
                for (int i = 0; i < 10; ++i) {
                    double offsetX = (Math.random() - 0.5) * 4.0;
                    double offsetZ = (Math.random() - 0.5) * 4.0;
                    double targetX = this.protectedTarget.getX() + offsetX;
                    double targetY = this.protectedTarget.getY();
                    double targetZ = this.protectedTarget.getZ() + offsetZ;
                    if (!this.protector.level().getBlockState(new BlockPos((int)targetX, (int)targetY, (int)targetZ)).isSolidRender()) continue;
                    this.protector.teleportTo(targetX, targetY + 1.0, targetZ);
                    teleported = true;
                    break;
                }
                if (!teleported) {
                    this.protector.teleportTo(this.protectedTarget.getX() + (Math.random() - 0.5) * 2.0, this.protectedTarget.getY(), this.protectedTarget.getZ() + (Math.random() - 0.5) * 2.0);
                }
            } else if (distanceSqrt > 20.0) {
                this.protector.getNavigation().moveTo((Entity)this.protectedTarget, 1.5);
            }
        }

        public void stop() {
        }
    }
}

