/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpawnCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"spawn").then(Commands.literal((String)"author").executes(context -> SpawnCommand.spawnMannequin((CommandSourceStack)context.getSource()))));
    }

    private static int spawnMannequin(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        ServerLevel level = source.getLevel();
        Vec3 pos = player.position();
        EntityType entityType = EntityType.byString((String)"mannequin").orElse(null);
        if (entityType == null) {
            source.sendFailure((Component)Component.literal((String)"\u65e0\u6cd5\u627e\u5230mannequin\u5b9e\u4f53\u7c7b\u578b"));
            return 0;
        }
        Entity entity = entityType.create((Level)level, null);
        if (entity == null) {
            source.sendFailure((Component)Component.literal((String)"\u65e0\u6cd5\u521b\u5efamannequin\u5b9e\u4f53"));
            return 0;
        }
        entity.setPos(pos.x(), pos.y(), pos.z());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.setHealth(20.0f);
            MutableComponent customName = Component.literal((String)"\uff01").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)"zhishuanghupi").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)"\uff01").withStyle(ChatFormatting.RED));
            livingEntity.setCustomName((Component)customName);
            livingEntity.setCustomNameVisible(true);
            livingEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.COMMAND_BLOCK));
            livingEntity.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.STRUCTURE_BLOCK));
            livingEntity.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.LIGHT));
            entity.getPersistentData().putString("profile_name", "zhishuanghupi");
            entity.getPersistentData().putString("description_color", "yellow");
            entity.getPersistentData().putString("description_underlined", "1b");
            entity.getPersistentData().putString("description_text", "AUTHOR");
        }
        level.addFreshEntity(entity);
        source.sendSuccess(() -> Component.literal((String)"\u5df2\u751f\u6210Mannequin"), true);
        return 1;
    }
}

