/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod.event;

import com.example.examplemod.ai.SpiderWebShootGoal;
import com.example.examplemod.ai.WitchSummonZombiesGoal;
import com.example.examplemod.ai.ZombieAvoidTNTGoal;
import com.example.examplemod.ai.ZombieAxeAttackGoal;
import com.example.examplemod.ai.ZombieBowAttackGoal;
import com.example.examplemod.ai.ZombieCrossbowAttackGoal;
import com.example.examplemod.ai.ZombieElytraGoal;
import com.example.examplemod.ai.ZombieMaceAttackGoal;
import com.example.examplemod.ai.ZombiePickaxeAttackGoal;
import com.example.examplemod.ai.ZombiePickupFlintAndSteelGoal;
import com.example.examplemod.ai.ZombiePotionAttackGoal;
import com.example.examplemod.ai.ZombieShieldDefenseGoal;
import com.example.examplemod.ai.ZombieShovelAttackGoal;
import com.example.examplemod.ai.ZombieTNTThrowGoal;
import com.example.examplemod.command.ProtectCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="vanilla_mob_remake")
public class ModEvents {
    private static final Random random = new Random();
    private static final Map<UUID, ZombieShieldDefenseGoal> shieldAIs = new HashMap<UUID, ZombieShieldDefenseGoal>();

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof Zombie) {
            Zombie zombie = (Zombie)event.getEntity();
            ModEvents.updateZombieAI(zombie);
        } else if (event.getEntity() instanceof Spider) {
            Spider spider = (Spider)event.getEntity();
            ModEvents.updateSpiderAI(spider);
        } else if (event.getEntity() instanceof Witch) {
            Witch witch = (Witch)event.getEntity();
            ModEvents.updateWitchAI(witch);
        }
    }

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof Zombie) {
            Zombie zombie = (Zombie)event.getEntity();
            ModEvents.updateZombieAI(zombie);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        UUID deadEntityUUID = event.getEntity().getUUID();
        ProtectCommand.removeProtectRelationshipByProtected(deadEntityUUID);
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            Level level = player.level();
            if (!level.isClientSide()) {
                BlockPos deathPos = BlockPos.containing((double)player.getX(), (double)player.getY(), (double)player.getZ());
                level.setBlock(deathPos, Blocks.CHEST.defaultBlockState(), 3);
                BlockEntity blockEntity = level.getBlockEntity(deathPos);
                if (blockEntity instanceof ChestBlockEntity) {
                    ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                    ModEvents.transferPlayerItemsToChest(player, chest);
                }
            }
        } else if (event.getEntity() instanceof Zombie) {
            ItemStack offHandItem;
            Zombie zombie = (Zombie)event.getEntity();
            if (zombie.getPersistentData().contains("witch_guard")) {
                UUID witchId = new UUID(zombie.getPersistentData().getLong("witch_owner_most").orElse(0L), zombie.getPersistentData().getLong("witch_owner_least").orElse(0L));
                WitchSummonZombiesGoal.removeGuard(witchId, zombie.getUUID());
                ProtectCommand.removeProtectRelationship(zombie.getUUID());
            }
            if (!(offHandItem = zombie.getOffhandItem()).isEmpty()) {
                zombie.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                ItemEntity droppedItem = new ItemEntity(zombie.level(), zombie.getX(), zombie.getY(), zombie.getZ(), offHandItem.copy());
                zombie.level().addFreshEntity((Entity)droppedItem);
            }
        } else if (event.getEntity() instanceof Spider) {
            Spider spider = (Spider)event.getEntity();
            SpiderWebShootGoal.onSpiderDeath(spider.getUUID());
        }
        SpiderWebShootGoal.onTargetDeath(event.getEntity().getUUID());
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() instanceof Zombie) {
            Zombie zombie = (Zombie)event.getEntity();
            UUID zombieUUID = zombie.getUUID();
            if (shieldAIs.containsKey(zombieUUID)) {
                ZombieShieldDefenseGoal shieldAI = shieldAIs.get(zombieUUID);
                shieldAI.tick();
            }
        } else if (event.getEntity() instanceof Witch) {
            WitchSummonZombiesGoal.globalTick();
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Zombie zombie;
        UUID zombieUUID;
        if (event.getEntity() instanceof Zombie && shieldAIs.containsKey(zombieUUID = (zombie = (Zombie)event.getEntity()).getUUID())) {
            boolean isMagicDamage;
            ZombieShieldDefenseGoal shieldAI = shieldAIs.get(zombieUUID);
            LivingEntity attacker = null;
            if (event.getSource().getEntity() instanceof LivingEntity) {
                attacker = (LivingEntity)event.getSource().getEntity();
            }
            boolean isAxeAttack = ZombieShieldDefenseGoal.isAttackerUsingAxe(event.getSource().getEntity());
            boolean isWardenAttack = ZombieShieldDefenseGoal.isAttackerWarden(event.getSource().getEntity());
            if (shieldAI.isShieldUp() && (isAxeAttack || isWardenAttack)) {
                shieldAI.breakShield();
                zombie.invulnerableTime = 20;
                return;
            }
            boolean bl = isMagicDamage = event.getSource().is(DamageTypes.MAGIC) || event.getSource().is(DamageTypes.INDIRECT_MAGIC) || event.getSource().is(DamageTypes.WITHER);
            if (attacker != null && !isMagicDamage && shieldAI.tryRaiseShield(attacker)) {
                zombie.invulnerableTime = 20;
                boolean isExplosion = event.getSource().is(DamageTypes.EXPLOSION);
                if (!isExplosion) {
                    event.getEntity().setDeltaMovement(0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getEntity() instanceof Zombie) {
            Zombie zombie = (Zombie)event.getEntity();
            if (!(event.getLevel() instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)event.getLevel();
            ServerScoreboard scoreboard = level.getScoreboard();
            PlayerTeam zombieTeam = scoreboard.getPlayerTeam("zombie_team");
            if (zombieTeam == null) {
                zombieTeam = scoreboard.addPlayerTeam("zombie_team");
            }
            scoreboard.addPlayerToTeam(zombie.getStringUUID(), zombieTeam);
            int chance = random.nextInt(100);
            if (chance < 1) {
                int tntCount = 1 + random.nextInt(10);
                zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.TNT, tntCount));
                zombie.setItemInHand(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.FLINT_AND_STEEL, 1));
            } else if (chance < 3) {
                zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.BOW, 1));
            } else if (chance < 5) {
                zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.CROSSBOW, 1));
            } else if (chance < 7) {
                zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.POTION, 1));
            } else if (chance < 9) {
                int shovelType = random.nextInt(100);
                if (shovelType < 20) {
                    zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.IRON_SHOVEL, 1));
                } else if (shovelType < 50) {
                    zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.STONE_SHOVEL, 1));
                } else if (shovelType < 70) {
                    zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.COPPER_SHOVEL, 1));
                } else {
                    zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.WOODEN_SHOVEL, 1));
                }
            } else if (chance < 11) {
                int pickaxeType = random.nextInt(100);
                if (pickaxeType < 20) {
                    zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.IRON_PICKAXE, 1));
                } else if (pickaxeType < 50) {
                    zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.STONE_PICKAXE, 1));
                } else if (pickaxeType < 70) {
                    zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.COPPER_PICKAXE, 1));
                } else {
                    zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.WOODEN_PICKAXE, 1));
                }
            } else if (chance < 13) {
                int axeType = random.nextInt(100);
                if (axeType < 20) {
                    zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.IRON_AXE, 1));
                } else if (axeType < 50) {
                    zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.STONE_AXE, 1));
                } else if (axeType < 70) {
                    zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.COPPER_AXE, 1));
                } else {
                    zombie.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.WOODEN_AXE, 1));
                }
            }
            ModEvents.updateZombieAI(zombie);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
    }

    private static void updateZombieAI(Zombie zombie) {
        ItemStack mainHandItem = zombie.getMainHandItem();
        ItemStack offHandItem = zombie.getOffhandItem();
        ItemStack chestArmor = zombie.getItemBySlot(EquipmentSlot.CHEST);
        boolean hasMace = mainHandItem.getItem() == Items.MACE;
        boolean hasBow = mainHandItem.getItem() == Items.BOW;
        boolean hasCrossbow = mainHandItem.getItem() == Items.CROSSBOW;
        boolean hasTNT = mainHandItem.getItem() == Items.TNT;
        boolean hasPotion = mainHandItem.getItem() == Items.POTION;
        boolean hasShovel = mainHandItem.getItem() == Items.WOODEN_SHOVEL || mainHandItem.getItem() == Items.STONE_SHOVEL || mainHandItem.getItem() == Items.COPPER_SHOVEL || mainHandItem.getItem() == Items.IRON_SHOVEL || mainHandItem.getItem() == Items.GOLDEN_SHOVEL || mainHandItem.getItem() == Items.DIAMOND_SHOVEL || mainHandItem.getItem() == Items.NETHERITE_SHOVEL;
        boolean hasPickaxe = mainHandItem.getItem() == Items.WOODEN_PICKAXE || mainHandItem.getItem() == Items.STONE_PICKAXE || mainHandItem.getItem() == Items.COPPER_PICKAXE || mainHandItem.getItem() == Items.IRON_PICKAXE || mainHandItem.getItem() == Items.GOLDEN_PICKAXE || mainHandItem.getItem() == Items.DIAMOND_PICKAXE || mainHandItem.getItem() == Items.NETHERITE_PICKAXE;
        boolean hasAxe = mainHandItem.getItem() == Items.WOODEN_AXE || mainHandItem.getItem() == Items.STONE_AXE || mainHandItem.getItem() == Items.COPPER_AXE || mainHandItem.getItem() == Items.IRON_AXE || mainHandItem.getItem() == Items.GOLDEN_AXE || mainHandItem.getItem() == Items.DIAMOND_AXE || mainHandItem.getItem() == Items.NETHERITE_AXE;
        boolean hasShield = offHandItem.getItem() instanceof ShieldItem;
        boolean hasElytra = chestArmor.getItem() == Items.ELYTRA;
        boolean hasMaceAI = false;
        boolean hasBowAI = false;
        boolean hasCrossbowAI = false;
        boolean hasTNTAI = false;
        boolean hasPotionAI = false;
        boolean hasShovelAI = false;
        boolean hasPickaxeAI = false;
        boolean hasAxeAI = false;
        boolean hasPickupFlintAndSteelAI = false;
        boolean hasShieldDefenseAI = false;
        boolean hasElytraAI = false;
        boolean hasAvoidTNTAI = false;
        for (WrappedGoal wrappedGoal2 : zombie.goalSelector.getAvailableGoals()) {
            if (wrappedGoal2.getGoal() instanceof ZombieMaceAttackGoal) {
                hasMaceAI = true;
            }
            if (wrappedGoal2.getGoal() instanceof ZombieBowAttackGoal) {
                hasBowAI = true;
            }
            if (wrappedGoal2.getGoal() instanceof ZombieCrossbowAttackGoal) {
                hasCrossbowAI = true;
            }
            if (wrappedGoal2.getGoal() instanceof ZombieTNTThrowGoal) {
                hasTNTAI = true;
            }
            if (wrappedGoal2.getGoal() instanceof ZombiePotionAttackGoal) {
                hasPotionAI = true;
            }
            if (wrappedGoal2.getGoal() instanceof ZombieShovelAttackGoal) {
                hasShovelAI = true;
            }
            if (wrappedGoal2.getGoal() instanceof ZombiePickaxeAttackGoal) {
                hasPickaxeAI = true;
            }
            if (wrappedGoal2.getGoal() instanceof ZombieAxeAttackGoal) {
                hasAxeAI = true;
            }
            if (wrappedGoal2.getGoal() instanceof ZombiePickupFlintAndSteelGoal) {
                hasPickupFlintAndSteelAI = true;
            }
            if (wrappedGoal2.getGoal() instanceof ZombieShieldDefenseGoal) {
                hasShieldDefenseAI = true;
            }
            if (wrappedGoal2.getGoal() instanceof ZombieElytraGoal) {
                hasElytraAI = true;
            }
            if (!(wrappedGoal2.getGoal() instanceof ZombieAvoidTNTGoal)) continue;
            hasAvoidTNTAI = true;
        }
        if (hasShield && !hasShieldDefenseAI) {
            ZombieShieldDefenseGoal shieldAI = new ZombieShieldDefenseGoal(zombie);
            zombie.goalSelector.addGoal(1, (Goal)shieldAI);
            shieldAIs.put(zombie.getUUID(), shieldAI);
        } else if (!hasShield && hasShieldDefenseAI) {
            zombie.goalSelector.getAvailableGoals().removeIf(wrappedGoal -> wrappedGoal.getGoal() instanceof ZombieShieldDefenseGoal);
            shieldAIs.remove(zombie.getUUID());
        }
        if (hasMace && !hasMaceAI) {
            zombie.goalSelector.addGoal(2, (Goal)new ZombieMaceAttackGoal(zombie));
        } else if (!hasMace && hasMaceAI) {
            zombie.goalSelector.getAvailableGoals().removeIf(wrappedGoal -> wrappedGoal.getGoal() instanceof ZombieMaceAttackGoal);
        }
        if (hasBow && !hasBowAI) {
            zombie.goalSelector.addGoal(2, (Goal)new ZombieBowAttackGoal(zombie, 1.0, 20, 40, 15.0f));
        } else if (!hasBow && hasBowAI) {
            zombie.goalSelector.getAvailableGoals().removeIf(wrappedGoal -> wrappedGoal.getGoal() instanceof ZombieBowAttackGoal);
        }
        if (hasCrossbow && !hasCrossbowAI) {
            zombie.goalSelector.addGoal(2, (Goal)new ZombieCrossbowAttackGoal(zombie, 1.0, 20, 40, 15.0f));
        } else if (!hasCrossbow && hasCrossbowAI) {
            zombie.goalSelector.getAvailableGoals().removeIf(wrappedGoal -> wrappedGoal.getGoal() instanceof ZombieCrossbowAttackGoal);
        }
        if (hasTNT && !hasTNTAI) {
            zombie.goalSelector.addGoal(2, (Goal)new ZombieTNTThrowGoal(zombie, 1.0, 20, 40, 24.0f));
        } else if (!hasTNT && hasTNTAI) {
            zombie.goalSelector.getAvailableGoals().removeIf(wrappedGoal -> wrappedGoal.getGoal() instanceof ZombieTNTThrowGoal);
        }
        if (hasPotion && !hasPotionAI) {
            zombie.goalSelector.addGoal(2, (Goal)new ZombiePotionAttackGoal(zombie, 1.0, 20, 40, 15.0f, 3.0f));
        } else if (!hasPotion && hasPotionAI) {
            zombie.goalSelector.getAvailableGoals().removeIf(wrappedGoal -> wrappedGoal.getGoal() instanceof ZombiePotionAttackGoal);
        }
        if (hasShovel && !hasShovelAI) {
            zombie.goalSelector.addGoal(2, (Goal)new ZombieShovelAttackGoal(zombie, 1.0, 20, 25.0f));
        } else if (!hasShovel && hasShovelAI) {
            zombie.goalSelector.getAvailableGoals().removeIf(wrappedGoal -> wrappedGoal.getGoal() instanceof ZombieShovelAttackGoal);
        }
        if (hasPickaxe && !hasPickaxeAI) {
            zombie.goalSelector.addGoal(2, (Goal)new ZombiePickaxeAttackGoal(zombie, 1.0, 20, 25.0f));
        } else if (!hasPickaxe && hasPickaxeAI) {
            zombie.goalSelector.getAvailableGoals().removeIf(wrappedGoal -> wrappedGoal.getGoal() instanceof ZombiePickaxeAttackGoal);
        }
        if (hasAxe && !hasAxeAI) {
            zombie.goalSelector.addGoal(2, (Goal)new ZombieAxeAttackGoal(zombie, 1.0, 20, 25.0f));
        } else if (!hasAxe && hasAxeAI) {
            zombie.goalSelector.getAvailableGoals().removeIf(wrappedGoal -> wrappedGoal.getGoal() instanceof ZombieAxeAttackGoal);
        }
        if ((offHandItem.getItem() != Items.FLINT_AND_STEEL || offHandItem.isEmpty()) && !hasPickupFlintAndSteelAI) {
            zombie.goalSelector.addGoal(3, (Goal)new ZombiePickupFlintAndSteelGoal(zombie));
        } else if (offHandItem.getItem() == Items.FLINT_AND_STEEL && !offHandItem.isEmpty() && hasPickupFlintAndSteelAI) {
            zombie.goalSelector.getAvailableGoals().removeIf(wrappedGoal -> wrappedGoal.getGoal() instanceof ZombiePickupFlintAndSteelGoal);
        }
        if (hasElytra && !hasElytraAI) {
            zombie.goalSelector.addGoal(2, (Goal)new ZombieElytraGoal(zombie));
        } else if (!hasElytra && hasElytraAI) {
            zombie.goalSelector.getAvailableGoals().removeIf(wrappedGoal -> wrappedGoal.getGoal() instanceof ZombieElytraGoal);
        }
        if (!hasAvoidTNTAI) {
            zombie.goalSelector.addGoal(3, (Goal)new ZombieAvoidTNTGoal(zombie));
        }
    }

    private static void updateSpiderAI(Spider spider) {
        boolean hasWebShootAI = false;
        for (WrappedGoal wrappedGoal : spider.goalSelector.getAvailableGoals()) {
            if (!(wrappedGoal.getGoal() instanceof SpiderWebShootGoal)) continue;
            hasWebShootAI = true;
            break;
        }
        if (!hasWebShootAI) {
            spider.goalSelector.addGoal(2, (Goal)new SpiderWebShootGoal(spider));
        }
    }

    private static void updateWitchAI(Witch witch) {
        if (witch == null || witch.goalSelector == null) {
            return;
        }
        try {
            boolean hasSummonZombiesAI = false;
            for (WrappedGoal wrappedGoal : witch.goalSelector.getAvailableGoals()) {
                if (wrappedGoal == null || !(wrappedGoal.getGoal() instanceof WitchSummonZombiesGoal)) continue;
                hasSummonZombiesAI = true;
                break;
            }
            if (!hasSummonZombiesAI) {
                witch.goalSelector.addGoal(1, (Goal)new WitchSummonZombiesGoal(witch));
            }
        }
        catch (Exception e) {
            System.err.println("Error updating witch AI: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void transferPlayerItemsToChest(Player player, ChestBlockEntity chest) {
        ItemStack offHandItem;
        ArrayList<ItemStack> itemsToTransfer = new ArrayList<ItemStack>();
        ItemStack mainHandItem = player.getMainHandItem();
        if (!mainHandItem.isEmpty()) {
            itemsToTransfer.add(mainHandItem.copy());
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        if (!(offHandItem = player.getOffhandItem()).isEmpty()) {
            itemsToTransfer.add(offHandItem.copy());
            player.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armorItem;
            if (slot.getType() == EquipmentSlot.Type.HAND || !slot.getName().equals("head") && !slot.getName().equals("chest") && !slot.getName().equals("legs") && !slot.getName().equals("feet") || (armorItem = player.getItemBySlot(slot)).isEmpty()) continue;
            itemsToTransfer.add(armorItem.copy());
            player.setItemSlot(slot, ItemStack.EMPTY);
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack inventoryItem = player.getInventory().getItem(i);
            if (inventoryItem.isEmpty()) continue;
            itemsToTransfer.add(inventoryItem.copy());
            player.getInventory().setItem(i, ItemStack.EMPTY);
        }
        ModEvents.transferItemsToChest(chest, itemsToTransfer);
    }

    private static void transferItemsToChest(ChestBlockEntity chest, List<ItemStack> items) {
        ChestBlockEntity secondChest = null;
        Level level = chest.getLevel();
        for (ItemStack item : items) {
            if (ModEvents.tryAddItemToChest(chest, item)) continue;
            if (secondChest == null && level != null) {
                secondChest = ModEvents.createSecondChest(chest);
            }
            if (secondChest != null) {
                if (ModEvents.tryAddItemToChest(secondChest, item)) continue;
                ModEvents.dropItem(chest, item);
                continue;
            }
            ModEvents.dropItem(chest, item);
        }
    }

    private static boolean tryAddItemToChest(ChestBlockEntity chest, ItemStack item) {
        if (item.isEmpty()) {
            return true;
        }
        for (int i = 0; i < chest.getContainerSize(); ++i) {
            ItemStack slotItem = chest.getItem(i);
            if (slotItem.isEmpty()) {
                chest.setItem(i, item);
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotItem, (ItemStack)item) || slotItem.getCount() >= slotItem.getMaxStackSize()) continue;
            int canAdd = Math.min(item.getCount(), slotItem.getMaxStackSize() - slotItem.getCount());
            slotItem.grow(canAdd);
            item.shrink(canAdd);
            if (!item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static ChestBlockEntity createSecondChest(ChestBlockEntity firstChest) {
        BlockPos[] possiblePositions;
        Level level = firstChest.getLevel();
        if (level == null) {
            return null;
        }
        BlockPos originalPos = firstChest.getBlockPos();
        for (BlockPos newPos : possiblePositions = new BlockPos[]{originalPos.east(), originalPos.west(), originalPos.north(), originalPos.south()}) {
            if (!level.getBlockState(newPos).isAir() && !level.getBlockState(newPos).canBeReplaced()) continue;
            level.setBlock(newPos, Blocks.CHEST.defaultBlockState(), 3);
            BlockEntity blockEntity = level.getBlockEntity(newPos);
            if (!(blockEntity instanceof ChestBlockEntity)) continue;
            ChestBlockEntity secondChest = (ChestBlockEntity)blockEntity;
            return secondChest;
        }
        return null;
    }

    private static void dropItem(ChestBlockEntity chest, ItemStack item) {
        Level level = chest.getLevel();
        if (level != null && !item.isEmpty()) {
            BlockPos pos = chest.getBlockPos();
            ItemEntity droppedItem = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, item);
            level.addFreshEntity((Entity)droppedItem);
        }
    }
}

