/*
 * Decompiled with CFR 0.152.
 */
package com.spunkyinsaan.armourdurability.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("armour_durability.json");
    public int hudX = 10;
    public int hudY = 10;
    public float hudScale = 1.0f;
    public boolean showHelmet = true;
    public boolean showChestplate = true;
    public boolean showLeggings = true;
    public boolean showBoots = true;
    public boolean showElytra = true;
    public boolean showTurtleShell = true;
    public boolean horizontalLayout = false;
    public int itemSpacing = 2;

    public static ModConfig load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                return (ModConfig)GSON.fromJson(json, ModConfig.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load config, using defaults: " + e.getMessage());
            }
        }
        return new ModConfig();
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public void validateAndFix() {
        this.hudScale = Math.max(0.1f, Math.min(3.0f, this.hudScale));
        this.hudX = Math.max(0, this.hudX);
        this.hudY = Math.max(0, this.hudY);
        this.itemSpacing = Math.max(0, Math.min(20, this.itemSpacing));
    }
}

