/*
 * Decompiled with CFR 0.152.
 */
package com.spunkyinsaan.armourdurability.hud;

import com.spunkyinsaan.armourdurability.ArmourDurabilityClient;
import com.spunkyinsaan.armourdurability.config.ModConfig;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class ArmorHudRenderer {
    private static final int ICON_SIZE = 16;
    private static final int TEXT_HEIGHT = 9;

    public void render(class_332 drawContext, class_1657 player) {
        ModConfig config = ArmourDurabilityClient.getConfig();
        class_310 client = class_310.method_1551();
        if (player == null) {
            System.out.println("ArmourDurability: Player is null");
            return;
        }
        if (client.field_1755 != null) {
            System.out.println("ArmourDurability: Screen is open, but still rendering HUD");
        }
        List<ArmorItem> armorItems = this.getArmorItems(player, config);
        System.out.println("ArmourDurability: Rendering HUD at position (" + config.hudX + ", " + config.hudY + ")");
        this.renderArmorItems(drawContext, armorItems, config.hudX, config.hudY, config);
    }

    private List<ArmorItem> getArmorItems(class_1657 player, ModConfig config) {
        class_1799 boots;
        class_1799 leggings;
        class_1799 chest;
        class_1799 helmet;
        ArrayList<ArmorItem> items = new ArrayList<ArmorItem>();
        if (config.showHelmet && !(helmet = player.method_6118(class_1304.field_6169)).method_7960()) {
            items.add(new ArmorItem(helmet, class_1304.field_6169));
        }
        if (!(chest = player.method_6118(class_1304.field_6174)).method_7960()) {
            if (chest.method_31574(class_1802.field_8833) && config.showElytra) {
                items.add(new ArmorItem(chest, class_1304.field_6174));
            } else if (!chest.method_31574(class_1802.field_8833) && config.showChestplate) {
                items.add(new ArmorItem(chest, class_1304.field_6174));
            }
        }
        if (config.showLeggings && !(leggings = player.method_6118(class_1304.field_6172)).method_7960()) {
            items.add(new ArmorItem(leggings, class_1304.field_6172));
        }
        if (config.showBoots && !(boots = player.method_6118(class_1304.field_6166)).method_7960()) {
            items.add(new ArmorItem(boots, class_1304.field_6166));
        }
        return items;
    }

    private void renderArmorItems(class_332 drawContext, List<ArmorItem> items, int x, int y, ModConfig config) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int scaledX = x;
        int scaledY = y;
        for (int i = 0; i < items.size(); ++i) {
            ArmorItem armorItem = items.get(i);
            int itemX = scaledX;
            int itemY = scaledY;
            int scaledIconSize = (int)(16.0f * config.hudScale);
            int scaledSpacing = (int)((float)config.itemSpacing * config.hudScale);
            int scaledTextGap = (int)(4.0f * config.hudScale);
            if (config.horizontalLayout) {
                itemX += i * (scaledIconSize + 35 + scaledSpacing);
            } else {
                itemY += i * (scaledIconSize + scaledSpacing);
            }
            drawContext.method_51427(armorItem.stack, itemX, itemY);
            int durabilityPercentage = 100;
            if (armorItem.stack.method_7963()) {
                int maxDamage = armorItem.stack.method_7936();
                int currentDamage = armorItem.stack.method_7919();
                if (maxDamage > 0) {
                    durabilityPercentage = (int)Math.round((double)(maxDamage - currentDamage) / (double)maxDamage * 100.0);
                }
            }
            int color = this.getDurabilityColor(durabilityPercentage) | 0xFF000000;
            String text = durabilityPercentage + "%";
            int textX = itemX + 16 + scaledTextGap;
            int textY = itemY + 3;
            System.out.println("ArmourDurability: Rendering " + armorItem.stack.method_7909().method_63680().getString() + " at (" + textX + ", " + textY + ") with text: " + text + " color: " + Integer.toHexString(color));
            drawContext.method_25303(textRenderer, text, textX, textY, color);
            if ((color & 0xFFFFFF) != 0) continue;
            drawContext.method_51433(textRenderer, text, textX, textY, -1, false);
        }
    }

    private int getDurabilityColor(int percentage) {
        if ((percentage = class_3532.method_15340((int)percentage, (int)0, (int)100)) <= 20) {
            return 0xFF5555;
        }
        if (percentage <= 50) {
            float factor = (float)(percentage - 20) / 30.0f;
            return this.interpolateColor(0xFF5555, 0xFFFF55, factor);
        }
        float factor = (float)(percentage - 50) / 50.0f;
        return this.interpolateColor(0xFFFF55, 0x55FF55, factor);
    }

    private int interpolateColor(int color1, int color2, float factor) {
        factor = class_3532.method_15363((float)factor, (float)0.0f, (float)1.0f);
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * factor);
        int g = (int)((float)g1 + (float)(g2 - g1) * factor);
        int b = (int)((float)b1 + (float)(b2 - b1) * factor);
        return r << 16 | g << 8 | b;
    }

    @Environment(value=EnvType.CLIENT)
    private static class ArmorItem {
        public final class_1799 stack;
        public final class_1304 slot;

        public ArmorItem(class_1799 stack, class_1304 slot) {
            this.stack = stack;
            this.slot = slot;
        }
    }
}

