/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger((String)"JarJar");
    public static final int maxThreads;

    public static void ensureLoaded() {
    }

    static {
        Properties config = new Properties();
        File configLocation = new File(Launch.minecraftHome, "config/jarjar.properties");
        try (BufferedReader r = new BufferedReader(new FileReader(configLocation));){
            config.load(r);
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("No existing configuration file. Will use defaults");
        }
        catch (IOException e) {
            LOGGER.error("Error reading configuration file. Will use defaults", (Throwable)e);
        }
        int threads = Integer.parseInt(config.getProperty("maxThreads", "-1"));
        maxThreads = threads > 0 ? threads : Runtime.getRuntime().availableProcessors();
        try (BufferedWriter r = new BufferedWriter(new FileWriter(configLocation));){
            config.store(r, "Configuration file for early hodgepodge class transformers");
        }
        catch (IOException e) {
            LOGGER.error("Error reading configuration file. Will use defaults", (Throwable)e);
        }
    }
}

