/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.discovery;

import com.gtnewhorizons.retrofuturabootstrap.versioning.ArtifactVersion;
import com.mitchej123.jarjar.discovery.SortableCandidate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModCandidateV2Sorter<T extends SortableCandidate> {
    private static final Logger LOGGER = LogManager.getLogger((String)"ModCandidateV2Sorter");
    protected final List<T> candidates = new ArrayList<T>();
    protected final Set<T> disabled = Collections.newSetFromMap(new IdentityHashMap());
    protected boolean criticalIssuesFound = false;

    public Set<String> getDisabledFiles() {
        return this.disabled.stream().map(t -> t.getFile().getName()).collect(Collectors.toSet());
    }

    public ModCandidateV2Sorter(Collection<T> candidates, Comparator<T> comparator) {
        this.candidates.addAll(candidates);
        if (comparator != null) {
            this.candidates.sort(comparator);
        }
    }

    public Optional<List<T>> resolve() {
        this.handleDuplicates();
        return this.criticalIssuesFound ? Optional.empty() : Optional.of(this.candidates);
    }

    private void handleDuplicates() {
        HashMap<String, List> idLookup = new HashMap<String, List>(this.candidates.size());
        for (SortableCandidate sortableCandidate : this.candidates) {
            idLookup.computeIfAbsent(sortableCandidate.getId(), _id -> new ArrayList(1)).add(sortableCandidate);
        }
        for (Map.Entry entry : idLookup.entrySet()) {
            List equalIdCandidates = (List)entry.getValue();
            if (equalIdCandidates.size() < 2) continue;
            SortableCandidate newest = null;
            for (SortableCandidate it : equalIdCandidates) {
                if (this.disabled.contains(it)) continue;
                if (newest == null) {
                    newest = it;
                    continue;
                }
                if (newest.getVersion().compareTo((ArtifactVersion)it.getVersion()) < 0) {
                    this.disabled.add(newest);
                    LOGGER.warn("Duplicate mod found: {}, disabling {} ({}) in favor of {} ({})", new Object[]{newest.getId(), newest.getVersion(), newest.getFile(), it.getVersion(), it.getFile()});
                    newest = it;
                    continue;
                }
                LOGGER.warn("Duplicate mod found: {}, disabling {} ({}) in favor of {} ({})", new Object[]{it.getId(), it.getVersion(), it.getFile(), newest.getVersion(), newest.getFile()});
                this.disabled.add(it);
            }
        }
        this.candidates.removeIf(this.disabled::contains);
    }
}

