/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.discovery;

import com.mitchej123.jarjar.fml.common.LoaderUtil;
import com.mitchej123.jarjar.fml.common.ModContainerFactoryV2;
import com.mitchej123.jarjar.fml.common.ModContainerWrapper;
import com.mitchej123.jarjar.fml.common.discovery.ModCandidateV2;
import com.mitchej123.jarjar.fml.common.discovery.asm.ASMModParserV2;
import com.mitchej123.jarjar.fml.common.discovery.finder.ClasspathModCandidateFinder;
import com.mitchej123.jarjar.fml.common.discovery.finder.DirectoryModCandidateFinder;
import com.mitchej123.jarjar.fml.common.discovery.finder.ModCandidateFinder;
import com.mitchej123.jarjar.util.JarUtil;
import com.mitchej123.jarjar.util.RewindableModInputStream;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModContainerFactory;
import cpw.mods.fml.common.discovery.ModDiscoverer;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.ModListHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParallellModDiscoverer
extends ModDiscoverer {
    private static final Logger LOGGER = LogManager.getLogger((String)"ParallellModDiscoverer");
    public static final String JARJAR_DEBUG_DISCOVERY_TIMEOUT = "jarjar.debug.discoveryTimeout";
    public static final String FORCE_LOAD_AS_MOD = "ForceLoadAsMod";
    private final List<ModCandidateV2> modCandidates = new ArrayList<ModCandidateV2>();
    private final List<ModCandidateFinder> candidateFinders = new ArrayList<ModCandidateFinder>();
    private final Map<String, ModScanTask> jijDedupMap = new ConcurrentHashMap<String, ModScanTask>();
    private final List<NestedModInitData> nestedModInitDatas = Collections.synchronizedList(new ArrayList());
    private final File mcDir;

    public List<ModCandidateV2> getModCandidates() {
        return this.modCandidates;
    }

    public ParallellModDiscoverer(File modsDir, ModClassLoader modClassLoader) {
        this.mcDir = modsDir;
        this.candidateFinders.add(new ClasspathModCandidateFinder(modClassLoader));
        this.candidateFinders.add(new DirectoryModCandidateFinder(modsDir.toPath(), ModListHelper.additionalMods.values().toArray(new File[0]), true));
        File versionSpecificModsDir = new File(modsDir, FMLInjectionData.mccversion);
        if (versionSpecificModsDir.isDirectory()) {
            FMLLog.info((String)"Also searching %s for mods", (Object[])new Object[]{versionSpecificModsDir});
            this.candidateFinders.add(new DirectoryModCandidateFinder(versionSpecificModsDir.toPath(), true));
        }
    }

    public final void discoverMods() {
        ModCandidateV2 mod;
        LOGGER.info(String.format("Mod discovery started in %s", this.mcDir));
        long startTime = System.nanoTime();
        ForkJoinPool pool = new ForkJoinPool();
        HashSet processedPaths = new HashSet();
        ArrayList futures = new ArrayList();
        ModCandidateFinder.ModCandidateConsumer taskSubmitter = (paths, requiresRemap, isMinecraft, isClasspath) -> {
            ArrayList<Path> pendingPaths = new ArrayList<Path>(paths.size());
            for (Path path : paths) {
                assert (path.equals(LoaderUtil.normalizeExistingPath(path)));
                if (!processedPaths.add(path)) continue;
                pendingPaths.add(path);
            }
            if (!pendingPaths.isEmpty()) {
                futures.add(pool.submit(new ModScanTask(pendingPaths, requiresRemap, isMinecraft, isClasspath)));
            }
        };
        for (ModCandidateFinder finder : this.candidateFinders) {
            finder.findCandidates(taskSubmitter);
        }
        ArrayList<ModCandidateV2> candidates = new ArrayList<ModCandidateV2>();
        RuntimeException exception = null;
        int timeout = Integer.getInteger(JARJAR_DEBUG_DISCOVERY_TIMEOUT, -1);
        if (timeout <= 0) {
            timeout = Integer.MAX_VALUE;
        }
        try {
            pool.shutdown();
            pool.awaitTermination(timeout, TimeUnit.SECONDS);
            for (Future future : futures) {
                if (!future.isDone()) {
                    throw new TimeoutException();
                }
                try {
                    ModCandidateV2 candidate2 = (ModCandidateV2)future.get();
                    if (candidate2 == null) continue;
                    candidates.add(candidate2);
                }
                catch (ExecutionException e) {
                    exception = new RuntimeException("Mod discovery failed!", e);
                }
            }
            for (NestedModInitData data : this.nestedModInitDatas) {
                for (Future<ModCandidateV2> future : data.futures) {
                    if (!future.isDone()) {
                        throw new TimeoutException();
                    }
                    try {
                        ModCandidateV2 candidate3 = future.get();
                        if (candidate3 == null) continue;
                        data.target.add(candidate3);
                    }
                    catch (ExecutionException e) {
                        exception = new RuntimeException("Mod discovery failed!", e);
                    }
                }
            }
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            throw new RuntimeException(String.format("Mod discovery took too long! Analyzing the mod folder contents took longer than %d seconds. This may be caused by unusually slow hardware, pathological antivirus interference or other issues. The timeout can be changed with the system property %s (-D%<s=<desired timeout in seconds>).", timeout, JARJAR_DEBUG_DISCOVERY_TIMEOUT));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Mod discovery interrupted!", e);
        }
        if (exception != null) {
            throw exception;
        }
        Set ret = Collections.newSetFromMap(new IdentityHashMap(candidates.size() * 2));
        ArrayDeque<ModCandidateV2> queue = new ArrayDeque<ModCandidateV2>(candidates);
        while ((mod = (ModCandidateV2)queue.poll()) != null) {
            if (!ret.add(mod) || mod.getNestedModcandidates() == null) continue;
            for (ModCandidateV2 child : mod.getNestedModcandidates()) {
                if (!child.addParent(mod)) continue;
                queue.add(child);
            }
        }
        long l = System.nanoTime();
        LOGGER.info(String.format("Mod discovery time: %.1f ms", (double)(l - startTime) * 1.0E-6));
        this.modCandidates.addAll(ret);
        this.modCandidates.sort(Comparator.comparing(candidate -> candidate.getModContainer().getName()));
    }

    private static class NestedModInitData {
        final List<? extends Future<ModCandidateV2>> futures;
        final List<ModCandidateV2> target;

        NestedModInitData(List<? extends Future<ModCandidateV2>> futures, List<ModCandidateV2> target) {
            this.futures = futures;
            this.target = target;
        }
    }

    final class ModScanTask
    extends RecursiveTask<ModCandidateV2> {
        private final List<Path> paths;
        private final String localPath;
        private final RewindableModInputStream is;
        private final String hash;
        private final boolean requiresRemap;
        private final List<String> parentPaths;
        private final boolean isMinecraft;
        private final boolean isClasspath;

        ModScanTask(List<Path> paths, boolean requiresRemap) {
            this(paths, null, null, null, requiresRemap, Collections.emptyList(), false, false);
        }

        ModScanTask(List<Path> paths, boolean requiresRemap, boolean isMinecraft, boolean isClasspath) {
            this(paths, null, null, null, requiresRemap, Collections.emptyList(), isMinecraft, isClasspath);
        }

        private ModScanTask(List<Path> paths, String localPath, RewindableModInputStream is, String hash, boolean requiresRemap, List<String> parentPaths, boolean isMinecraft, boolean isClasspath) {
            this.paths = paths;
            this.localPath = localPath != null ? localPath : paths.get(0).toString();
            this.is = is;
            this.hash = hash;
            this.requiresRemap = requiresRemap;
            this.parentPaths = parentPaths;
            this.isMinecraft = isMinecraft;
            this.isClasspath = isClasspath;
        }

        @Override
        protected ModCandidateV2 compute() {
            try {
                Iterator<Path> iterator = this.paths.iterator();
                if (iterator.hasNext()) {
                    Path path = iterator.next();
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        return null;
                    }
                    return this.computeJarFile(path);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(String.format("Error analyzing %s: %s", this.paths, t), t);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ModCandidateV2 computeJarFile(Path path) throws IOException {
            File modFile = path.toFile();
            String modFileName = modFile.getName();
            FMLRelaunchLog.fine((String)"Examining for mod candidacy %s", (Object[])new Object[]{modFileName});
            try (JarFile jar = new JarFile(modFile);){
                Attributes attributes = jar.getManifest() != null ? jar.getManifest().getMainAttributes() : new Attributes();
                ModCandidateV2 modCandidate = JarUtil.examineJarCandidate(jar, modFile, null, false, this.isMinecraft, this.isClasspath);
                if (modCandidate == null) {
                    ModCandidateV2 modCandidateV2 = null;
                    return modCandidateV2;
                }
                if (modCandidate.hasTweaker() && !"true".equalsIgnoreCase(attributes.getValue(ParallellModDiscoverer.FORCE_LOAD_AS_MOD))) {
                    ModCandidateV2 modCandidateV2 = modCandidate;
                    return modCandidateV2;
                }
                if (!modCandidate.hasNestedJars()) {
                    modCandidate.setNestedModcandidates(Collections.emptyList());
                } else {
                    ArrayList<ModScanTask> tasks = new ArrayList<ModScanTask>(5);
                    ForkJoinTask localTask = null;
                    for (JarUtil.NestedJar nestedJar : modCandidate.getNestedJars()) {
                        ModScanTask task = (ModScanTask)ParallellModDiscoverer.this.jijDedupMap.get(nestedJar.hash());
                        if (task == null) {
                            task = new ModScanTask(Collections.singletonList(nestedJar.file().toPath()), true);
                            ModScanTask prev = ParallellModDiscoverer.this.jijDedupMap.putIfAbsent(nestedJar.hash(), task);
                            if (prev != null) {
                                task = prev;
                            } else if (localTask == null) {
                                localTask = task;
                            } else {
                                task.fork();
                            }
                        }
                        tasks.add(task);
                    }
                    if (tasks.size() > 0) {
                        if (localTask != null) {
                            localTask.invoke();
                        }
                        ArrayList<ModCandidateV2> nestedMods = new ArrayList<ModCandidateV2>();
                        modCandidate.setNestedModcandidates(nestedMods);
                        ParallellModDiscoverer.this.nestedModInitDatas.add(new NestedModInitData(tasks, nestedMods));
                    }
                }
                Enumeration<JarEntry> entries = jar.entries();
                ModContainerFactoryV2 modContainerFactory = (ModContainerFactoryV2)ModContainerFactory.instance();
                ArrayList<ModContainerWrapper> wrappedModList = new ArrayList<ModContainerWrapper>();
                ArrayList<ModContainer> modList = new ArrayList<ModContainer>();
                List<ASMModParserV2> asmDataCollection = modCandidate.getAsmDataCollection();
                modCandidate.setWrappedMods(wrappedModList);
                modCandidate.setMods(modList);
                while (entries.hasMoreElements()) {
                    ASMModParserV2 asmData;
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (entry.isDirectory() || entryName.startsWith("__MACOSX") || !entryName.endsWith(".class") || entryName.endsWith("$.class")) continue;
                    try (InputStream classStream = jar.getInputStream(entry);){
                        asmData = new ASMModParserV2(classStream, entryName);
                    }
                    catch (LoaderException e) {
                        FMLRelaunchLog.log((Level)Level.ERROR, (Throwable)e, (String)"There was a problem reading the entry %s in the jar %s - probably a corrupt zip", (Object[])new Object[]{entryName, modFileName});
                        ModCandidateV2 modCandidateV2 = null;
                        jar.close();
                        return modCandidateV2;
                    }
                    asmData.validate();
                    asmDataCollection.add(asmData);
                    ModContainerWrapper wrapped = modContainerFactory.buildV2(asmData, modCandidate.getModContainer(), modCandidate);
                    if (wrapped == null) continue;
                    wrappedModList.add(wrapped);
                    modList.add(wrapped.mod());
                }
                return modCandidate;
            }
            catch (IOException ioe) {
                FMLRelaunchLog.log((Level)Level.ERROR, (Throwable)ioe, (String)"Unable to read the jar file %s - ignoring", (Object[])new Object[]{modFileName});
                return null;
            }
        }
    }
}

