/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.util;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.gtnewhorizons.retrofuturabootstrap.versioning.DefaultArtifactVersion;
import com.mitchej123.jarjar.fml.common.discovery.ModCandidateV2;
import com.mitchej123.jarjar.fml.relauncher.CoreModManagerV2;
import com.mitchej123.jarjar.util.JarByteSource;
import com.mitchej123.jarjar.util.RewindableModInputStream;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.discovery.ContainerType;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class JarUtil {
    public static final Logger logger = LogManager.getLogger((String)"NestedJarUtil");
    private static final String versionPattern = ".*-([0-9]+\\.[0-9]+\\.[0-9]+(?:-[a-zA-Z0-9]+)?(?:\\+[a-zA-Z0-9]+)?).*\\.jar";
    private static final Pattern pattern = Pattern.compile(".*-([0-9]+\\.[0-9]+\\.[0-9]+(?:-[a-zA-Z0-9]+)?(?:\\+[a-zA-Z0-9]+)?).*\\.jar");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static NestedJar getNestedJar(JarFile jar, String nestedJarPath, File targetDir) {
        File outputJarFile;
        String hash;
        JarEntry nestedEntry = jar.getJarEntry(nestedJarPath);
        if (nestedEntry == null) {
            FMLRelaunchLog.log((Level)Level.ERROR, (String)"Unable to find nested jar %s in %s - ignoring", (Object[])new Object[]{nestedJarPath, jar.getName()});
            return null;
        }
        String nestedJarFilename = FilenameUtils.getName((String)nestedJarPath);
        String nestedJarName = FilenameUtils.getBaseName((String)nestedJarPath);
        try (RewindableModInputStream is = new RewindableModInputStream(jar.getInputStream(nestedEntry));){
            hash = DigestUtils.sha256Hex((InputStream)is);
            Class<JarUtil> clazz = JarUtil.class;
            synchronized (JarUtil.class) {
                outputJarFile = new File(targetDir, nestedJarName + "-" + hash + ".jar");
                if (!outputJarFile.exists()) {
                    logger.info(String.format("Extracting nested jar %s from %s to %s", nestedJarPath, jar.getName(), outputJarFile));
                    is.rewind();
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputJarFile));){
                        int bytesRead;
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = is.read(buffer)) != -1) {
                            out.write(buffer, 0, bytesRead);
                        }
                    }
                }
                // ** MonitorExit[var9_9] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            logger.error(String.format("Unable to read the nested jar %s in %s - ignoring", nestedJarPath, jar.getName()));
            return null;
        }
        {
            return new NestedJar(outputJarFile, nestedJarFilename, hash);
        }
    }

    public static DefaultArtifactVersion guessVersion(MetadataCollection mc, String name) {
        Matcher matcher;
        if (mc != null) {
            if (mc.modList == null) {
                return new DefaultArtifactVersion("0.0.0");
            }
            for (ModMetadata meta : mc.modList) {
                DefaultArtifactVersion version = new DefaultArtifactVersion(meta.version);
                if (meta.version.equals(version.getQualifier())) continue;
                return version;
            }
        }
        if ((matcher = pattern.matcher(name)).matches()) {
            return new DefaultArtifactVersion(matcher.group(1));
        }
        return new DefaultArtifactVersion("0.0.0");
    }

    public static DefaultArtifactVersion guessVersion(ModMetadata md, String modid) {
        DefaultArtifactVersion version;
        if (md != null && !md.version.equals((version = new DefaultArtifactVersion(md.version)).getQualifier())) {
            return version;
        }
        return new DefaultArtifactVersion("0.0.0");
    }

    private static ModCandidateV2 examineModCandidate(NestedJar nestedJar, ModCandidateV2 parent, boolean coremodPass) {
        ModCandidateV2 candidate = JarUtil.examineModCandidate(nestedJar.file, parent, coremodPass);
        if (candidate != null) {
            candidate.setHash(nestedJar.hash);
            candidate.setSourceFilename(nestedJar.sourceFilename);
        }
        return candidate;
    }

    @Nullable
    public static ModCandidateV2 examineModCandidate(File modFile, ModCandidateV2 parent, boolean coremodPass) {
        return JarUtil.examineModCandidate(modFile, parent, coremodPass, false, false);
    }

    @Nullable
    public static ModCandidateV2 examineModCandidate(File modFile, ModCandidateV2 parent, boolean coremodPass, boolean isMinecraft, boolean isClasspath) {
        ModCandidateV2 modCandidateV2;
        JarFile jar = new JarFile(modFile);
        try {
            modCandidateV2 = JarUtil.examineJarCandidate(jar, modFile, parent, coremodPass, isMinecraft, isClasspath);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                FMLRelaunchLog.log((Level)Level.ERROR, (Throwable)ioe, (String)"Unable to read the jar file %s - ignoring", (Object[])new Object[]{modFile.getName()});
                return null;
            }
        }
        jar.close();
        return modCandidateV2;
    }

    @Nullable
    public static ModCandidateV2 examineJarCandidate(JarFile jar, File modFile, ModCandidateV2 parent, boolean coremodPass, boolean isMinecraft, boolean isClasspath) throws IOException {
        String modSide;
        ImmutableList modTypes;
        String cascadedTweaker;
        MetadataCollection meta;
        if (jar.getManifest() == null && coremodPass) {
            return null;
        }
        Attributes attributes = jar.getManifest() != null ? jar.getManifest().getMainAttributes() : new Attributes();
        ModCandidateV2 modCandidate = new ModCandidateV2(modFile, modFile, ContainerType.JAR, isMinecraft, isClasspath);
        modCandidate.addParent(parent);
        JarEntry modInfoEntry = jar.getJarEntry("mcmod.info");
        if (modInfoEntry != null) {
            FMLLog.finer((String)"Located mcmod.info file in file %s", (Object[])new Object[]{modFile});
            meta = MetadataCollection.from((InputStream)jar.getInputStream(modInfoEntry), (String)modFile.getName());
        } else {
            meta = MetadataCollection.from(null, (String)"");
        }
        modCandidate.setMetadataCollection(meta);
        DefaultArtifactVersion version = JarUtil.guessVersion(meta, modFile.getName());
        modCandidate.setVersion(version);
        if (coremodPass) {
            modCandidate.setNestedModcandidates(JarUtil.checkNestedMods(jar, modCandidate, coremodPass));
        } else {
            modCandidate.setNestedJars(JarUtil.checkNestedJars(jar));
        }
        String atList = attributes.getValue("FMLAT");
        if (atList != null && coremodPass) {
            HashMap<String, String> modAccessTransformers = new HashMap<String, String>();
            for (String at : atList.split(" ")) {
                JarEntry jarEntry = jar.getJarEntry("META-INF/" + at);
                if (jarEntry == null) continue;
                modAccessTransformers.put(String.format("%s!META-INF/%s", jar.getName(), at), new JarByteSource(jar, jarEntry).asCharSource(Charsets.UTF_8).read());
            }
            modCandidate.setAccessTransformers(modAccessTransformers);
        }
        if ((cascadedTweaker = attributes.getValue("TweakClass")) != null) {
            FMLRelaunchLog.info((String)"Identified tweaker %s from %s", (Object[])new Object[]{cascadedTweaker, modFile.getName()});
            int sortOrder = Optional.ofNullable(Ints.tryParse((String)Strings.nullToEmpty((String)attributes.getValue("TweakOrder")))).orElse(0);
            modCandidate.setTweaker(cascadedTweaker).setSortOrder(sortOrder);
        }
        Object object = modTypes = attributes.containsKey(CoreModManager.MODTYPE) ? Arrays.asList(attributes.getValue(CoreModManager.MODTYPE).split(",")) : ImmutableList.of((Object)"FML");
        if (!(modTypes.contains("FML") || modCandidate.hasTweaker() && coremodPass)) {
            FMLRelaunchLog.fine((String)"Adding %s to the list of things to skip. It is not an FML mod,  it has types %s", (Object[])new Object[]{modFile.getName(), modTypes});
            if (coremodPass) {
                CoreModManager.loadedCoremods.add(modFile.getName());
            }
            return null;
        }
        String string = modSide = attributes.containsKey(CoreModManager.MODSIDE) ? attributes.getValue(CoreModManager.MODSIDE) : "BOTH";
        if (!"BOTH".equals(modSide) && !FMLLaunchHandler.side.name().equals(modSide)) {
            FMLRelaunchLog.fine((String)"Mod %s has ModSide meta-inf value %s, and we're %s. It will be ignored", (Object[])new Object[]{modFile.getName(), modSide, FMLLaunchHandler.side.name()});
            if (coremodPass) {
                CoreModManager.loadedCoremods.add(modFile.getName());
            }
            return null;
        }
        String fmlCorePlugin = attributes.getValue("FMLCorePlugin");
        if (fmlCorePlugin != null) {
            modCandidate.setCoreMod(fmlCorePlugin).setContainsMod(attributes.containsKey(CoreModManager.COREMODCONTAINSFMLMOD) || "true".equalsIgnoreCase(attributes.getValue(CoreModManagerV2.FORCELOADASMOD)));
        } else if (coremodPass) {
            FMLRelaunchLog.fine((String)"Not found coremod data in %s", (Object[])new Object[]{modFile.getName()});
        }
        return modCandidate;
    }

    public static List<ModCandidateV2> checkNestedMods(JarFile jar, ModCandidateV2 parent, boolean coremodPass) throws IOException {
        List<NestedJar> nestedJars = JarUtil.checkNestedJars(jar);
        if (nestedJars.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModCandidateV2> nestedMods = new ArrayList<ModCandidateV2>();
        for (NestedJar nestedJar : nestedJars) {
            ModCandidateV2 nestedMod = JarUtil.examineModCandidate(nestedJar, parent, coremodPass);
            if (nestedMod == null) continue;
            nestedMod.setHash(nestedJar.hash);
            nestedMods.add(nestedMod);
        }
        return nestedMods;
    }

    public static List<NestedJar> checkNestedJars(JarFile jar) throws IOException {
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            return Collections.emptyList();
        }
        String nestedJarsEntry = manifest.getMainAttributes().getValue("Jar-In-Jar");
        if (nestedJarsEntry == null) {
            return Collections.emptyList();
        }
        ArrayList<NestedJar> nestedJars = new ArrayList<NestedJar>();
        HashSet<String> nestedJarPaths = new HashSet<String>(Arrays.asList(nestedJarsEntry.split(",")));
        for (String nestedJarPath : nestedJarPaths) {
            NestedJar nestedJar = JarUtil.getNestedJar(jar, nestedJarPath, CoreModManagerV2.getNestedDir());
            if (nestedJar == null) continue;
            nestedJars.add(nestedJar);
        }
        return nestedJars;
    }

    public static final class NestedJar {
        private final File file;
        private final String sourceFilename;
        private final String hash;

        public NestedJar(File file, String sourceFilename, String hash) {
            this.file = file;
            this.sourceFilename = sourceFilename;
            this.hash = hash;
        }

        public String toString() {
            return "NestedJar[" + "file=" + this.file + "," + "sourceFilename=" + this.sourceFilename + "," + "hash=" + this.hash + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (this.sourceFilename != null ? this.sourceFilename.hashCode() : 0);
            result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((NestedJar)arg0).file, this.file)) {
                return false;
            }
            if (!Objects.equals(((NestedJar)arg0).sourceFilename, this.sourceFilename)) {
                return false;
            }
            return Objects.equals(((NestedJar)arg0).hash, this.hash);
            {
            }
        }

        public File file() {
            return this.file;
        }

        public String sourceFilename() {
            return this.sourceFilename;
        }

        public String hash() {
            return this.hash;
        }
    }
}

