/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.fml.common.discovery;

import com.gtnewhorizons.retrofuturabootstrap.versioning.DefaultArtifactVersion;
import com.mitchej123.jarjar.discovery.SortableCandidate;
import com.mitchej123.jarjar.fml.common.ModContainerWrapper;
import com.mitchej123.jarjar.fml.common.discovery.asm.ASMModParserV2;
import com.mitchej123.jarjar.util.JarUtil;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ContainerType;
import cpw.mods.fml.common.discovery.ModCandidate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ModCandidateV2
extends ModCandidate
implements SortableCandidate {
    private Map<String, String> accessTransformers = null;
    private String cascadedTweaker = null;
    private String fmlCorePlugin = null;
    private boolean containsMod = false;
    private Collection<ModCandidateV2> nestedModcandidates = null;
    private Collection<ModCandidateV2> parentModcandidates;
    private int nestLevel = 0;
    private List<ModContainerWrapper> wrappedMods;
    private List<ASMModParserV2> asmDataCollection = new ArrayList<ASMModParserV2>();
    private List<JarUtil.NestedJar> nestedJars = null;
    private String hash = null;
    private String sourceFilename = null;
    private int sortOrder = 0;
    private MetadataCollection metadataCollection = null;
    private DefaultArtifactVersion version = new DefaultArtifactVersion("0.0.0");

    public ModCandidateV2(File classPathRoot, File modContainer, ContainerType sourceType) {
        super(classPathRoot, modContainer, sourceType);
    }

    public ModCandidateV2(File classPathRoot, File modContainer, ContainerType sourceType, boolean isMinecraft, boolean classpath) {
        super(classPathRoot, modContainer, sourceType, isMinecraft, classpath);
    }

    public boolean hasAccessTransformers() {
        return this.accessTransformers != null;
    }

    public Map<String, String> getAccessTransformers() {
        return this.accessTransformers;
    }

    public ModCandidateV2 setAccessTransformers(Map<String, String> modAccessTransformers) {
        this.accessTransformers = modAccessTransformers;
        return this;
    }

    public boolean hasTweaker() {
        return this.cascadedTweaker != null;
    }

    public ModCandidateV2 setTweaker(String cascadedTweaker) {
        this.cascadedTweaker = cascadedTweaker;
        return this;
    }

    public String getTweaker() {
        return this.cascadedTweaker;
    }

    public boolean hasCoreMod() {
        return this.fmlCorePlugin != null;
    }

    public String getCoreMod() {
        return this.fmlCorePlugin;
    }

    public ModCandidateV2 setCoreMod(String fmlCorePlugin) {
        this.fmlCorePlugin = fmlCorePlugin;
        return this;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public ModCandidateV2 setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public ModCandidateV2 setContainsMod(boolean containsMod) {
        this.containsMod = containsMod;
        return this;
    }

    public boolean containsMod() {
        return this.containsMod;
    }

    public boolean isNested() {
        return this.nestLevel > 0;
    }

    public void addClassEntry(String name) {
        super.addClassEntry(name);
    }

    public void setNestedModcandidates(List<ModCandidateV2> nestedModcandidates) {
        this.nestedModcandidates = nestedModcandidates;
    }

    public Collection<ModCandidateV2> getNestedModcandidates() {
        return this.nestedModcandidates;
    }

    public boolean hasNestedMods() {
        return this.nestedModcandidates != null && this.nestedModcandidates.size() > 0;
    }

    public boolean addParent(ModCandidateV2 parent) {
        if (this.parentModcandidates == null) {
            this.parentModcandidates = new ArrayList<ModCandidateV2>();
        }
        if (this.parentModcandidates.contains(parent)) {
            return false;
        }
        this.parentModcandidates.add(parent);
        this.updateNestLevel(parent);
        return true;
    }

    @Override
    public String getId() {
        if (this.fmlCorePlugin != null) {
            return this.fmlCorePlugin;
        }
        if (this.sourceFilename != null) {
            return this.sourceFilename;
        }
        return this.modContainer.getName();
    }

    public List<ASMModParserV2> getAsmDataCollection() {
        return this.asmDataCollection;
    }

    private void updateNestLevel(ModCandidateV2 parent) {
        if (parent != null && parent.nestLevel + 1 > this.nestLevel) {
            this.nestLevel = parent.nestLevel + 1;
        }
    }

    public int getNestLevel() {
        return this.nestLevel;
    }

    public boolean hasNestedJars() {
        return this.nestedJars != null && this.nestedJars.size() > 0;
    }

    public void setNestedJars(List<JarUtil.NestedJar> nestedJars) {
        this.nestedJars = nestedJars;
    }

    public List<JarUtil.NestedJar> getNestedJars() {
        return this.nestedJars;
    }

    public void setMetadataCollection(MetadataCollection metadataCollection) {
        this.metadataCollection = metadataCollection;
    }

    public MetadataCollection getMetadataCollection() {
        return this.metadataCollection;
    }

    public void setMods(List<ModContainer> modList) {
        this.mods = modList;
    }

    public void setWrappedMods(List<ModContainerWrapper> mods) {
        this.wrappedMods = mods;
    }

    public List<ModContainerWrapper> getWrappedMods() {
        if (this.wrappedMods == null) {
            return Collections.emptyList();
        }
        return this.wrappedMods;
    }

    public ModCandidateV2 setVersion(DefaultArtifactVersion version) {
        this.version = version;
        return this;
    }

    @Override
    public DefaultArtifactVersion getVersion() {
        return this.version;
    }

    @Override
    public File getFile() {
        return this.getModContainer();
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getFilename() {
        if (this.sourceFilename != null) {
            return this.sourceFilename;
        }
        return this.modContainer.getName();
    }

    public String getSourceFilename() {
        return this.sourceFilename;
    }

    public void setSourceFilename(String sourceFilename) {
        this.sourceFilename = sourceFilename;
    }

    public void setTable(ASMDataTable table) {
        this.table = table;
    }

    public void sendToTable(ASMDataTable table) {
        this.setTable(table);
        for (ASMModParserV2 asmData : this.asmDataCollection) {
            this.addClassEntry(asmData.getClassEntry());
            asmData.sendToTable(table, this);
        }
    }
}

