/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.fml.common.discovery.finder;

import com.google.common.collect.ImmutableList;
import com.mitchej123.jarjar.fml.common.DefaultLibraries;
import com.mitchej123.jarjar.fml.common.discovery.finder.ModCandidateFinder;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.relauncher.CoreModManager;
import java.io.File;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClasspathModCandidateFinder
implements ModCandidateFinder {
    public static final Logger LOGGER = LogManager.getLogger((String)"ClasspathModCandidateFinder");
    private final ModClassLoader modClassLoader;

    public ClasspathModCandidateFinder(ModClassLoader modClassLoader) {
        this.modClassLoader = modClassLoader;
    }

    @Override
    public void findCandidates(ModCandidateFinder.ModCandidateConsumer out) {
        LOGGER.info("Searching for classpath mods");
        ImmutableList knownLibraries = ImmutableList.builder().addAll((Iterable)this.modClassLoader.getDefaultLibraries()).addAll((Iterable)CoreModManager.getLoadedCoremods()).addAll((Iterable)CoreModManager.getReparseableCoremods()).build();
        File[] minecraftSources = this.modClassLoader.getParentSources();
        if (minecraftSources.length == 1 && minecraftSources[0].isFile()) {
            FMLLog.fine((String)"Minecraft is a file at %s, loading", (Object[])new Object[]{minecraftSources[0].getAbsolutePath()});
            out.accept(Collections.singletonList(minecraftSources[0].toPath()), true, true, true);
        } else {
            for (int i = 0; i < minecraftSources.length; ++i) {
                if (minecraftSources[i].isFile()) {
                    if (knownLibraries.contains(minecraftSources[i].getName()) || DefaultLibraries.isDefaultLibrary(minecraftSources[i])) {
                        FMLLog.finer((String)"Skipping known library file %s", (Object[])new Object[]{minecraftSources[i].getAbsolutePath()});
                        continue;
                    }
                    FMLLog.fine((String)"Found a minecraft related file at %s, examining for mod candidates", (Object[])new Object[]{minecraftSources[i].getAbsolutePath()});
                    out.accept(Collections.singletonList(minecraftSources[i].toPath()), true, i == 0, true);
                    continue;
                }
                if (!minecraftSources[i].isDirectory()) continue;
                FMLLog.fine((String)"Found a minecraft related directory at %s, ignoring", (Object[])new Object[]{minecraftSources[i].getAbsolutePath()});
            }
        }
    }
}

