/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.rfb.transformer;

import com.gtnewhorizon.gtnhlib.asm.ClassConstantPoolParser;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FMLTransformer
implements RfbClassTransformer {
    public static final String CORE_MOD_MANAGER = "cpw/mods/fml/relauncher/CoreModManager";
    public static final String CORE_MOD_MANAGER_V2 = "com/mitchej123/jarjar/fml/relauncher/CoreModManagerV2";
    public static final String CORE_MOD_MANAGER_CLASS_NAME = "cpw.mods.fml.relauncher.CoreModManager";
    public static final String METADATA_COLLECTION = "cpw/mods/fml/common/MetadataCollection";
    public static final String METADATA_COLLECTION_V2 = "com/mitchej123/jarjar/fml/common/MetadataCollectionV2";
    public static final String HANDLE_LAUNCH_METHOD = "handleLaunch";
    public static final String HANDLE_LAUNCH_DESC = "(Ljava/io/File;Lnet/minecraft/launchwrapper/LaunchClassLoader;Lcpw/mods/fml/common/launcher/FMLTweaker;)V";
    private static final String[] CLASS_CONSTANTS = new String[]{"cpw/mods/fml/relauncher/CoreModManager", "cpw/mods/fml/common/MetadataCollection"};
    private static final ClassConstantPoolParser cstPoolParser = new ClassConstantPoolParser(CLASS_CONSTANTS);

    @NotNull
    public String id() {
        return "jarjar-fmltransformer-v2";
    }

    public @NotNull String @Nullable [] sortBefore() {
        return new String[]{"*"};
    }

    public @NotNull String @Nullable [] additionalExclusions() {
        return new String[]{"com.mitchej123.jarjar.fml."};
    }

    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        return cstPoolParser.find(classNode.getOriginalBytes(), false);
    }

    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        @Nullable ClassNode cn = classNode.getNode();
        if (cn == null || cn.methods == null) {
            return;
        }
        boolean isCoreModManager = className.equals(CORE_MOD_MANAGER_CLASS_NAME);
        for (MethodNode mn : cn.methods) {
            if (isCoreModManager && HANDLE_LAUNCH_METHOD.equals(mn.name) && mn.desc.equals(HANDLE_LAUNCH_DESC)) {
                this.replaceHandleLaunchMethod(mn);
                continue;
            }
            if (mn.instructions == null || mn.instructions.size() == 0) continue;
            for (int i = 0; i < mn.instructions.size(); ++i) {
                AbstractInsnNode aInsn = mn.instructions.get(i);
                if (aInsn.getOpcode() != 184 || !(aInsn instanceof MethodInsnNode)) continue;
                MethodInsnNode mInsn = (MethodInsnNode)aInsn;
                if (mInsn.owner.equals(CORE_MOD_MANAGER)) {
                    mInsn.owner = CORE_MOD_MANAGER_V2;
                    continue;
                }
                if (!mInsn.owner.equals(METADATA_COLLECTION)) continue;
                mInsn.owner = METADATA_COLLECTION_V2;
            }
        }
    }

    private void replaceHandleLaunchMethod(@NotNull MethodNode mn) {
        mn.instructions.clear();
        mn.tryCatchBlocks.clear();
        mn.localVariables = null;
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, CORE_MOD_MANAGER_V2, HANDLE_LAUNCH_METHOD, mn.desc, false));
        newInstructions.add((AbstractInsnNode)new InsnNode(177));
        mn.instructions = newInstructions;
        mn.maxStack = 3;
        mn.maxLocals = 3;
    }
}

