/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.fml.common.discovery.asm;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.spongepowered.libraries.com.google.common.base.MoreObjects;

public class ASMModParserV2
extends ASMModParser {
    private final String classEntry;
    private Set<String> interfaces;

    public ASMModParserV2(InputStream stream, String classEntry) throws IOException {
        super(stream);
        this.classEntry = classEntry;
    }

    public String getClassEntry() {
        return this.classEntry;
    }

    public void beginNewTypeName(String typeQName, int classVersion, String superClassQName, String[] interfaces) {
        super.beginNewTypeName(typeQName, classVersion, superClassQName);
        if (this.interfaces == null) {
            this.interfaces = Sets.newHashSet();
        }
        Collections.addAll(this.interfaces, interfaces);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ASMAnnotationDiscoverer").add("className", (Object)this.getASMType().getClassName()).add("classVersion", this.getClassVersion()).add("superName", (Object)this.getASMSuperType().getClassName()).add("annotations", (Object)this.getAnnotations()).toString();
    }

    public void sendToTable(ASMDataTable table, ModCandidate candidate) {
        super.sendToTable(table, candidate);
        for (String intf : this.interfaces) {
            table.addASMData(candidate, intf, this.getASMType().getInternalName(), null, null);
        }
    }
}

