/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.fml.common.discovery.finder;

import com.mitchej123.jarjar.fml.common.LoaderUtil;
import com.mitchej123.jarjar.fml.common.discovery.finder.ModCandidateFinder;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FileListHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DirectoryModCandidateFinder
implements ModCandidateFinder {
    private static final Logger LOGGER = LogManager.getLogger((String)"DirectoryModCandidateFinder");
    private final Path pathToSearch;
    private final boolean requiresRemap;
    private final File[] additionalMods;
    private static Set<String> disabledFiles;

    public DirectoryModCandidateFinder(Path path, boolean requiresRemap) {
        this(path, new File[0], requiresRemap);
    }

    public DirectoryModCandidateFinder(Path path, File[] additionalMods, boolean requiresRemap) {
        this.pathToSearch = LoaderUtil.normalizePath(path);
        this.additionalMods = FileListHelper.sortFileList((File[])additionalMods);
        this.requiresRemap = requiresRemap;
    }

    @Override
    public void findCandidates(final ModCandidateFinder.ModCandidateConsumer out) {
        LOGGER.info("Searching for mods in {}", new Object[]{this.pathToSearch});
        if (!Files.exists(this.pathToSearch, new LinkOption[0])) {
            try {
                Files.createDirectory(this.pathToSearch, new FileAttribute[0]);
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create directory " + this.pathToSearch, e);
            }
        }
        if (!Files.isDirectory(this.pathToSearch, new LinkOption[0])) {
            throw new RuntimeException(this.pathToSearch + " is not a directory!");
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.pathToSearch);
        Path versionSpecificModsDir = this.pathToSearch.resolve(FMLInjectionData.mccversion);
        if (versionSpecificModsDir.toFile().isDirectory()) {
            FMLLog.info((String)"Also searching %s for mods", (Object[])new Object[]{versionSpecificModsDir});
            paths.add(versionSpecificModsDir);
        }
        try {
            for (Path path : paths) {
                Files.walkFileTree(path, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    @NotNull
                    public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attrs) {
                        if (DirectoryModCandidateFinder.isValidFile(file)) {
                            out.accept(file, DirectoryModCandidateFinder.this.requiresRemap);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            for (File additionalMod : this.additionalMods) {
                Path additionalModPath = LoaderUtil.normalizePath(additionalMod.toPath());
                if (!DirectoryModCandidateFinder.isValidFile(additionalModPath)) continue;
                out.accept(LoaderUtil.normalizePath(additionalMod.toPath()), this.requiresRemap);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while searching for mods in '" + this.pathToSearch + "'!", e);
        }
    }

    public static Set<String> getDisabledFiles() {
        if (disabledFiles == null) {
            disabledFiles = (Set)Launch.blackboard.get("jarjar.disabledFiles");
        }
        return disabledFiles;
    }

    static boolean isValidFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        try {
            if (Files.isHidden(path)) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        String fileName = path.getFileName().toString();
        return fileName.endsWith(".jar") && !fileName.startsWith(".") && !DirectoryModCandidateFinder.getDisabledFiles().contains(fileName);
    }
}

