/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.fml.relauncher;

import com.google.common.base.Throwables;
import com.google.common.collect.ObjectArrays;
import com.mitchej123.jarjar.discovery.ModCandidateV2Sorter;
import com.mitchej123.jarjar.fml.common.discovery.ModCandidateV2;
import com.mitchej123.jarjar.util.JarUtil;
import cpw.mods.fml.common.asm.transformers.ModAccessTransformer;
import cpw.mods.fml.common.discovery.ContainerType;
import cpw.mods.fml.common.launcher.FMLTweaker;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.FileListHelper;
import cpw.mods.fml.relauncher.ModListHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.launch.platform.MixinPlatformManager;
import org.spongepowered.asm.launch.platform.container.ContainerHandleURI;
import org.spongepowered.asm.launch.platform.container.IContainerHandle;

public final class CoreModManagerV2
extends CoreModManager {
    public static final String NESTED_DIR = "nestedmods";
    public static final Attributes.Name FORCELOADASMOD = new Attributes.Name("ForceLoadAsMod");
    public static final String DISABLED_FILES = "jarjar.disabledFiles";
    public static final Set<String> loadedByCommandLine = new HashSet<String>();
    public static final Comparator<ModCandidateV2> COREMOD_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(ModCandidateV2::getSortOrder).thenComparing(ModCandidateV2::getFilename).thenComparing(ModCandidateV2::getVersion).thenComparing(ModCandidateV2::getNestLevel));
    private static File modDir;
    private static File nestedDir;
    private static final List<ModCandidateV2> modCandidates;
    public static boolean mixinInit;
    private static final Set<String> loadedMixins;
    private static Field embedded;

    public static void handleLaunch(File mcDir, LaunchClassLoader classLoader, FMLTweaker tweaker) {
        CoreModManager.mcDir = mcDir;
        CoreModManager.tweaker = tweaker;
        modDir = CoreModManagerV2.setupCoreModDir((File)mcDir);
        nestedDir = CoreModManagerV2.setupNestedModDir(mcDir);
        try {
            if (classLoader.getClassBytes("net.minecraft.world.World") != null) {
                FMLRelaunchLog.info((String)"Managed to load a deobfuscated Minecraft name- we are in a deobfuscated environment. Skipping runtime deobfuscation", (Object[])new Object[0]);
                CoreModManager.deobfuscatedEnvironment = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!CoreModManager.deobfuscatedEnvironment) {
            FMLRelaunchLog.fine((String)"Enabling runtime deobfuscation", (Object[])new Object[0]);
        }
        CoreModManagerV2.loadForgeCoreMods(classLoader, tweaker);
        CoreModManagerV2.loadCommandLineCoremods(mcDir, classLoader);
        CoreModManagerV2.discoverCoreMods(mcDir, classLoader);
        CoreModManagerV2.loadTweakersAndCoreMods(mcDir, classLoader);
    }

    private static void loadForgeCoreMods(LaunchClassLoader classLoader, FMLTweaker tweaker) {
        Field field;
        tweaker.injectCascadingTweak("cpw.mods.fml.common.launcher.FMLInjectionAndSortingTweaker");
        try {
            classLoader.registerTransformer("cpw.mods.fml.common.asm.transformers.PatchingTransformer");
        }
        catch (Exception e) {
            FMLRelaunchLog.log((Level)Level.ERROR, (Throwable)e, (String)"The patch transformer failed to load! This is critical, loading cannot continue!", (Object[])new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
        try {
            field = CoreModManager.class.getDeclaredField("loadPlugins");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        CoreModManager.loadPlugins = new ArrayList();
        try {
            field = CoreModManagerV2.class.getSuperclass().getDeclaredField("rootPlugins");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        for (String rootPluginName : CoreModManager.rootPlugins) {
            CoreModManagerV2.loadCoreMod((LaunchClassLoader)classLoader, (String)rootPluginName, (File)new File(FMLTweaker.getJarLocation()));
        }
        if (CoreModManager.loadPlugins.isEmpty()) {
            throw new RuntimeException("A fatal error has occured - no valid fml load plugin was found - this is a completely corrupt FML installation.");
        }
        FMLRelaunchLog.fine((String)"All fundamental core mods are successfully located", (Object[])new Object[0]);
    }

    private static void loadCommandLineCoremods(File mcDir, LaunchClassLoader classLoader) {
        String commandLineCoremods = System.getProperty("fml.coreMods.load", "");
        for (String coreModClassName : commandLineCoremods.split(",")) {
            if (coreModClassName.isEmpty()) continue;
            FMLRelaunchLog.info((String)"Found a command line coremod : %s", (Object[])new Object[]{coreModClassName});
            CoreModManager.FMLPluginWrapper wrap = CoreModManagerV2.loadCoreMod((LaunchClassLoader)classLoader, (String)coreModClassName, null);
            if (wrap == null) continue;
            loadedByCommandLine.add(coreModClassName);
            URL coreModLocation = wrap.coreModInstance.getClass().getProtectionDomain().getCodeSource().getLocation();
            String jarPath = coreModLocation.getPath();
            if (!jarPath.endsWith(".jar")) continue;
            try (JarFile jar = new JarFile(jarPath);){
                File coreModFile = new File(jarPath);
                ModCandidateV2 modCandidate = new ModCandidateV2(coreModFile, coreModFile, ContainerType.JAR, false, true);
                JarUtil.checkNestedMods(jar, modCandidate, true);
            }
            catch (IOException e) {
                FMLRelaunchLog.log((Level)Level.ERROR, (Throwable)e, (String)"Unable to read the jar file %s - ignoring", (Object[])new Object[]{jarPath});
            }
        }
    }

    private static void checkDerps(File coreMods, File mcDir, LaunchClassLoader classLoader) {
        FileFilter derpdirfilter;
        File[] derpdirlist;
        FilenameFilter derpfilter = (dir, name) -> name.endsWith(".jar.zip");
        File[] derplist = coreMods.listFiles(derpfilter);
        if (derplist != null && derplist.length > 0) {
            FMLRelaunchLog.severe((String)"FML has detected several badly downloaded jar files,  which have been named as zip files. You probably need to download them again, or they may not work properly", (Object[])new Object[0]);
            for (File f : derplist) {
                FMLRelaunchLog.severe((String)"Problem file : %s", (Object[])new Object[]{f.getName()});
            }
        }
        if ((derpdirlist = coreMods.listFiles(derpdirfilter = pathname -> pathname.isDirectory() && new File(pathname, "META-INF").isDirectory())) != null && derpdirlist.length > 0) {
            FMLRelaunchLog.log((Level)Level.FATAL, (String)"There appear to be jars extracted into the mods directory. This is VERY BAD and will almost NEVER WORK WELL.\nYou should place original jars only in the mods directory. NEVER extract them to the mods directory.\nThe directories below appear to be extracted jar files. Fix this before you continue.", (Object[])new Object[0]);
            for (File f : derpdirlist) {
                FMLRelaunchLog.log((Level)Level.FATAL, (String)"Directory {} contains {}", (Object[])new Object[]{f.getName(), Arrays.asList(new File(f, "META-INF").list())});
            }
            RuntimeException re = new RuntimeException("Extracted mod jars found, loading will NOT continue");
            try {
                Class crashreportclass = classLoader.loadClass("b");
                Object crashreport = crashreportclass.getMethod("a", Throwable.class, String.class).invoke(null, re, "FML has discovered extracted jar files in the mods directory.\nThis breaks mod loading functionality completely.\nRemove the directories and replace with the jar files originally provided.");
                File crashreportfile = new File(new File(coreMods.getParentFile(), "crash-reports"), String.format("fml-crash-%1$tY-%1$tm-%1$td_%1$tT.txt", Calendar.getInstance()));
                crashreportclass.getMethod("a", File.class).invoke(crashreport, crashreportfile);
                System.out.println("#@!@# FML has crashed the game deliberately. Crash report saved to: #@!@# " + crashreportfile.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw re;
        }
    }

    private static File setupNestedModDir(File mcDir) {
        File nestedModDir = new File(mcDir, NESTED_DIR);
        try {
            nestedModDir = nestedModDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to canonicalize the nested jar dir at %s", mcDir.getName()), e);
        }
        if (!nestedModDir.exists()) {
            nestedModDir.mkdir();
        } else if (!nestedModDir.isDirectory()) {
            throw new RuntimeException(String.format("Found a nested jar file in %s that's not a directory", mcDir.getName()));
        }
        return nestedModDir;
    }

    public static void discoverCoreMods(File mcDir, LaunchClassLoader classLoader) {
        ModListHelper.parseModList((File)mcDir);
        FMLRelaunchLog.fine((String)"Discovering coremods", (Object[])new Object[0]);
        FilenameFilter ff = (dir, name) -> name.endsWith(".jar");
        CoreModManagerV2.checkDerps(modDir, mcDir, classLoader);
        Object[] coreModList = Objects.requireNonNull(modDir.listFiles(ff));
        File versionedModDir = new File(modDir, FMLInjectionData.mccversion);
        if (versionedModDir.isDirectory()) {
            Object[] versionedCoreMods = Objects.requireNonNull(versionedModDir.listFiles(ff));
            coreModList = (File[])ObjectArrays.concat((Object[])coreModList, (Object[])versionedCoreMods, File.class);
        }
        coreModList = (File[])ObjectArrays.concat((Object[])coreModList, (Object[])ModListHelper.additionalMods.values().toArray(new File[0]), File.class);
        FileListHelper.sortFileList((File[])coreModList);
        ArrayList<Object> modFilesToExample = new ArrayList<Object>(Arrays.asList(coreModList));
        for (File file : modFilesToExample) {
            FMLRelaunchLog.fine((String)"Examining for coremod candidacy %s", (Object[])new Object[]{file.getName()});
            ModCandidateV2 modCandidate = JarUtil.examineModCandidate(file, null, true);
            if (modCandidate == null) continue;
            if (modCandidate.hasCoreMod() && loadedByCommandLine.contains(modCandidate.getCoreMod())) {
                FMLRelaunchLog.info((String)"Skipping coremod previously loaded via command line %s", (Object[])new Object[]{modCandidate.getCoreMod()});
                continue;
            }
            modCandidates.add(modCandidate);
            if (!modCandidate.hasNestedMods()) continue;
            modCandidates.addAll(modCandidate.getNestedModcandidates());
        }
    }

    private static void loadTweakersAndCoreMods(File mcDir, LaunchClassLoader classLoader) {
        FMLRelaunchLog.fine((String)"Loading Tweakers and coremods", (Object[])new Object[0]);
        ModCandidateV2Sorter<ModCandidateV2> candidateSorter = new ModCandidateV2Sorter<ModCandidateV2>(modCandidates, COREMOD_COMPARATOR);
        Optional<List<ModCandidateV2>> resolvedCandidates = candidateSorter.resolve();
        Launch.blackboard.put(DISABLED_FILES, candidateSorter.getDisabledFiles());
        if (!resolvedCandidates.isPresent()) {
            FMLRelaunchLog.log((Level)Level.ERROR, (String)"There was a critical error during coremod resolution, check the log for details", (Object[])new Object[0]);
            return;
        }
        modCandidates.clear();
        modCandidates.addAll((Collection<ModCandidateV2>)resolvedCandidates.get());
        ArrayList<IContainerHandle> mixinHandlers = new ArrayList<IContainerHandle>();
        for (ModCandidateV2 candidate : modCandidates) {
            File modFile = candidate.getModContainer();
            FMLRelaunchLog.info((String)"Examining %s to load", (Object[])new Object[]{modFile.getName()});
            if (candidate.hasAccessTransformers()) {
                CoreModManagerV2.addModAccessTransformers(candidate.getAccessTransformers());
            }
            if (candidate.hasTweaker()) {
                IContainerHandle handler;
                FMLRelaunchLog.info((String)"Tweaker is %s", (Object[])new Object[]{candidate.getTweaker()});
                CoreModManagerV2.handleCascadingTweak(modFile, null, candidate.getTweaker(), classLoader, candidate.getSortOrder());
                if ("org.spongepowered.asm.launch.MixinTweaker".equals(candidate.getTweaker()) && (handler = (IContainerHandle)CoreModManagerV2.injectMixinAndTweaker(modFile, classLoader, mcDir, FMLInjectionData.mccversion)) != null) {
                    mixinHandlers.add(handler);
                }
                if (!candidate.containsMod()) {
                    loadedCoremods.add(modFile.getName());
                }
            }
            if (!candidate.hasCoreMod()) continue;
            FMLRelaunchLog.info((String)"Coremod is %s", (Object[])new Object[]{candidate.getCoreMod()});
            try {
                classLoader.addURL(modFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                FMLRelaunchLog.log((Level)Level.ERROR, (Throwable)e, (String)"Unable to convert file into a URL. weird", (Object[])new Object[0]);
            }
            if (!candidate.containsMod()) {
                FMLRelaunchLog.finer((String)"Adding %s to the list of known coremods, it will not be examined again", (Object[])new Object[]{modFile.getName()});
                loadedCoremods.add(modFile.getName());
            } else {
                FMLRelaunchLog.finer((String)"Found FMLCorePluginContainsFMLMod marker in %s, it will be examined later for regular @Mod instances", (Object[])new Object[]{modFile.getName()});
                reparsedCoremods.add(modFile.getName());
            }
            CoreModManagerV2.loadCoreMod((LaunchClassLoader)classLoader, (String)candidate.getCoreMod(), (File)modFile);
        }
        modCandidates.clear();
        if (!mixinHandlers.isEmpty()) {
            try {
                Field platformField = MixinBootstrap.class.getDeclaredField("platform");
                platformField.setAccessible(true);
                MixinPlatformManager platform = (MixinPlatformManager)platformField.get(null);
                for (IContainerHandle handler : mixinHandlers) {
                    platform.addContainer(handler);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Object injectMixinAndTweaker(File modFile, LaunchClassLoader classLoader, File mcDir, String mccversion) {
        if (!mixinInit) {
            mixinInit = true;
            FMLRelaunchLog.info((String)"Injecting Mixin Tweaker!", (Object[])new Object[0]);
            try {
                classLoader.addClassLoaderExclusion("org.spongepowered.asm.launch");
                Class<?> tweakerClass = Class.forName("org.spongepowered.asm.launch.MixinTweaker", true, (ClassLoader)classLoader);
                ITweaker tweaker = (ITweaker)tweakerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                tweaker.acceptOptions(new ArrayList(), mcDir, null, mccversion);
                tweaker.injectIntoClassLoader(classLoader);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            if (loadedMixins.add(modFile.getName())) {
                FMLRelaunchLog.info((String)"Injecting Mixin Config for %s", (Object[])new Object[]{modFile.getName()});
                try {
                    classLoader.addURL(modFile.toURI().toURL());
                    return new ContainerHandleURI(modFile.toURI());
                }
                catch (MalformedURLException e) {
                    FMLRelaunchLog.log((Level)Level.ERROR, (Throwable)e, (String)"Unable to convert file into a URL. weird", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            FMLRelaunchLog.log((Level)Level.ERROR, (Throwable)e, (String)"Unable to inject Mixin Config for %s", (Object[])new Object[]{modFile.getName()});
        }
        return null;
    }

    private static void addModAccessTransformers(Map<String, String> atMap) {
        if (embedded == null) {
            try {
                embedded = ModAccessTransformer.class.getDeclaredField("embedded");
                embedded.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Map map = (Map)embedded.get(null);
            map.putAll(atMap);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void handleCascadingTweak(File coreMod, JarFile jar, String cascadedTweaker, LaunchClassLoader classLoader, Integer sortingOrder) {
        try {
            if (ADDURL == null) {
                ADDURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                ADDURL.setAccessible(true);
            }
            ADDURL.invoke((Object)classLoader.getClass().getClassLoader(), coreMod.toURI().toURL());
            classLoader.addURL(coreMod.toURI().toURL());
            CoreModManager.tweaker.injectCascadingTweak(cascadedTweaker);
            tweakSorting.put(cascadedTweaker, sortingOrder);
        }
        catch (Exception e) {
            FMLRelaunchLog.log((Level)Level.INFO, (Throwable)e, (String)"There was a problem trying to load the mod dir tweaker %s", (Object[])new Object[]{coreMod.getAbsolutePath()});
        }
    }

    private static boolean isValidNestedJarEntry(ZipEntry entry) {
        return entry != null && !entry.isDirectory() && entry.getName().endsWith(".jar");
    }

    public static File getModDir() {
        return modDir;
    }

    public static File getNestedDir() {
        if (nestedDir == null) {
            nestedDir = CoreModManagerV2.setupNestedModDir(mcDir);
        }
        return nestedDir;
    }

    static {
        modCandidates = new ArrayList<ModCandidateV2>();
        mixinInit = false;
        loadedMixins = new HashSet<String>();
        embedded = null;
    }
}

