/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.rfb.transformer;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import java.util.Set;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

public class EarlyAccessTransformer
implements RfbClassTransformer {
    private static final Set<String> TARGET_CLASSES = ImmutableSet.of((Object)"cpw.mods.fml.relauncher.CoreModManager", (Object)"cpw.mods.fml.relauncher.CoreModManager.FMLPluginWrapper", (Object)"cpw.mods.fml.relauncher.CoreModManager$FMLPluginWrapper", (Object)"cpw.mods.fml.relauncher.ModListHelper", (Object)"cpw.mods.fml.relauncher.FMLInjectionData", (Object)"cpw.mods.fml.common.discovery.ModCandidate", (Object[])new String[]{"cpw.mods.fml.common.MetadataCollection"});

    @NotNull
    public String id() {
        return "jarjar-earlyaccesstransformer";
    }

    public @NotNull String @Nullable [] sortBefore() {
        return new String[]{"*"};
    }

    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        return TARGET_CLASSES.contains(className);
    }

    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        @Nullable ClassNode cn = classNode.getNode();
        if (cn == null || cn.fields == null) {
            return;
        }
        cn.access &= 0xFFFFFFF9;
        cn.access |= 1;
        for (FieldNode field : cn.fields) {
            field.access &= 0xFFFFFFF9;
            field.access |= 1;
        }
        if (cn.methods != null) {
            for (MethodNode method : cn.methods) {
                method.access &= 0xFFFFFFF9;
                method.access |= 1;
            }
        }
        if (cn.innerClasses != null) {
            for (InnerClassNode innerClass : cn.innerClasses) {
                if (!innerClass.name.endsWith("FMLPluginWrapper")) continue;
                innerClass.access &= 0xFFFFFFF9;
                innerClass.access |= 1;
            }
        }
    }
}

