/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.rfb.transformer;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class MetadataCollectionTransformer
implements RfbClassTransformer {
    private static final String TARGET_CLASS = "cpw.mods.fml.common.MetadataCollection";
    private static final String TARGET_FIELD = "modList";
    private static final String SERIALIZED_NAME_DESC = "Lcom/google/gson/annotations/SerializedName;";
    private static final Set<String> TARGET_CLASSES = ImmutableSet.of((Object)"cpw.mods.fml.common.MetadataCollection");

    @NotNull
    public String id() {
        return "jarjar-serializednametransformer";
    }

    public @NotNull String @Nullable [] sortBefore() {
        return new String[]{"*"};
    }

    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        return TARGET_CLASSES.contains(className);
    }

    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        @Nullable ClassNode cn = classNode.getNode();
        if (cn == null || cn.fields == null) {
            return;
        }
        for (FieldNode field : cn.fields) {
            if (!field.name.equals(TARGET_FIELD)) continue;
            boolean hasAnnotation = false;
            if (field.visibleAnnotations != null) {
                for (AnnotationNode annotation : field.visibleAnnotations) {
                    if (!annotation.desc.equals(SERIALIZED_NAME_DESC)) continue;
                    hasAnnotation = true;
                    break;
                }
            }
            if (hasAnnotation) break;
            AnnotationNode annotation = new AnnotationNode(SERIALIZED_NAME_DESC);
            annotation.values = new ArrayList();
            annotation.values.add("value");
            annotation.values.add(TARGET_FIELD);
            annotation.values.add("alternate");
            annotation.values.add(Arrays.asList("modlist", "ModList"));
            if (field.visibleAnnotations == null) {
                field.visibleAnnotations = new ArrayList();
            }
            field.visibleAnnotations.add(annotation);
            break;
        }
    }
}

