/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class RewindableModInputStream
extends InputStream {
    private final ByteBuffer buffer;
    private int pos;

    public RewindableModInputStream(InputStream parent) throws IOException {
        this.buffer = RewindableModInputStream.readMod(parent);
        assert (this.buffer.hasArray() && this.buffer.arrayOffset() == 0 && this.buffer.position() == 0);
    }

    public static ByteBuffer readMod(InputStream is) throws IOException {
        int len;
        int available = is.available();
        boolean availableGood = available > 1;
        byte[] buffer = new byte[availableGood ? available : 30000];
        int offset = 0;
        while ((len = is.read(buffer, offset, buffer.length - offset)) >= 0) {
            if ((offset += len) != buffer.length) continue;
            if (availableGood) {
                int val = is.read();
                if (val < 0) break;
                availableGood = false;
                buffer = Arrays.copyOf(buffer, Math.max(buffer.length * 2, 30000));
                buffer[offset++] = (byte)val;
                continue;
            }
            buffer = Arrays.copyOf(buffer, buffer.length * 2);
        }
        return ByteBuffer.wrap(buffer, 0, offset);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void rewind() {
        this.pos = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.buffer.limit()) {
            return -1;
        }
        return this.buffer.get(this.pos++) & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int rem = this.buffer.limit() - this.pos;
        if (rem <= 0) {
            return -1;
        }
        len = Math.min(len, rem);
        System.arraycopy(this.buffer.array(), this.pos, b, off, len);
        this.pos += len;
        return len;
    }
}

