/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.jarjar.fml.common;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mitchej123.jarjar.discovery.ModCandidateV2Sorter;
import com.mitchej123.jarjar.discovery.ParallellModDiscoverer;
import com.mitchej123.jarjar.discovery.SortableCandidate;
import com.mitchej123.jarjar.fml.common.APIOnlyWrapper;
import com.mitchej123.jarjar.fml.common.ModContainerWrapper;
import com.mitchej123.jarjar.fml.common.discovery.ModCandidateV2;
import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.InjectedModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ModDiscoverer;
import cpw.mods.fml.common.event.FMLLoadEvent;
import cpw.mods.fml.common.functions.ModIdFunction;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.net.MalformedURLException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class LoaderV2
extends Loader {
    private LoadController modController;
    public static final Comparator<@Nullable ModContainerWrapper> MOD_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(ModContainerWrapper::getId, String.CASE_INSENSITIVE_ORDER).thenComparing(ModContainerWrapper::getVersion).thenComparing(ModContainerWrapper::getNestLevel));

    public void loadMods() {
        this.progressBar = ProgressManager.push((String)"Loading", (int)7);
        this.progressBar.step("Constructing Mods");
        this.initializeLoader();
        this.mods = Lists.newArrayList();
        this.namedMods = Maps.newHashMap();
        this.modController = ((Loader)this).modController = new LoadController((Loader)this);
        this.modController.transition(LoaderState.LOADING, false);
        long startTime = System.nanoTime();
        this.discoverer = this.identifyMods();
        long endTime = System.nanoTime();
        FMLLog.fine((String)"Mod identification took %.2f seconds", (Object[])new Object[]{(double)(endTime - startTime) / 1.0E9});
        ModAPIManager.INSTANCE.manageAPI(this.modClassLoader, this.discoverer);
        this.disableRequestedMods();
        this.modController.distributeStateMessage(FMLLoadEvent.class);
        this.sortModList();
        ModAPIManager.INSTANCE.cleanupAPIContainers(this.modController.getActiveModList());
        ModAPIManager.INSTANCE.cleanupAPIContainers(this.mods);
        this.mods = ImmutableList.copyOf((Collection)this.mods);
        for (File nonMod : this.discoverer.getNonModLibs()) {
            if (!nonMod.isFile()) continue;
            FMLLog.info((String)"FML has found a non-mod file %s in your mods directory. It will now be injected into your classpath. This could severe stability issues, it should be removed if possible.", (Object[])new Object[]{nonMod.getName()});
            try {
                this.modClassLoader.addFile(nonMod);
            }
            catch (MalformedURLException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Encountered a weird problem with non-mod file injection : %s", (Object[])new Object[]{nonMod.getName()});
            }
        }
        this.modController.transition(LoaderState.CONSTRUCTING, false);
        this.modController.distributeStateMessage(LoaderState.CONSTRUCTING, new Object[]{this.modClassLoader, this.discoverer.getASMTable(), this.reverseDependencies});
        ArrayList modsCopy = Lists.newArrayList();
        modsCopy.addAll(this.getActiveModList());
        modsCopy.sort(Comparator.comparing(ModContainer::getModId));
        FMLLog.fine((String)"Mod signature data", (Object[])new Object[0]);
        FMLLog.fine((String)" \tValid Signatures:", (Object[])new Object[0]);
        for (ModContainer mod : this.getActiveModList()) {
            if (mod.getSigningCertificate() == null) continue;
            FMLLog.fine((String)"\t\t(%s) %s\t(%s\t%s)\t%s", (Object[])new Object[]{CertificateHelper.getFingerprint((Certificate)mod.getSigningCertificate()), mod.getModId(), mod.getName(), mod.getVersion(), mod.getSource().getName()});
        }
        FMLLog.fine((String)" \tMissing Signatures:", (Object[])new Object[0]);
        for (ModContainer mod : this.getActiveModList()) {
            if (mod.getSigningCertificate() != null) continue;
            FMLLog.fine((String)"\t\t%s\t(%s\t%s)\t%s", (Object[])new Object[]{mod.getModId(), mod.getName(), mod.getVersion(), mod.getSource().getName()});
        }
        if (this.getActiveModList().isEmpty()) {
            FMLLog.fine((String)"No user mod signature data found", (Object[])new Object[0]);
        }
        this.progressBar.step("Initializing mods Phase 1");
        this.modController.transition(LoaderState.PREINITIALIZATION, false);
    }

    public ModDiscoverer identifyMods() {
        this.mods.add(new InjectedModContainer((ModContainer)this.mcp, new File("minecraft.jar")));
        for (String cont : injectedContainers) {
            ModContainer mc;
            try {
                mc = (ModContainer)Class.forName(cont, true, (ClassLoader)this.modClassLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"A problem occurred instantiating the injected mod container %s", (Object[])new Object[]{cont});
                throw new LoaderException((Throwable)e);
            }
            this.mods.add(new InjectedModContainer(mc, mc.getSource()));
        }
        ParallellModDiscoverer discoverer = new ParallellModDiscoverer(this.canonicalModsDir, this.modClassLoader);
        discoverer.discoverMods();
        ASMDataTable dataTable = discoverer.getASMTable();
        List<ModCandidateV2> modCandidates = discoverer.getModCandidates();
        List nonModLibs = discoverer.getNonModLibs();
        modCandidates.sort(Comparator.comparing(ModCandidateV2::getId, String.CASE_INSENSITIVE_ORDER));
        ArrayList sortableCandidates = Lists.newArrayList();
        for (ModCandidateV2 candidate : modCandidates) {
            try {
                List<ModContainerWrapper> mods = candidate.getWrappedMods();
                if (mods.isEmpty() && !candidate.isClasspath() && !candidate.containsAPIAnnotations()) {
                    FMLLog.fine((String)"Adding %s to non-mod libs (no mods, no APIs)", (Object[])new Object[]{candidate.getFilename()});
                    nonModLibs.add(candidate.getModContainer());
                    continue;
                }
                if (mods.isEmpty() && candidate.containsAPIAnnotations()) {
                    FMLLog.info((String)"Including API-only jar %s in mod processing", (Object[])new Object[]{candidate.getFilename()});
                    sortableCandidates.add(new APIOnlyWrapper(candidate));
                    continue;
                }
                sortableCandidates.addAll(mods);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Optional resolvedCandidates = new ModCandidateV2Sorter(sortableCandidates, null).resolve();
        if (!resolvedCandidates.isPresent()) {
            FMLRelaunchLog.log((Level)Level.ERROR, (String)"There was a critical error during mod resolution, check the log for details", (Object[])new Object[0]);
            throw new RuntimeException("There was a critical error during mod resolution");
        }
        ReferenceOpenHashSet uniqueCandidates = new ReferenceOpenHashSet();
        for (SortableCandidate sortable : resolvedCandidates.get()) {
            if (sortable instanceof ModContainerWrapper) {
                ModContainerWrapper wrapper = (ModContainerWrapper)sortable;
                ModContainer mod = wrapper.mod();
                uniqueCandidates.add(wrapper.candidate());
                dataTable.addContainer(mod);
                this.mods.add(mod);
                continue;
            }
            if (!(sortable instanceof APIOnlyWrapper)) continue;
            APIOnlyWrapper apiWrapper = (APIOnlyWrapper)sortable;
            ModCandidateV2 candidate = apiWrapper.candidate();
            uniqueCandidates.add(candidate);
            try {
                this.modClassLoader.addFile(candidate.getModContainer());
            }
            catch (MalformedURLException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Failed to add API-only jar %s to classpath", (Object[])new Object[]{candidate.getFilename()});
            }
        }
        for (ModCandidateV2 candidate : uniqueCandidates) {
            candidate.sendToTable(dataTable);
        }
        this.identifyDuplicates(this.mods);
        this.namedMods = Maps.uniqueIndex((Iterable)this.mods, (Function)new ModIdFunction());
        FMLLog.info((String)"Forge Mod Loader has identified %d mod%s to load", (Object[])new Object[]{this.mods.size(), this.mods.size() != 1 ? "s" : ""});
        return discoverer;
    }
}

