/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.blocks;

import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.NamedEnum;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.data.EnderMonitorData;
import mcjty.rftoolspower.modules.endergenic.data.EnderMonitorMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EnderMonitorTileEntity
extends TickingTileEntity
implements TickOrderHandler.IOrderTicker {
    private final LogicSupport support = new LogicSupport();
    private boolean needpulse = false;
    @GuiValue
    public static final Value<EnderMonitorTileEntity, String> VALUE_MODE = Value.createEnum((String)"mode", (NamedEnum[])EnderMonitorMode.values(), EnderMonitorTileEntity::getMode, EnderMonitorTileEntity::setMode);
    @Cap(type=CapType.CONTAINER)
    private static final Function<EnderMonitorTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Ender Monitor").containerSupplier(DefaultContainerProvider.empty(EndergenicModule.CONTAINER_ENDER_MONITOR, (GenericTileEntity)be)).data(EndergenicModule.ENDER_MONITOR_DATA, EnderMonitorData.STREAM_CODEC, EnderMonitorData.CODEC).setupSync((GenericTileEntity)be);

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsbase:powergeneration/endergenic")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(EnderMonitorTileEntity::new));
    }

    public EnderMonitorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EndergenicModule.ENDER_MONITOR.be().get(), pos, state);
    }

    public EnderMonitorMode getMode() {
        return ((EnderMonitorData)this.getData(EndergenicModule.ENDER_MONITOR_DATA)).mode();
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public void setMode(EnderMonitorMode mode) {
        this.setData(EndergenicModule.ENDER_MONITOR_DATA, new EnderMonitorData(mode));
    }

    public void fireFromEndergenic(EnderMonitorMode mode) {
        EnderMonitorData data = (EnderMonitorData)this.getData(EndergenicModule.ENDER_MONITOR_DATA);
        if (data.mode() != mode) {
            return;
        }
        this.needpulse = true;
        this.markDirtyQuick();
    }

    protected void tickServer() {
        TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_2;
    }

    public void tickOnServer() {
        int newout = 0;
        if (this.needpulse) {
            this.markDirtyQuick();
            newout = 15;
            this.needpulse = false;
        }
        this.support.setRedstoneState((GenericTileEntity)this, newout);
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.support.setPowerOutput(tagCompound.getBoolean("rs") ? 15 : 0);
        this.needpulse = tagCompound.getBoolean("needPulse");
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider lookup) {
        super.saveAdditional(tagCompound, lookup);
        tagCompound.putBoolean("rs", this.support.getPowerOutput() > 0);
        tagCompound.putBoolean("needPulse", this.needpulse);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        EnderMonitorData data = (EnderMonitorData)input.get(EndergenicModule.ITEM_ENDER_MONITOR_DATA);
        if (data != null) {
            this.setData(EndergenicModule.ENDER_MONITOR_DATA, data);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        EnderMonitorData data = (EnderMonitorData)this.getData(EndergenicModule.ENDER_MONITOR_DATA);
        builder.set(EndergenicModule.ITEM_ENDER_MONITOR_DATA, (Object)data);
    }
}

