/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.fastrtp.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.util.Set;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import me.wesley1808.fastrtp.config.Config;
import me.wesley1808.fastrtp.config.ConfigHandler;
import me.wesley1808.fastrtp.util.CooldownManager;
import me.wesley1808.fastrtp.util.PositionLocator;
import me.wesley1808.fastrtp.util.RegistryUtil;
import me.wesley1808.fastrtp.util.Scheduler;
import me.wesley1808.fastrtp.util.Util;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class RandomTeleportCommand {
    private static final Object2ObjectOpenHashMap<UUID, Pair<class_3218, class_243>> RTP_COORDS = new Object2ObjectOpenHashMap();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rtp").requires(src -> !Config.instance().requirePermission || Permissions.check((class_2172)src, (String)"fast-rtp.command.root", (int)2))).executes(ctx -> RandomTeleportCommand.execute((class_2168)ctx.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"fast-rtp.command.reload", (int)2))).executes(ctx -> RandomTeleportCommand.reloadConfig((class_2168)ctx.getSource())))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(Permissions.require((String)"fast-rtp.command.advanced", (int)2))).executes(ctx -> RandomTeleportCommand.execute((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player")))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288()).executes(ctx -> RandomTeleportCommand.execute((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), class_2181.method_9289((CommandContext)ctx, (String)"world")))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> RandomTeleportCommand.execute((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), class_2181.method_9289((CommandContext)ctx, (String)"world"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius")))).then(class_2170.method_9244((String)"minRadius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> RandomTeleportCommand.execute((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), class_2181.method_9289((CommandContext)ctx, (String)"world"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minRadius"))))))));
        if (Config.instance().rtpBackEnabled) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rtpback").requires(Permissions.require((String)"fast-rtp.command.back", (boolean)true))).executes(ctx -> RandomTeleportCommand.executeBack(((class_2168)ctx.getSource()).method_9207())));
        }
    }

    private static int execute(class_2168 source) throws CommandSyntaxException {
        return RandomTeleportCommand.execute(source, source.method_9207());
    }

    private static int execute(class_2168 source, class_3222 player) {
        return RandomTeleportCommand.execute(source, player, Util.getLevel(player));
    }

    private static int execute(class_2168 source, class_3222 player, class_3218 level) {
        return RandomTeleportCommand.execute(source, player, level, Util.getRadius(level));
    }

    private static int execute(class_2168 source, class_3222 player, class_3218 level, int radius) {
        return RandomTeleportCommand.execute(source, player, level, radius, Config.instance().minRadius);
    }

    private static int execute(class_2168 source, class_3222 player, class_3218 level, int radius, int minRadius) {
        return RandomTeleportCommand.execute(source, player, level, radius, minRadius, source.method_44023() != player);
    }

    private static int execute(class_2168 source, class_3222 player, class_3218 level, int radius, int minRadius, boolean force) {
        String error;
        if (minRadius > radius) {
            source.method_9213((class_2561)class_2561.method_43470((String)"The minimum radius cannot be larger than the maximum radius!"));
            return 0;
        }
        if (PositionLocator.isLocating(player) || !Scheduler.canSchedule(player.method_5667())) {
            return 0;
        }
        Config.Messages messages = Config.instance().messages;
        if (!force && CooldownManager.hasCooldown(player.method_5667())) {
            String seconds = String.valueOf(CooldownManager.getCooldownInSeconds(player.method_5667()));
            player.method_7353(Util.format(messages.rtpOnCooldown.replace("${seconds}", seconds)), false);
            return 0;
        }
        String string = error = force ? null : Util.mayTeleport(player);
        if (error != null) {
            player.method_64398(Util.format(messages.preventedRtp.replace("${reason}", error)));
            return 0;
        }
        player.method_7353(Util.format(messages.rtpStartSearch), true);
        CooldownManager.addCooldown(player);
        long startTime = System.currentTimeMillis();
        PositionLocator locator = new PositionLocator(level, player.method_5667(), radius, minRadius);
        locator.findPosition(pos -> {
            if (pos == null) {
                player.method_64398(Util.format(messages.rtpLocNotFound));
                CooldownManager.removeCooldown(player.method_5667());
            } else {
                long elapsedTime = System.currentTimeMillis() - startTime;
                player.method_7353(Util.format(messages.rtpLocFound.replace("${seconds}", String.format("%.1f", Float.valueOf((float)elapsedTime / 1000.0f)))), true);
                if (force || !Config.instance().useStrictTeleportCheck) {
                    RandomTeleportCommand.teleportPlayer(player, level, pos);
                } else {
                    Scheduler.scheduleTeleport(player, () -> RandomTeleportCommand.teleportPlayer(player, level, pos), () -> {
                        CooldownManager.removeCooldown(player.method_5667());
                        player.method_7353(Util.format(messages.tpCancelled), false);
                    });
                }
            }
        });
        return 1;
    }

    private static void teleportPlayer(class_3222 player, class_3218 level, class_243 pos) {
        if (player.method_5805()) {
            player.method_48105(level, pos.field_1352, pos.field_1351, pos.field_1350, Set.of(), player.method_36454(), player.method_36455(), true);
            player.field_13987.method_14372();
            RTP_COORDS.put((Object)player.method_5667(), (Object)new ObjectObjectImmutablePair((Object)level, (Object)pos));
            player.method_64398(Util.format(Config.instance().messages.rtpTeleportPlayer.replace("${x}", String.format("%.0f", pos.field_1352)).replace("${y}", String.format("%.0f", pos.field_1351)).replace("${z}", String.format("%.0f", pos.field_1350)).replace("${world}", level.method_27983().method_29177().method_12832())));
        }
    }

    private static int executeBack(class_3222 player) {
        UUID uuid = player.method_5667();
        if (!Scheduler.canSchedule(uuid)) {
            return 0;
        }
        Config.Messages messages = Config.instance().messages;
        Pair pair = (Pair)RTP_COORDS.get((Object)uuid);
        if (pair == null) {
            player.method_64398(Util.format(messages.rtpBackLocNotFound));
            return 0;
        }
        String error = Util.mayTeleport(player);
        if (error != null) {
            player.method_64398(Util.format(messages.preventedRtpBack.replace("${reason}", error)));
            return 0;
        }
        class_243 pos = (class_243)pair.right();
        class_3218 level = (class_3218)pair.left();
        level.method_14178().method_66009(RegistryUtil.PRE_TELEPORT, new class_1923(class_2338.method_49638((class_2374)pos)), 1);
        Scheduler.scheduleTeleport(player, () -> {
            player.method_48105(level, pos.field_1352, pos.field_1351, pos.field_1350, Set.of(), player.method_36454(), player.method_36455(), true);
            player.field_13987.method_14372();
            player.method_64398(Util.format(messages.rtpBackSuccess));
        }, () -> player.method_7353(Util.format(messages.tpCancelled), false));
        return 1;
    }

    private static int reloadConfig(class_2168 source) {
        ConfigHandler.load();
        source.method_9226(() -> class_2561.method_43470((String)"Config reloaded!").method_27692(class_124.field_1060), false);
        return 1;
    }
}

