/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.fastrtp.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import me.wesley1808.fastrtp.FastRTP;
import me.wesley1808.fastrtp.config.Config;
import me.wesley1808.fastrtp.config.Json;
import net.fabricmc.loader.api.FabricLoader;

public final class ConfigHandler {
    private static final File DIR = FabricLoader.getInstance().getConfigDir().toFile();
    private static final File CONFIG = new File(DIR, "fast-rtp.json");

    public static void save() {
        if (!DIR.exists()) {
            DIR.mkdirs();
        }
        try (FileWriter writer = new FileWriter(CONFIG, StandardCharsets.UTF_8);){
            writer.write(Json.INSTANCE.toJson((Object)Config.instance));
        }
        catch (IOException e) {
            FastRTP.LOGGER.error("Failed to save config!", (Throwable)e);
        }
    }

    public static void load() {
        if (CONFIG.exists()) {
            try (FileReader reader = new FileReader(CONFIG, StandardCharsets.UTF_8);){
                Config.instance = (Config)Json.INSTANCE.fromJson((Reader)reader, Config.class);
            }
            catch (IOException e) {
                FastRTP.LOGGER.error("Failed to load config!", (Throwable)e);
            }
        } else {
            ConfigHandler.save();
        }
    }
}

