/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.fastrtp.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.UUID;
import java.util.function.Consumer;
import me.wesley1808.fastrtp.config.Config;
import me.wesley1808.fastrtp.util.RegistryUtil;
import me.wesley1808.fastrtp.util.Util;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public final class PositionLocator {
    private static final Object2ObjectOpenHashMap<UUID, PositionLocator> LOCATORS = new Object2ObjectOpenHashMap();
    private static final ObjectOpenHashSet<UUID> PENDING_REMOVAL = new ObjectOpenHashSet();
    private static final class_5819 RANDOM = class_5819.method_43053();
    private static final int MAX_SAFETY_CHECK_RADIUS = 4;
    private static final int MAX_ATTEMPTS = 256;
    private final class_3218 level;
    private final UUID uuid;
    private final int minRadius;
    private final int radius;
    private final int centerX;
    private final int centerZ;
    private Consumer<class_243> callback;
    private class_1923 queuedPos;
    private long stopTime;
    private int attempts;
    private int x;
    private int z;

    public static boolean isLocating(class_3222 player) {
        return LOCATORS.containsKey((Object)player.method_5667());
    }

    public static void update() {
        if (LOCATORS.size() > 0) {
            for (PositionLocator locator : LOCATORS.values()) {
                locator.tick();
            }
            for (UUID uuid : PENDING_REMOVAL) {
                LOCATORS.remove((Object)uuid);
            }
            PENDING_REMOVAL.clear();
        }
    }

    public PositionLocator(class_3218 level, UUID uuid, int radius, int minRadius) {
        this.level = level;
        this.uuid = uuid;
        this.radius = radius >> 4;
        this.minRadius = minRadius >> 4;
        class_2784 border = this.level.method_8621();
        this.centerX = (int)border.method_11964() >> 4;
        this.centerZ = (int)border.method_11980() >> 4;
    }

    private void tick() {
        if (System.currentTimeMillis() <= this.stopTime) {
            class_2818 chunk = Util.getChunkIfLoaded(this.level, this.queuedPos.field_9181, this.queuedPos.field_9180);
            if (chunk != null) {
                this.onChunkLoaded(chunk);
            }
        } else {
            this.onChunkLoaded(null);
        }
    }

    public void findPosition(Consumer<class_243> callback) {
        this.callback = callback;
        this.stopTime = System.currentTimeMillis() + 10000L;
        this.newPosition();
    }

    private void newPosition() {
        if (++this.attempts > 256 || System.currentTimeMillis() > this.stopTime) {
            this.callback.accept(null);
            return;
        }
        class_1923 pos = RANDOM.method_43056() ? new class_1923(this.nextRandomValueWithMinimum(this.centerX), this.nextRandomValue(this.centerZ)) : new class_1923(this.nextRandomValue(this.centerX), this.nextRandomValueWithMinimum(this.centerZ));
        this.x = pos.method_33940();
        this.z = pos.method_33942();
        if (this.isValid(pos)) {
            this.queueChunk(pos);
        } else {
            this.newPosition();
        }
    }

    private void queueChunk(class_1923 pos) {
        this.level.method_14178().method_66009(RegistryUtil.LOCATE, pos, 0);
        this.queuedPos = pos;
        PENDING_REMOVAL.remove((Object)this.uuid);
        LOCATORS.put((Object)this.uuid, (Object)this);
    }

    private void onChunkLoaded(class_2818 chunk) {
        PENDING_REMOVAL.add((Object)this.uuid);
        if (chunk == null) {
            this.callback.accept(null);
            return;
        }
        class_243 pos = this.findSafePositionInChunk(chunk, this.x, this.z);
        if (pos != null) {
            this.callback.accept(pos);
            return;
        }
        this.newPosition();
    }

    private class_243 findSafePositionInChunk(class_2818 chunk, int centerX, int centerZ) {
        int negativeDiff = 8 - class_3532.method_15340((int)Config.instance().safetyCheckRadius, (int)1, (int)4);
        int positiveDiff = negativeDiff - 1;
        for (int x = centerX - negativeDiff; x <= centerX + positiveDiff; ++x) {
            for (int z = centerZ - negativeDiff; z <= centerZ + positiveDiff; ++z) {
                int y = this.getY(chunk, x, z);
                if (!this.isSafe(chunk, x, y, z)) continue;
                return new class_243((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
        }
        return null;
    }

    private boolean isSafe(class_2818 chunk, int centerX, int y, int centerZ) {
        class_2338.class_2339 mutable = new class_2338.class_2339(centerX, y, centerZ);
        if (!(this.isSafeBelowPlayer(chunk.method_8320((class_2338)mutable)) && this.isSafeSurroundingPlayer(chunk.method_8320((class_2338)mutable.method_10098(class_2350.field_11036))) && this.level.method_18026(class_1299.field_6097.method_58629((double)centerX + 0.5, (double)(y + 1), (double)centerZ + 0.5)))) {
            return false;
        }
        int radius = Math.min(Config.instance().safetyCheckRadius, 4);
        if (radius > 0) {
            for (int x = centerX - radius; x <= centerX + radius; ++x) {
                for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                    class_2680 state;
                    if (x == centerX && z == centerZ || this.isSafeSurroundingBelowPlayer(state = chunk.method_8320((class_2338)mutable.method_10103(x, y, z))) && this.isSafeSurroundingPlayer(chunk.method_8320((class_2338)mutable.method_10098(class_2350.field_11036)))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isSafeBelowPlayer(class_2680 state) {
        class_2248 block = state.method_26204();
        return this.isSafeSurroundingBelowPlayer(state) && block != class_2246.field_10211;
    }

    private boolean isSafeSurroundingBelowPlayer(class_2680 state) {
        class_2248 block = state.method_26204();
        return (state.method_51366() || block == class_2246.field_10477) && block != class_2246.field_10029 && block != class_2246.field_10092;
    }

    private boolean isSafeSurroundingPlayer(class_2680 state) {
        class_2248 block = state.method_26204();
        return !state.method_26164(class_3481.field_21952) && !state.method_26164(class_3481.field_23799) && block != class_2246.field_10164 && block != class_2246.field_27879 && block != class_2246.field_10092 && block != class_2246.field_10029 && block != class_2246.field_16999;
    }

    private int getY(class_2818 chunk, int x, int z) {
        if (!this.level.method_8597().comp_643()) {
            return chunk.method_12005(class_2902.class_2903.field_13203, x, z);
        }
        int bottomY = chunk.method_31607();
        class_2338.class_2339 mutable = new class_2338.class_2339(x, this.level.method_32819(), z);
        boolean isAir = false;
        boolean isAirBelow = false;
        while (mutable.method_10264() >= bottomY && isAirBelow || !isAir) {
            isAir = isAirBelow;
            isAirBelow = chunk.method_8320((class_2338)mutable.method_10098(class_2350.field_11033)).method_26215();
        }
        return mutable.method_10264();
    }

    private boolean isValid(class_1923 pos) {
        if (this.level.method_8621().method_11951(pos)) {
            return this.isBiomeValid((class_6880<class_1959>)this.level.method_23753(new class_2338(this.x, this.level.method_32819(), this.z)));
        }
        return false;
    }

    private boolean isBiomeValid(class_6880<class_1959> biome) {
        for (class_6862 biomeTag : Config.instance().blackListedBiomeTags) {
            if (!biome.method_40220(biomeTag)) continue;
            return false;
        }
        class_5321 key = this.level.method_30349().method_30530(class_7924.field_41236).method_29113((Object)((class_1959)biome.comp_349())).orElse(null);
        return !Config.instance().blackListedBiomes.contains((Object)key);
    }

    private int nextRandomValue(int center) {
        return class_3532.method_15395((class_5819)RANDOM, (int)(center - this.radius), (int)(center + this.radius));
    }

    private int nextRandomValueWithMinimum(int center) {
        return RANDOM.method_43056() ? class_3532.method_15395((class_5819)RANDOM, (int)(center + this.minRadius), (int)(center + this.radius)) : class_3532.method_15395((class_5819)RANDOM, (int)(center - this.radius), (int)(center - this.minRadius));
    }
}

