/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.fastrtp.util;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.wesley1808.fastrtp.config.Config;
import me.wesley1808.fastrtp.util.Util;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class Scheduler {
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(0);
    private static final ObjectOpenHashSet<UUID> ACTIVE = new ObjectOpenHashSet();

    public static boolean canSchedule(UUID uuid) {
        return !ACTIVE.contains((Object)uuid);
    }

    public static void schedule(long millis, Runnable runnable) {
        SCHEDULER.schedule(runnable, millis, TimeUnit.MILLISECONDS);
    }

    public static void shutdown() {
        SCHEDULER.shutdown();
    }

    public static void scheduleTeleport(class_3222 player, Runnable onSuccess, Runnable onFail) {
        ACTIVE.add((Object)player.method_5667());
        Scheduler.teleportLoop(3, player.method_51469().method_8503(), player.method_5667(), player.method_73189(), onSuccess, onFail);
    }

    private static void teleportLoop(int seconds, MinecraftServer server, UUID uuid, class_243 oldPos, Runnable onSuccess, Runnable onFail) {
        if (seconds <= 0) {
            ACTIVE.remove((Object)uuid);
            server.execute(onSuccess);
            return;
        }
        class_3222 player = server.method_3760().method_14602(uuid);
        if (player == null || Config.instance().useStrictTeleportCheck && !player.method_73189().method_24802((class_2374)oldPos, 2.0)) {
            ACTIVE.remove((Object)uuid);
            server.execute(onFail);
            return;
        }
        player.method_7353(Util.format(Config.instance().messages.tpSecondsLeft.replace("${seconds}", String.valueOf(seconds)).replace("seconds", seconds == 1 ? "second" : "seconds")), false);
        Scheduler.schedule(1000L, () -> Scheduler.teleportLoop(seconds - 1, server, uuid, oldPos, onSuccess, onFail));
    }
}

