/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.fastrtp.util;

import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.util.List;
import me.wesley1808.fastrtp.config.Config;
import me.wesley1808.fastrtp.mixins.ServerChunkCacheAccessor;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1588;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_5321;
import net.minecraft.class_5575;
import net.minecraft.class_7260;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class Util {
    private static final NodeParser PARSER = NodeParser.builder().simplifiedTextFormat().quickText().requireSafe().build();

    @Nullable
    public static class_2818 getChunkIfLoaded(class_3218 level, int chunkX, int chunkZ) {
        class_3193 holder = Util.getChunkHolder(level.method_14178(), chunkX, chunkZ);
        return holder != null ? (class_2818)holder.method_20725().getNow(class_3193.field_16427).method_57130(null) : null;
    }

    @Nullable
    private static class_3193 getChunkHolder(class_3215 chunkCache, int chunkX, int chunkZ) {
        ServerChunkCacheAccessor accessor = (ServerChunkCacheAccessor)chunkCache;
        return accessor.getHolder(class_1923.method_8331((int)chunkX, (int)chunkZ));
    }

    public static class_2561 format(String string) {
        return PARSER.parseText(string, ParserContext.of());
    }

    public static class_3218 getLevel(class_3222 player) {
        class_3218 currentLevel = player.method_51469();
        class_3218 redirect = Util.parseLevel(currentLevel.method_8503(), (String)Config.instance().dimensionRedirects.get((Object)currentLevel.method_27983().method_29177().toString()));
        if (redirect != null) {
            return redirect;
        }
        if (Config.instance().useCurrentWorld) {
            return currentLevel;
        }
        class_3218 defaultLevel = Util.parseLevel(currentLevel.method_8503(), Config.instance().defaultDimension);
        return defaultLevel != null ? defaultLevel : currentLevel;
    }

    @Nullable
    public static class_3218 parseLevel(MinecraftServer server, @Nullable String dimension) {
        if (dimension == null || dimension.isBlank()) {
            return null;
        }
        class_2960 location = class_2960.method_12829((String)dimension);
        if (location == null) {
            return null;
        }
        return server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)location));
    }

    public static int getRadius(class_3218 level) {
        int borderRadius = (int)(level.method_8621().method_11965() / 2.0) - 16;
        int radius = Config.instance().radius;
        if (radius < 0) {
            return borderRadius;
        }
        return Math.min(borderRadius, radius);
    }

    @Nullable
    public static String mayTeleport(class_3222 player) {
        if (player.field_13974.method_14267() && Config.instance().useStrictTeleportCheck) {
            if (player.method_6059(class_1294.field_5902)) {
                return "Levitation Effect";
            }
            if (player.method_6059(class_1294.field_38092)) {
                return "Darkness Effect";
            }
            List monsters = player.method_51469().method_18023(class_5575.method_31795(class_1588.class), player.method_5829().method_1014(64.0), class_1301.field_6155);
            for (class_1588 monster : monsters) {
                if (!Util.isTargeted(player, (class_1308)monster)) continue;
                if (monster instanceof class_7260) {
                    return "Hunted by warden";
                }
                float distance = player.method_5739((class_1297)monster);
                if (!(distance < 24.0f) || !monster.method_5985().method_6369((class_1297)player)) continue;
                return String.format("Hunted by %s (%.0f blocks away)", class_1299.method_5890((class_1299)monster.method_5864()).method_12832(), Float.valueOf(distance));
            }
        }
        return null;
    }

    public static boolean isTargeted(class_3222 target, class_1308 mob) {
        boolean isTargeted;
        boolean bl = isTargeted = mob.method_5968() == target;
        if (!isTargeted) {
            class_4140 module;
            class_4095 brain = mob.method_18868();
            boolean bl2 = isTargeted = brain.method_18896(module = class_4140.field_22355) && brain.method_18904(module).orElse(null) == target;
        }
        if (!isTargeted && mob instanceof class_7260) {
            class_7260 warden = (class_7260)mob;
            isTargeted = warden.method_42216().method_42181().orElse(null) == target;
        }
        return isTargeted;
    }
}

