/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sighs.generalfeedback.init.Entry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class EntryLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("GeneralFeedback");

    public static List<Entry> loadAll() {
        return new ArrayList<Entry>(EntryLoader.loadFromDir(CONFIG_DIR));
    }

    private static List<Entry> loadFromDir(Path path) {
        ArrayList<Entry> allRule = new ArrayList<Entry>();
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return allRule;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.json");){
            for (Path file : stream) {
                allRule.add(EntryLoader.loadRecipesFromFile(file));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return allRule;
    }

    private static Entry loadRecipesFromFile(Path file) {
        Entry entry;
        block8: {
            BufferedReader reader = Files.newBufferedReader(file);
            try {
                entry = (Entry)GSON.fromJson((Reader)reader, new TypeToken<Entry>(){}.getType());
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new Entry();
                }
            }
            ((Reader)reader).close();
        }
        return entry;
    }
}

