/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.utils;

import com.sighs.generalfeedback.Generalfeedback;
import com.sighs.generalfeedback.api.FeedbackProvider;
import com.sighs.generalfeedback.client.FeedbackScreen;
import com.sighs.generalfeedback.client.ItemIconToast;
import com.sighs.generalfeedback.init.Entry;
import com.sighs.generalfeedback.init.Form;
import com.sighs.generalfeedback.loader.EntryCache;
import com.sighs.generalfeedback.provider.GitHubFeedbackProvider;
import com.sighs.generalfeedback.provider.GiteeFeedbackProvider;
import com.sighs.generalfeedback.provider.VikaFeedbackProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class FeedbackUtils {
    public static HashMap<String, String> cache = new HashMap();
    private static final List<FeedbackProvider> providers = new ArrayList<FeedbackProvider>();

    public static void post(Entry entry, Form form) {
        for (FeedbackProvider provider : providers) {
            if (!provider.supports(entry)) continue;
            provider.sendFeedback(entry, form);
            return;
        }
        FeedbackUtils.handleFailure("Unsupported feedback provider for URL: " + entry.url);
    }

    public static void showSendingToast() {
        ItemIconToast.show((class_2561)class_2561.method_43471((String)"toast.generalfeedback.sending.title"), (class_2561)class_2561.method_43471((String)"toast.generalfeedback.sending.desc"), new class_1799((class_1935)class_1802.field_8054));
    }

    public static void handleSuccess(String response, String entryId) {
        FeedbackUtils.sendSuccess(response);
        cache.remove(entryId);
    }

    public static void handleFailure(String error) {
        FeedbackUtils.sendFail(error);
    }

    public static String escapeJson(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public static String toJsonArray(List<String> items) {
        if (items == null || items.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < items.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\"").append(FeedbackUtils.escapeJson(items.get(i))).append("\"");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String generateIssueTitle(Form form) {
        return (String)(form.mark != 0 ? "(" + form.mark + "\u2605) " : "") + class_310.method_1551().field_1724.method_5476().getString() + ": " + form.feedback.substring(0, Math.min(form.feedback.length(), 30)) + (form.feedback.length() > 30 ? "......" : "");
    }

    public static String generateIssueBody(Form form) {
        return form.feedback + "\n\nFrom:\n" + form.contact;
    }

    private static void sendSuccess(String response) {
        class_310.method_1551().execute(() -> {
            Generalfeedback.LOGGER.warn("Response:{}", (Object)response);
            class_310.method_1551().method_1566().method_2000();
            ItemIconToast.show((class_2561)class_2561.method_43471((String)"toast.generalfeedback.send_success.title"), (class_2561)class_2561.method_43471((String)"toast.generalfeedback.send_success.desc"), new class_1799((class_1935)class_1802.field_8601));
        });
    }

    private static void sendFail(String error) {
        class_310.method_1551().execute(() -> {
            Generalfeedback.LOGGER.warn(error);
            ItemIconToast.show((class_2561)class_2561.method_43471((String)"toast.generalfeedback.send_fail.title"), (class_2561)class_2561.method_43471((String)"toast.generalfeedback.send_fail.desc"), new class_1799((class_1935)class_1802.field_8725));
        });
    }

    public static void openFeedbackScreenOf(String id) {
        if (EntryCache.UnitMapCache.containsKey(id)) {
            class_310.method_1551().method_1507((class_437)new FeedbackScreen(EntryCache.UnitMapCache.get(id)));
        }
    }

    static {
        providers.add(new VikaFeedbackProvider());
        providers.add(new GitHubFeedbackProvider());
        providers.add(new GiteeFeedbackProvider());
    }
}

