/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.client;

import com.sighs.generalfeedback.Generalfeedback;
import com.sighs.generalfeedback.utils.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BooleanButton
extends Button {
    private static final ResourceLocation BUTTON_NORMAL_TEXTURE = Generalfeedback.id("textures/gui/button_0.png");
    private static final ResourceLocation BUTTON_PRESSED_TEXTURE = Generalfeedback.id("textures/gui/button_1.png");
    public boolean value = false;

    public BooleanButton(int x, int y, int width, int height, Component text, Button.OnPress onPress) {
        super(x, y, width, height, text, onPress, Button.DEFAULT_NARRATION);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation texture = this.value ? BUTTON_PRESSED_TEXTURE : BUTTON_NORMAL_TEXTURE;
        int textureSize = 18;
        int border = 6;
        GuiUtils.drawNinePatch(graphics, texture, this.getX(), this.getY(), this.getWidth(), this.getHeight(), textureSize, border);
        int textColor = this.value ? 0xFFFFA0 : 0xFFFFFF;
        graphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.getWidth() / 2, this.getY() + (this.getHeight() - 10) / 2, textColor);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.active && this.visible && this.clicked(mouseX, mouseY)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

