/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.client;

import com.sighs.generalfeedback.Generalfeedback;
import com.sighs.generalfeedback.client.FeedbackScreen;
import com.sighs.generalfeedback.init.Entry;
import com.sighs.generalfeedback.utils.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class FeedbackButton
extends Button {
    private static final ResourceLocation BUTTON_NORMAL_TEXTURE = Generalfeedback.id("textures/gui/feedback_0.png");
    private static final ResourceLocation BUTTON_PRESSED_TEXTURE = Generalfeedback.id("textures/gui/feedback_1.png");

    public FeedbackButton(int x, int y, int width, int height, Entry entry) {
        super(x, y, width, height, Component.nullToEmpty((String)""), button -> Minecraft.getInstance().setScreen((Screen)new FeedbackScreen(entry)), Button.DEFAULT_NARRATION);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation texture = this.isHovered ? BUTTON_PRESSED_TEXTURE : BUTTON_NORMAL_TEXTURE;
        int textureSize = 18;
        int border = 6;
        GuiUtils.drawNinePatch(graphics, texture, this.getX(), this.getY(), this.getWidth(), this.getHeight(), textureSize, border);
        int textColor = this.isHovered ? 0xFFFFA0 : 0xFFFFFF;
        graphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.getWidth() / 2, this.getY() + (this.getHeight() - 10) / 2, textColor);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.active && this.visible && this.clicked(mouseX, mouseY)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

