/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.client;

import com.sighs.generalfeedback.Generalfeedback;
import com.sighs.generalfeedback.client.ActionButton;
import com.sighs.generalfeedback.client.BooleanButton;
import com.sighs.generalfeedback.client.Textarea;
import com.sighs.generalfeedback.event.SubmitEvent;
import com.sighs.generalfeedback.init.Entry;
import com.sighs.generalfeedback.init.Form;
import com.sighs.generalfeedback.utils.FeedbackUtils;
import com.sighs.generalfeedback.utils.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class FeedbackScreen
extends Screen {
    private final Entry entry;
    private List<Boolean> markValue;
    private Textarea feedbackTextarea;
    private Textarea contactTextarea;
    private List<BooleanButton> markButtonList = new ArrayList<BooleanButton>();
    private ActionButton submitButton;
    private int storedY;

    private List<Boolean> initMarkValue() {
        this.markValue = new ArrayList<Boolean>();
        for (int i = 0; i < 5; ++i) {
            this.markValue.add(false);
        }
        return this.markValue;
    }

    public FeedbackScreen(Entry entry) {
        super((Component)Component.translatable((String)"gui.generalfeedback.feedback"));
        this.entry = entry;
    }

    public void sendForm() {
        Minecraft.getInstance().setScreen(null);
        SubmitEvent event = new SubmitEvent(this.entry, this.getForm());
        if (((SubmitEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return;
        }
        FeedbackUtils.post(event.getEntry(), event.getForm());
    }

    public Form getForm() {
        Form form = new Form();
        form.feedback = this.feedbackTextarea.getText();
        form.contact = this.contactTextarea.getText();
        form.mark = this.markValue.indexOf(true) + 1;
        return form;
    }

    protected void init() {
        super.init();
        int margin = 2;
        int width = 240;
        int x = (this.width - width) / 2;
        int y = 10;
        this.feedbackTextarea = new Textarea(x, y, width, 120, (Component)Component.literal((String)(Component.translatable((String)"gui.generalfeedback.feedback").getString() + ": " + Component.translatable((String)this.entry.title).getString())));
        String preset = FeedbackUtils.cache.getOrDefault(this.entry.id, Component.translatable((String)this.entry.placeholder).getString());
        this.feedbackTextarea.setText(preset);
        this.feedbackTextarea.onChange(text -> FeedbackUtils.cache.put(this.entry.id, Component.translatable((String)text).getString()));
        this.addRenderableWidget((GuiEventListener)this.feedbackTextarea);
        this.storedY = y += 120 + margin;
        this.initMarkValue();
        for (int i = 0; i < 5; ++i) {
            int _x = x + 95 + i * 28;
            int finalI = i;
            BooleanButton booleanButton = new BooleanButton(_x, y + 4, 26, 16, (Component)Component.translatable((String)(i + 1 + Component.translatable((String)"gui.generalfeedback.star").getString())), button -> {
                BooleanButton b = (BooleanButton)button;
                if (!b.value && this.markValue.contains(true)) {
                    this.initMarkValue();
                    this.markButtonList.forEach(_b -> {
                        _b.value = false;
                    });
                }
                b.value = !b.value;
                this.markValue.set(finalI, b.value);
            });
            this.markButtonList.add(booleanButton);
            this.addRenderableWidget((GuiEventListener)booleanButton);
        }
        this.contactTextarea = new Textarea(x, y += 24 + margin, width, 58, (Component)Component.translatable((String)"gui.generalfeedback.contact"));
        this.addRenderableWidget((GuiEventListener)this.contactTextarea);
        MutableComponent submitText = Component.translatable((String)"gui.generalfeedback.submit");
        this.submitButton = new ActionButton((this.width - 70) / 2, y += 58 + margin, 70, 20, (Component)submitText, button -> this.sendForm());
        this.addRenderableWidget((GuiEventListener)this.submitButton);
        this.setFocused((GuiEventListener)this.feedbackTextarea);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int width = 240;
        int x = (this.width - width) / 2;
        GuiUtils.drawNinePatch(guiGraphics, Generalfeedback.id("textures/gui/container.png"), x, this.storedY, width, 24, 256, 20);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.generalfeedback.mark"), x + 10, this.storedY + 7, -9872501, false);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }
}

