/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.model.TridentModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemIconToast
implements Toast {
    private final Component title;
    private final Component description;
    private final ItemStack icon;

    public ItemIconToast(Component title, Component description, ItemStack icon) {
        this.title = title;
        this.description = description;
        this.icon = icon;
    }

    public Toast.Visibility render(GuiGraphics gui, ToastComponent toastComponent, long timer) {
        gui.blit(TridentModel.TEXTURE, 0, 0, 0, 0, this.width(), this.height());
        gui.renderFakeItem(this.icon, 8, 8);
        gui.drawString(toastComponent.getMinecraft().font, this.title.getString(), 30, 7, 16766720);
        gui.drawString(toastComponent.getMinecraft().font, this.description.getString(), 30, 18, 0xFFFFFF);
        return timer >= 2000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public static void show(Component title, Component description, ItemStack icon) {
        Minecraft.getInstance().getToasts().addToast((Toast)new ItemIconToast(title, description, icon));
    }

    public static void create(String title, String desc, ItemStack itemStack) {
        ItemIconToast.show((Component)Component.translatable((String)title), (Component)Component.translatable((String)desc), itemStack);
    }
}

