/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.client;

import com.sighs.generalfeedback.utils.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

public class Textarea
extends class_339 {
    private static final class_2960 EDITOR_TEXTURE = class_2960.method_60655((String)"generalfeedback", (String)"textures/gui/editor.png");
    private static final int OFFSET_X = 10;
    private static final int OFFSET_Y = 20;
    private static final int OFFSET_W = 20;
    private static final int OFFSET_H = 30;
    private static final int INNER_PADDING = 4;
    private final class_327 font;
    private final class_2561 title;
    private final int lineHeight;
    private final int maxWidth;
    private String text = "";
    private int cursorIndex = 0;
    private int scrollOffset = 0;
    private Consumer<String> onChange;

    public Textarea(int x, int y, int width, int height, class_2561 title) {
        super(x + 10, y + 20, width - 20, height - 30, (class_2561)class_2561.method_43473());
        this.font = class_310.method_1551().field_1772;
        Objects.requireNonNull(this.font);
        this.lineHeight = 9;
        this.maxWidth = this.field_22758 - 8;
        this.title = title;
        this.field_22763 = true;
    }

    public void onChange(Consumer<String> onChange) {
        this.onChange = onChange;
    }

    public void method_48579(class_332 g, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawNinePatch(g, EDITOR_TEXTURE, this.method_46426() - 10, this.method_46427() - 20, this.field_22758 + 20, this.field_22759 + 30, 256, 20);
        g.method_51439(this.font, this.title, this.method_46426(), this.method_46427() - 20 + 7, -9872501, false);
        TextLayout layout = new TextLayout(this.text, this.font, this.maxWidth);
        int maxVisible = Math.max(1, (this.field_22759 - 8) / this.lineHeight);
        int maxStart = Math.max(0, layout.lines.size() - maxVisible);
        this.scrollOffset = Math.min(this.scrollOffset, maxStart);
        int drawX = this.method_46426() + 4;
        int drawY = this.method_46427() + 4;
        for (int i = 0; i < Math.min(maxVisible, layout.lines.size() - this.scrollOffset); ++i) {
            g.method_51433(this.font, layout.lines.get(this.scrollOffset + i), drawX, drawY + i * this.lineHeight, -1, true);
        }
        if (this.method_25370() && System.currentTimeMillis() / 500L % 2L == 0L) {
            CursorPos cp = layout.cursorPos(this.cursorIndex);
            int relLine = cp.line - this.scrollOffset;
            if (relLine >= 0 && relLine < maxVisible) {
                int cx = drawX + this.font.method_1727(cp.before);
                int cy = drawY + relLine * this.lineHeight;
                g.method_25294(cx, cy, cx + 1, cy + this.lineHeight, -1);
            }
        }
    }

    public boolean method_25400(char c, int modifiers) {
        if (!this.field_22764) {
            return false;
        }
        if (Character.isISOControl(c) && c != '\n') {
            return false;
        }
        this.insertChar(c);
        return true;
    }

    private void insertChar(char c) {
        if (this.text.length() >= 1024) {
            return;
        }
        this.text = this.text.substring(0, this.cursorIndex) + c + this.text.substring(this.cursorIndex);
        ++this.cursorIndex;
        this.ensureCursorVisible();
        this.notifyChange();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.field_22764) {
            return false;
        }
        switch (keyCode) {
            case 259: {
                this.deleteChar(-1);
                break;
            }
            case 261: {
                this.deleteChar(0);
                break;
            }
            case 257: 
            case 335: {
                this.insertChar('\n');
                break;
            }
            case 263: {
                this.cursorIndex = Math.max(0, this.cursorIndex - 1);
                break;
            }
            case 262: {
                this.cursorIndex = Math.min(this.text.length(), this.cursorIndex + 1);
                break;
            }
            case 264: 
            case 265: {
                this.moveVertical(keyCode == 265 ? -1 : 1);
                break;
            }
            default: {
                return false;
            }
        }
        this.ensureCursorVisible();
        return true;
    }

    private void deleteChar(int offset) {
        if (offset == -1 && this.cursorIndex > 0) {
            this.text = this.text.substring(0, this.cursorIndex - 1) + this.text.substring(this.cursorIndex);
            --this.cursorIndex;
        } else if (offset == 0 && this.cursorIndex < this.text.length()) {
            this.text = this.text.substring(0, this.cursorIndex) + this.text.substring(this.cursorIndex + 1);
        }
        this.notifyChange();
    }

    private void moveVertical(int direction) {
        TextLayout layout = new TextLayout(this.text, this.font, this.maxWidth);
        CursorPos cp = layout.cursorPos(this.cursorIndex);
        int target = cp.line + direction;
        if (target < 0 || target >= layout.lines.size()) {
            return;
        }
        int col = cp.before.length();
        this.cursorIndex = layout.indexAt(target, col);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            this.method_25365(false);
            return false;
        }
        this.method_25365(true);
        int localX = (int)(mouseX - (double)this.method_46426() - 4.0);
        int localY = (int)(mouseY - (double)this.method_46427() - 4.0);
        TextLayout layout = new TextLayout(this.text, this.font, this.maxWidth);
        int line = this.scrollOffset + Math.max(0, Math.min(localY / this.lineHeight, layout.lines.size() - 1));
        int col = layout.charIndexAt(line, localX);
        this.cursorIndex = layout.indexAt(line, col);
        this.ensureCursorVisible();
        return true;
    }

    public boolean method_25401(double mx, double my, double sx, double sy) {
        if (!this.method_25405(mx, my)) {
            return false;
        }
        int step = (int)Math.signum(sy);
        this.scrollOffset = Math.max(0, this.scrollOffset - step);
        return true;
    }

    protected void method_47399(class_6382 narration) {
    }

    private void ensureCursorVisible() {
        TextLayout layout = new TextLayout(this.text, this.font, this.maxWidth);
        int maxVisible = Math.max(1, (this.field_22759 - 8) / this.lineHeight);
        CursorPos cp = layout.cursorPos(this.cursorIndex);
        if (cp.line < this.scrollOffset) {
            this.scrollOffset = cp.line;
        } else if (cp.line >= this.scrollOffset + maxVisible) {
            this.scrollOffset = cp.line - maxVisible + 1;
        }
    }

    private void notifyChange() {
        if (this.onChange != null) {
            this.onChange.accept(this.text);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String t) {
        this.text = t == null ? "" : t;
        this.cursorIndex = Math.min(this.cursorIndex, this.text.length());
    }

    private static class TextLayout {
        final List<String> lines = new ArrayList<String>();
        final List<Integer> starts = new ArrayList<Integer>();
        private final String src;

        TextLayout(String src, class_327 font, int width) {
            String string = this.src = src == null ? "" : src;
            if (this.src.isEmpty()) {
                this.lines.add("");
                this.starts.add(0);
                return;
            }
            int idx = 0;
            for (String para : this.src.split("\n", -1)) {
                if (para.isEmpty()) {
                    this.lines.add("");
                    this.starts.add(idx++);
                    continue;
                }
                while (!para.isEmpty()) {
                    int cut = TextLayout.findCut(font, para, width);
                    this.lines.add(para.substring(0, cut));
                    this.starts.add(idx);
                    idx += cut;
                    para = para.substring(cut);
                }
                if (idx >= this.src.length()) continue;
                ++idx;
            }
        }

        CursorPos cursorPos(int globalIndex) {
            int ci = Math.max(0, Math.min(globalIndex, this.src.length()));
            for (int i = 0; i < this.lines.size(); ++i) {
                int start = this.starts.get(i);
                int end = start + this.lines.get(i).length();
                if (ci < start || ci > end) continue;
                return new CursorPos(i, this.lines.get(i).substring(0, ci - start));
            }
            int last = this.lines.size() - 1;
            return new CursorPos(last, this.lines.get(last));
        }

        int indexAt(int line, int col) {
            line = Math.max(0, Math.min(line, this.lines.size() - 1));
            col = Math.min(col, this.lines.get(line).length());
            return this.starts.get(line) + col;
        }

        int charIndexAt(int line, int px) {
            line = Math.max(0, Math.min(line, this.lines.size() - 1));
            String s = this.lines.get(line);
            if (px <= 0) {
                return 0;
            }
            int len = s.length();
            int full = class_310.method_1551().field_1772.method_1727(s);
            if (px >= full) {
                return len;
            }
            for (int i = 1; i <= len; ++i) {
                if (class_310.method_1551().field_1772.method_1727(s.substring(0, i)) <= px) continue;
                return i - 1;
            }
            return len;
        }

        private static int findCut(class_327 font, String s, int w) {
            int i;
            if (font.method_1727(s) <= w) {
                return s.length();
            }
            for (i = 0; i < s.length() && font.method_1727(s.substring(0, i + 1)) <= w; ++i) {
            }
            return Math.max(i, 1);
        }
    }

    private record CursorPos(int line, String before) {
    }
}

