/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.client;

import com.sighs.generalfeedback.client.ActionButton;
import com.sighs.generalfeedback.client.BooleanButton;
import com.sighs.generalfeedback.client.Textarea;
import com.sighs.generalfeedback.compat.KubeJSCompat;
import com.sighs.generalfeedback.init.Entry;
import com.sighs.generalfeedback.init.Form;
import com.sighs.generalfeedback.init.SubmitEvent;
import com.sighs.generalfeedback.utils.FeedbackUtils;
import com.sighs.generalfeedback.utils.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class FeedbackScreen
extends Screen {
    private final Entry entry;
    private List<Boolean> markValue;
    private Textarea feedbackTextarea;
    private Textarea contactTextarea;
    private List<BooleanButton> markButtonList = new ArrayList<BooleanButton>();
    private ActionButton submitButton;
    private int storedY;

    private List<Boolean> initMarkValue() {
        this.markValue = new ArrayList<Boolean>();
        for (int i = 0; i < 5; ++i) {
            this.markValue.add(false);
        }
        return this.markValue;
    }

    public FeedbackScreen(Entry entry) {
        super((Component)Component.m_237115_((String)"gui.generalfeedback.feedback"));
        this.entry = entry;
    }

    public void sendForm() {
        Minecraft.m_91087_().m_91152_(null);
        SubmitEvent event = new SubmitEvent(this.entry, this.getForm());
        MinecraftForge.EVENT_BUS.post((Event)event);
        SubmitEvent _event = KubeJSCompat.submit(event);
        if (event.isCanceled() || _event.isCanceled()) {
            return;
        }
        FeedbackUtils.post(_event.getEntry(), _event.getForm());
    }

    public Form getForm() {
        Form form = new Form();
        form.feedback = this.feedbackTextarea.getText();
        form.contact = this.contactTextarea.getText();
        form.mark = this.markValue.indexOf(true) + 1;
        return form;
    }

    protected void m_7856_() {
        super.m_7856_();
        int margin = 2;
        int width = 240;
        int x = (this.f_96543_ - width) / 2;
        int y = 10;
        this.feedbackTextarea = new Textarea(x, y, width, 120, (Component)Component.m_237113_((String)(Component.m_237115_((String)"gui.generalfeedback.feedback").getString() + ": " + Component.m_237115_((String)this.entry.title).getString())));
        String preset = FeedbackUtils.cache.getOrDefault(this.entry.id, Component.m_237115_((String)this.entry.placeholder).getString());
        this.feedbackTextarea.setText(preset);
        this.feedbackTextarea.onChange(text -> FeedbackUtils.cache.put(this.entry.id, Component.m_237115_((String)text).getString()));
        this.m_142416_((GuiEventListener)this.feedbackTextarea);
        this.storedY = y += 120 + margin;
        this.initMarkValue();
        for (int i = 0; i < 5; ++i) {
            int _x = x + 95 + i * 28;
            int finalI = i;
            BooleanButton booleanButton = new BooleanButton(_x, y + 4, 26, 16, (Component)Component.m_237115_((String)(i + 1 + Component.m_237115_((String)"gui.generalfeedback.star").getString())), button -> {
                BooleanButton b = (BooleanButton)button;
                if (!b.value && this.markValue.contains(true)) {
                    this.initMarkValue();
                    this.markButtonList.forEach(_b -> {
                        _b.value = false;
                    });
                }
                b.value = !b.value;
                this.markValue.set(finalI, b.value);
            });
            this.markButtonList.add(booleanButton);
            this.m_142416_((GuiEventListener)booleanButton);
        }
        this.contactTextarea = new Textarea(x, y += 24 + margin, width, 58, (Component)Component.m_237115_((String)"gui.generalfeedback.contact"));
        this.m_142416_((GuiEventListener)this.contactTextarea);
        MutableComponent submitText = Component.m_237115_((String)"gui.generalfeedback.submit");
        this.submitButton = new ActionButton((this.f_96543_ - 70) / 2, y += 58 + margin, 70, 20, (Component)submitText, button -> this.sendForm());
        this.m_142416_((GuiEventListener)this.submitButton);
        this.m_7522_((GuiEventListener)this.feedbackTextarea);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int width = 240;
        int x = (this.f_96543_ - width) / 2;
        GuiUtils.drawNinePatch(guiGraphics, new ResourceLocation("generalfeedback", "textures/gui/container.png"), x, this.storedY, width, 24, 256, 20);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.generalfeedback.mark"), x + 10, this.storedY + 7, -9872501, false);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }
}

