/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.client;

import com.sighs.generalfeedback.utils.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Textarea
extends AbstractWidget {
    private final Component title;
    private String text = "";
    private int cursorIndex = 0;
    private final int innerPadding = 4;
    private final int lineHeight;
    private final int maxWidth;
    private final Font font;
    private int scrollOffset = 0;
    private Consumer<String> onChange;
    private static final ResourceLocation EDITOR_TEXTURE = new ResourceLocation("generalfeedback", "textures/gui/editor.png");
    private static final int offsetX = 10;
    private static final int offsetY = 20;
    private static final int offsetW = 20;
    private static final int offsetH = 30;

    public Textarea(int x, int y, int width, int height, Component title) {
        super(x + 10, y + 20, width - 20, height - 30, (Component)Component.m_237119_());
        this.font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(this.font);
        this.lineHeight = 9;
        this.maxWidth = width - 20 - 8;
        this.f_93623_ = true;
        this.title = title;
    }

    public void onChange(Consumer<String> onChange) {
        this.onChange = onChange;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawNinePatch(guiGraphics, EDITOR_TEXTURE, this.m_252754_() - 10, this.m_252907_() - 20, this.f_93618_ + 20, this.f_93619_ + 30, 256, 20);
        guiGraphics.m_280614_(this.font, this.title, this.m_252754_(), this.m_252907_() - 20 + 7, -9872501, false);
        List<String> lines = this.wrappedLines();
        int maxVisibleLines = Math.max(1, (this.f_93619_ - 8) / this.lineHeight);
        int maxStart = Math.max(0, lines.size() - maxVisibleLines);
        int startLine = Math.min(Math.max(0, this.scrollOffset), maxStart);
        int drawX = this.m_252754_() + 4;
        int drawY = this.m_252907_() + 4;
        for (int i = 0; i < Math.min(maxVisibleLines, lines.size() - startLine); ++i) {
            String ln = lines.get(startLine + i);
            guiGraphics.m_280056_(this.font, ln, drawX, drawY + i * this.lineHeight, -1, true);
        }
        CursorPos cp = this.cursorPositionInRendered(lines);
        int cursorScreenLine = cp.lineIndex - startLine;
        if (cursorScreenLine >= 0 && cursorScreenLine < maxVisibleLines) {
            int cx = drawX + this.font.m_92895_(cp.lineTextBeforeCursor);
            int cy = drawY + cursorScreenLine * this.lineHeight;
            if (this.m_93696_() && System.currentTimeMillis() / 500L % 2L == 0L) {
                guiGraphics.m_280509_(cx, cy, cx + 1, cy + this.lineHeight, -1);
            }
        }
    }

    private List<String> wrappedLines() {
        String[] paragraphs;
        ArrayList<String> out = new ArrayList<String>();
        if (this.text == null || this.text.isEmpty()) {
            out.add("");
            return out;
        }
        for (String para : paragraphs = this.text.split("\n", -1)) {
            if (para.isEmpty()) {
                out.add("");
                continue;
            }
            String rem = para;
            while (!rem.isEmpty()) {
                int cut = this.findCutIndexForWidth(rem, this.maxWidth);
                out.add(rem.substring(0, cut));
                rem = rem.substring(cut);
            }
        }
        return out;
    }

    private int findCutIndexForWidth(String s, int pixelWidth) {
        int w;
        int i;
        if (this.font.m_92895_(s) <= pixelWidth) {
            return s.length();
        }
        int len = s.length();
        for (i = 0; i < len && (w = this.font.m_92895_(s.substring(0, i + 1))) <= pixelWidth; ++i) {
        }
        if (i == 0) {
            i = 1;
        }
        return i;
    }

    private CursorPos cursorPositionInRendered(List<String> _unused) {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<Integer> lineStartIndices = new ArrayList<Integer>();
        String src = this.text == null ? "" : this.text;
        String[] paragraphs = src.split("\n", -1);
        int originalIndex = 0;
        for (int p = 0; p < paragraphs.length; ++p) {
            String para = paragraphs[p];
            if (para.isEmpty()) {
                lines.add("");
                lineStartIndices.add(originalIndex);
            } else {
                String rem = para;
                while (!rem.isEmpty()) {
                    int cut = this.findCutIndexForWidth(rem, this.maxWidth);
                    String piece = rem.substring(0, cut);
                    lines.add(piece);
                    lineStartIndices.add(originalIndex);
                    originalIndex += piece.length();
                    rem = rem.substring(cut);
                }
            }
            if (originalIndex >= src.length()) continue;
            ++originalIndex;
        }
        if (lines.isEmpty()) {
            lines.add("");
            lineStartIndices.add(0);
        }
        int ci = Math.max(0, Math.min(this.cursorIndex, src.length()));
        for (int i = 0; i < lines.size(); ++i) {
            int start = (Integer)lineStartIndices.get(i);
            int len = ((String)lines.get(i)).length();
            int endExclusive = start + len;
            if (ci < start || ci > endExclusive) continue;
            int posInLine = ci - start;
            String before = ((String)lines.get(i)).substring(0, Math.max(0, Math.min(posInLine, len)));
            return new CursorPos(i, before);
        }
        int lastIdx = lines.size() - 1;
        String last = (String)lines.get(lastIdx);
        return new CursorPos(lastIdx, last);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (!this.f_93624_) {
            return false;
        }
        if (Character.isISOControl(codePoint)) {
            if (codePoint == '\n') {
                this.insertChar('\n');
                return true;
            }
            return false;
        }
        this.insertChar(codePoint);
        return true;
    }

    private void insertChar(char c) {
        if (this.text.length() >= 1024) {
            return;
        }
        if (this.cursorIndex < 0) {
            this.cursorIndex = 0;
        }
        if (this.cursorIndex > this.text.length()) {
            this.cursorIndex = this.text.length();
        }
        this.text = this.text.substring(0, this.cursorIndex) + c + this.text.substring(this.cursorIndex);
        ++this.cursorIndex;
        this.ensureCursorVisible(this.wrappedLines());
        if (this.onChange != null) {
            this.onChange.accept(this.getText());
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.f_93624_) {
            return false;
        }
        if (keyCode == 259) {
            if (this.cursorIndex > 0) {
                this.text = this.text.substring(0, this.cursorIndex - 1) + this.text.substring(this.cursorIndex);
                --this.cursorIndex;
            }
            return true;
        }
        if (keyCode == 261) {
            if (this.cursorIndex < this.text.length()) {
                this.text = this.text.substring(0, this.cursorIndex) + this.text.substring(this.cursorIndex + 1);
            }
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.insertChar('\n');
            return true;
        }
        if (keyCode == 263) {
            if (this.cursorIndex > 0) {
                --this.cursorIndex;
            }
            return true;
        }
        if (keyCode == 262) {
            if (this.cursorIndex < this.text.length()) {
                ++this.cursorIndex;
            }
            return true;
        }
        if (keyCode == 265 || keyCode == 264) {
            List<String> lines = this.wrappedLines();
            CursorPos cp = this.cursorPositionInRendered(lines);
            int targetLine = cp.lineIndex + (keyCode == 265 ? -1 : 1);
            if (targetLine < 0) {
                targetLine = 0;
            }
            if (targetLine >= lines.size()) {
                targetLine = lines.size() - 1;
            }
            int col = cp.lineTextBeforeCursor.length();
            int idx = 0;
            for (int i = 0; i < targetLine; ++i) {
                idx += lines.get(i).length();
            }
            int newPosInLine = Math.min(col, lines.get(targetLine).length());
            this.cursorIndex = idx + newPosInLine;
            this.ensureCursorVisible(lines);
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            int charIndexInLine;
            int clickedLineLocal;
            this.m_93692_(true);
            int localX = (int)(mouseX - (double)this.m_252754_() - 4.0);
            int localY = (int)(mouseY - (double)this.m_252907_() - 4.0);
            ArrayList<String> lines = new ArrayList<String>();
            ArrayList<Integer> lineStartIndices = new ArrayList<Integer>();
            String src = this.text == null ? "" : this.text;
            String[] paragraphs = src.split("\n", -1);
            int originalIndex = 0;
            for (int p = 0; p < paragraphs.length; ++p) {
                String para = paragraphs[p];
                if (para.isEmpty()) {
                    lines.add("");
                    lineStartIndices.add(originalIndex);
                } else {
                    String rem = para;
                    while (!rem.isEmpty()) {
                        int cut = this.findCutIndexForWidth(rem, this.maxWidth);
                        String piece = rem.substring(0, cut);
                        lines.add(piece);
                        lineStartIndices.add(originalIndex);
                        originalIndex += piece.length();
                        rem = rem.substring(cut);
                    }
                }
                if (originalIndex >= src.length()) continue;
                ++originalIndex;
            }
            if (lines.isEmpty()) {
                lines.add("");
                lineStartIndices.add(0);
            }
            int maxVisibleLines = Math.max(1, (this.f_93619_ - 8) / this.lineHeight);
            int maxStart = Math.max(0, lines.size() - maxVisibleLines);
            int startLine = Math.min(Math.max(0, this.scrollOffset), maxStart);
            int clickedLine = startLine + (clickedLineLocal = localY / this.lineHeight);
            if (clickedLine < 0) {
                clickedLine = 0;
            }
            if (clickedLine >= lines.size()) {
                clickedLine = lines.size() - 1;
            }
            String targetLine = (String)lines.get(clickedLine);
            int lineStartInRaw = (Integer)lineStartIndices.get(clickedLine);
            int globalIndex = lineStartInRaw + (charIndexInLine = this.charIndexFromLocalX(targetLine, localX));
            if (globalIndex < 0) {
                globalIndex = 0;
            }
            if (globalIndex > this.text.length()) {
                globalIndex = this.text.length();
            }
            this.cursorIndex = lineStartInRaw + charIndexInLine;
            this.ensureCursorVisible(lines);
            return true;
        }
        this.m_93692_(false);
        return false;
    }

    private int charIndexFromLocalX(String line, int localX) {
        if (localX <= 0) {
            return 0;
        }
        if (line.isEmpty()) {
            return 0;
        }
        int len = line.length();
        int fullWidth = this.font.m_92895_(line);
        if (localX >= fullWidth) {
            return len;
        }
        for (int i = 1; i <= len; ++i) {
            int w = this.font.m_92895_(line.substring(0, i));
            if (w <= localX) continue;
            return Math.max(0, i - 1);
        }
        return len;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        int step = (int)Math.round(delta);
        this.scrollOffset -= step;
        List<String> lines = this.wrappedLines();
        int maxVisibleLines = Math.max(1, (this.f_93619_ - 8) / this.lineHeight);
        int maxStart = Math.max(0, lines.size() - maxVisibleLines);
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        if (this.scrollOffset > maxStart) {
            this.scrollOffset = maxStart;
        }
        return true;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    private void ensureCursorVisible(List<String> lines) {
        int maxVisibleLines = Math.max(1, (this.f_93619_ - 8) / this.lineHeight);
        int maxStart = Math.max(0, lines.size() - maxVisibleLines);
        CursorPos cp = this.cursorPositionInRendered(lines);
        int cursorLine = cp.lineIndex;
        if (cursorLine < this.scrollOffset) {
            this.scrollOffset = cursorLine;
        } else if (cursorLine >= this.scrollOffset + maxVisibleLines) {
            this.scrollOffset = cursorLine - maxVisibleLines + 1;
        }
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        if (this.scrollOffset > maxStart) {
            this.scrollOffset = maxStart;
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String t) {
        this.text = t == null ? "" : t;
        this.cursorIndex = Math.min(this.cursorIndex, this.text.length());
    }

    private static class CursorPos {
        int lineIndex;
        String lineTextBeforeCursor;

        CursorPos(int lineIndex, String before) {
            this.lineIndex = lineIndex;
            this.lineTextBeforeCursor = before;
        }
    }
}

