/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.utils;

import com.sighs.generalfeedback.Generalfeedback;
import com.sighs.generalfeedback.client.FeedbackScreen;
import com.sighs.generalfeedback.client.ItemIconToast;
import com.sighs.generalfeedback.init.Entry;
import com.sighs.generalfeedback.init.Form;
import com.sighs.generalfeedback.loader.EntryCache;
import com.sighs.generalfeedback.utils.HttpUtil;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class FeedbackUtils {
    public static HashMap<String, String> cache = new HashMap();

    public static void post(Entry entry, Form form) {
        if (entry.url.contains("api.vika.cn")) {
            FeedbackUtils.addVikaRecord(entry, form);
        }
        if (entry.url.contains("api.github.com")) {
            FeedbackUtils.createGitHubIssue(entry, form);
        }
    }

    public static void addVikaRecord(Entry entry, Form form) {
        ItemIconToast.show((Component)Component.m_237115_((String)"toast.generalfeedback.sending.title"), (Component)Component.m_237115_((String)"toast.generalfeedback.sending.desc"), new ItemStack((ItemLike)Items.f_42403_));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + entry.token);
        headers.put("Content-Type", "application/json");
        String jsonBody = "{\"records\": [{\"fields\": {\"\u610f\u89c1\u53cd\u9988\": \"" + form.feedback.replace("\n", "\\n") + "\",\"\u4f53\u9a8c\u8bc4\u5206\": " + form.mark + ",\"\u843d\u6b3e\": \"" + form.contact.replace("\n", "\\n") + "\"}}],\"fieldKey\": \"name\"}";
        HttpUtil.fetch(entry.url, "POST", headers, jsonBody, null, 5000, response -> {
            FeedbackUtils.sendSuccess(response);
            cache.remove(entry.id);
        }, FeedbackUtils::sendFail);
    }

    public static void createGitHubIssue(Entry entry, Form form) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + entry.token);
        headers.put("Content-Type", "application/json");
        String title = (String)(form.mark != 0 ? "(" + form.mark + "\u2605) " : "") + Minecraft.m_91087_().f_91074_.m_5446_().getString() + ": " + form.feedback.substring(0, Math.min(form.feedback.length(), 30)) + (form.feedback.length() > 30 ? "......" : "");
        String body = form.feedback + "\n\nFrom:\n" + form.contact;
        String jsonBody = "{\"title\": \"" + FeedbackUtils.escapeJson(title) + "\",\"body\": \"" + FeedbackUtils.escapeJson(body) + "\"}";
        HttpUtil.fetch(entry.url, "POST", headers, jsonBody, null, 5000, response -> {
            FeedbackUtils.sendSuccess(response);
            cache.remove(entry.id);
        }, FeedbackUtils::sendFail);
    }

    private static String escapeJson(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private String toJsonArray(List<String> items) {
        if (items == null || items.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < items.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\"").append(FeedbackUtils.escapeJson(items.get(i))).append("\"");
        }
        sb.append("]");
        return sb.toString();
    }

    private static void sendSuccess(String response) {
        Minecraft.m_91087_().execute(() -> {
            Generalfeedback.LOGGER.warn("Response:{}", (Object)response);
            Minecraft.m_91087_().m_91300_().m_94919_();
            ItemIconToast.show((Component)Component.m_237115_((String)"toast.generalfeedback.send_success.title"), (Component)Component.m_237115_((String)"toast.generalfeedback.send_success.desc"), new ItemStack((ItemLike)Items.f_42525_));
        });
    }

    private static void sendFail(String error) {
        Minecraft.m_91087_().execute(() -> {
            Generalfeedback.LOGGER.warn(error);
            ItemIconToast.show((Component)Component.m_237115_((String)"toast.generalfeedback.send_fail.title"), (Component)Component.m_237115_((String)"toast.generalfeedback.send_fail.desc"), new ItemStack((ItemLike)Items.f_42451_));
        });
    }

    public static void openFeedbackScreenOf(String id) {
        if (EntryCache.UnitMapCache.containsKey(id)) {
            Minecraft.m_91087_().m_91152_((Screen)new FeedbackScreen(EntryCache.UnitMapCache.get(id)));
        }
    }
}

