/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.provider;

import com.sighs.generalfeedback.api.FeedbackProvider;
import com.sighs.generalfeedback.init.Entry;
import com.sighs.generalfeedback.init.Form;
import com.sighs.generalfeedback.utils.FeedbackUtils;
import com.sighs.generalfeedback.utils.HttpUtil;
import java.util.HashMap;

public class GiteeFeedbackProvider
implements FeedbackProvider {
    @Override
    public boolean supports(Entry entry) {
        return entry.url.contains("gitee.com/api/v5");
    }

    @Override
    public void sendFeedback(Entry entry, Form form) {
        String rest;
        String[] parts;
        FeedbackUtils.showSendingToast();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String title = FeedbackUtils.generateIssueTitle(form);
        String body = FeedbackUtils.generateIssueBody(form);
        Object apiUrl = entry.url;
        String repoFromUrl = null;
        String prefix = "https://gitee.com/api/v5/repos/";
        if (((String)apiUrl).startsWith("https://gitee.com/api/v5/repos/") && (parts = (rest = ((String)apiUrl).substring("https://gitee.com/api/v5/repos/".length())).split("/")).length >= 3 && "issues".equals(parts[2])) {
            apiUrl = "https://gitee.com/api/v5/repos/" + parts[0] + "/issues";
            repoFromUrl = parts[1];
        }
        String jsonBody = "{\"access_token\":\"" + entry.token + "\",\"title\":\"" + FeedbackUtils.escapeJson(title) + "\",\"body\":\"" + FeedbackUtils.escapeJson(body) + "\"" + (String)(repoFromUrl != null ? ",\"repo\":\"" + FeedbackUtils.escapeJson(repoFromUrl) + "\"" : "") + "}";
        HttpUtil.fetch((String)apiUrl, "POST", headers, jsonBody, null, 5000, response -> FeedbackUtils.handleSuccess(response, entry.id), FeedbackUtils::handleFailure);
    }
}

